/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ContextRuntimeException;
import org.apache.juneau.Value;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.http.annotation.Content;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.HasFormData;
import org.apache.juneau.http.annotation.HasQuery;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Items;
import org.apache.juneau.http.annotation.ItemsAnnotation;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.Schema;
import org.apache.juneau.http.annotation.SchemaAnnotation;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.http.annotation.SubItems;
import org.apache.juneau.http.annotation.SubItemsAnnotation;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartDataType;
import org.apache.juneau.httppart.HttpPartFormat;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ListBuilder;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ParamInfo;

public class HttpPartSchema {
    public static final HttpPartSchema DEFAULT = HttpPartSchema.create().allowEmptyValue(true).build();
    public static final HttpPartSchema T_BOOLEAN = HttpPartSchema.tBoolean().build();
    public static final HttpPartSchema T_FILE = HttpPartSchema.tFile().build();
    public static final HttpPartSchema T_INTEGER = HttpPartSchema.tInteger().build();
    public static final HttpPartSchema T_INT32 = HttpPartSchema.tInt32().build();
    public static final HttpPartSchema T_INT64 = HttpPartSchema.tInt64().build();
    public static final HttpPartSchema T_NONE = HttpPartSchema.tNone().build();
    public static final HttpPartSchema T_NUMBER = HttpPartSchema.tNumber().build();
    public static final HttpPartSchema T_FLOAT = HttpPartSchema.tFloat().build();
    public static final HttpPartSchema T_DOUBLE = HttpPartSchema.tDouble().build();
    public static final HttpPartSchema T_STRING = HttpPartSchema.tString().build();
    public static final HttpPartSchema T_BYTE = HttpPartSchema.tByte().build();
    public static final HttpPartSchema T_BINARY = HttpPartSchema.tBinary().build();
    public static final HttpPartSchema T_BINARY_SPACED = HttpPartSchema.tBinarySpaced().build();
    public static final HttpPartSchema T_DATE = HttpPartSchema.tDate().build();
    public static final HttpPartSchema T_DATETIME = HttpPartSchema.tDateTime().build();
    public static final HttpPartSchema T_UON = HttpPartSchema.tUon().build();
    public static final HttpPartSchema T_ARRAY = HttpPartSchema.tArray().build();
    public static final HttpPartSchema T_ARRAY_CSV = HttpPartSchema.tArrayCsv().build();
    public static final HttpPartSchema T_ARRAY_PIPES = HttpPartSchema.tArrayPipes().build();
    public static final HttpPartSchema T_ARRAY_SSV = HttpPartSchema.tArraySsv().build();
    public static final HttpPartSchema T_ARRAY_TSV = HttpPartSchema.tArrayTsv().build();
    public static final HttpPartSchema T_ARRAY_UON = HttpPartSchema.tArrayUon().build();
    public static final HttpPartSchema T_ARRAY_MULTI = HttpPartSchema.tArrayMulti().build();
    public static final HttpPartSchema T_OBJECT = HttpPartSchema.tObject().build();
    public static final HttpPartSchema T_OBJECT_CSV = HttpPartSchema.tObjectCsv().build();
    public static final HttpPartSchema T_OBJECT_PIPES = HttpPartSchema.tObjectPipes().build();
    public static final HttpPartSchema T_OBJECT_SSV = HttpPartSchema.tObjectSsv().build();
    public static final HttpPartSchema T_OBJECT_TSV = HttpPartSchema.tObjectTsv().build();
    public static final HttpPartSchema T_OBJECT_UON = HttpPartSchema.tObjectUon().build();
    final String name;
    final String _default;
    final Set<String> _enum;
    final Map<String, HttpPartSchema> properties;
    final boolean allowEmptyValue;
    final boolean exclusiveMaximum;
    final boolean exclusiveMinimum;
    final boolean required;
    final boolean uniqueItems;
    final boolean skipIfEmpty;
    final HttpPartCollectionFormat collectionFormat;
    final HttpPartDataType type;
    final HttpPartFormat format;
    final Pattern pattern;
    final HttpPartSchema items;
    final HttpPartSchema additionalProperties;
    final Number maximum;
    final Number minimum;
    final Number multipleOf;
    final Long maxLength;
    final Long minLength;
    final Long maxItems;
    final Long minItems;
    final Long maxProperties;
    final Long minProperties;
    final Class<? extends HttpPartParser> parser;
    final Class<? extends HttpPartSerializer> serializer;
    final ClassMeta<?> parsedType;

    public static Builder create() {
        return new Builder();
    }

    public static Builder tBoolean() {
        return HttpPartSchema.create().tBoolean();
    }

    public static Builder tFile() {
        return HttpPartSchema.create().tFile();
    }

    public static Builder tInteger() {
        return HttpPartSchema.create().tInteger();
    }

    public static Builder tInt32() {
        return HttpPartSchema.create().tInteger().fInt32();
    }

    public static Builder tInt64() {
        return HttpPartSchema.create().tInteger().fInt64();
    }

    public static Builder tNone() {
        return HttpPartSchema.create().tNone();
    }

    public static Builder tNumber() {
        return HttpPartSchema.create().tNumber();
    }

    public static Builder tFloat() {
        return HttpPartSchema.create().tNumber().fFloat();
    }

    public static Builder tDouble() {
        return HttpPartSchema.create().tNumber().fDouble();
    }

    public static Builder tString() {
        return HttpPartSchema.create().tString();
    }

    public static Builder tByte() {
        return HttpPartSchema.create().tString().fByte();
    }

    public static Builder tBinary() {
        return HttpPartSchema.create().tString().fBinary();
    }

    public static Builder tBinarySpaced() {
        return HttpPartSchema.create().tString().fBinarySpaced();
    }

    public static Builder tDate() {
        return HttpPartSchema.create().tString().fDate();
    }

    public static Builder tDateTime() {
        return HttpPartSchema.create().tString().fDateTime();
    }

    public static Builder tUon() {
        return HttpPartSchema.create().tString().fUon();
    }

    public static Builder tArray() {
        return HttpPartSchema.create().tArray();
    }

    public static Builder tArray(Builder items) {
        return HttpPartSchema.create().tArray().items(items);
    }

    public static Builder tArrayCsv() {
        return HttpPartSchema.create().tArray().cfCsv();
    }

    public static Builder tArrayCsv(Builder items) {
        return HttpPartSchema.create().tArray().cfCsv().items(items);
    }

    public static Builder tArrayPipes() {
        return HttpPartSchema.create().tArray().cfPipes();
    }

    public static Builder tArrayPipes(Builder items) {
        return HttpPartSchema.create().tArray().cfPipes().items(items);
    }

    public static Builder tArraySsv() {
        return HttpPartSchema.create().tArray().cfSsv();
    }

    public static Builder tArraySsv(Builder items) {
        return HttpPartSchema.create().tArray().cfSsv().items(items);
    }

    public static Builder tArrayTsv() {
        return HttpPartSchema.create().tArray().cfTsv();
    }

    public static Builder tArrayTsv(Builder items) {
        return HttpPartSchema.create().tArray().cfTsv().items(items);
    }

    public static Builder tArrayUon() {
        return HttpPartSchema.create().tArray().cfUon();
    }

    public static Builder tArrayUon(Builder items) {
        return HttpPartSchema.create().tArray().cfUon().items(items);
    }

    public static Builder tArrayMulti() {
        return HttpPartSchema.create().tArray().cfMulti();
    }

    public static Builder tArrayMulti(Builder items) {
        return HttpPartSchema.create().tArray().cfMulti().items(items);
    }

    public static Builder tObject() {
        return HttpPartSchema.create().tObject();
    }

    public static Builder tObjectCsv() {
        return HttpPartSchema.create().tObject().cfCsv();
    }

    public static Builder tObjectPipes() {
        return HttpPartSchema.create().tObject().cfPipes();
    }

    public static Builder tObjectSsv() {
        return HttpPartSchema.create().tObject().cfSsv();
    }

    public static Builder tObjectTsv() {
        return HttpPartSchema.create().tObject().cfTsv();
    }

    public static Builder tObjectUon() {
        return HttpPartSchema.create().tObject().cfUon();
    }

    public static HttpPartSchema create(Class<? extends Annotation> c, ParamInfo mpi) {
        return HttpPartSchema.create().applyAll(c, mpi).build();
    }

    public static HttpPartSchema create(Class<? extends Annotation> c, Method m) {
        return HttpPartSchema.create().applyAll(c, m).build();
    }

    public static HttpPartSchema create(Class<? extends Annotation> c, Type t) {
        return HttpPartSchema.create().applyAll(c, t).build();
    }

    public static Builder create(String type) {
        return HttpPartSchema.create().type(type);
    }

    public static Builder create(String type, String format) {
        return HttpPartSchema.create().type(type).format(format);
    }

    public static HttpPartSchema create(Annotation a) {
        return HttpPartSchema.create().apply(a).build();
    }

    public static HttpPartSchema create(Annotation a, String defaultName) {
        return HttpPartSchema.create().name(defaultName).apply(a).build();
    }

    HttpPartSchema(Builder b) {
        this.name = b.name;
        this._default = b._default;
        this._enum = HttpPartSchema.copy(b._enum);
        this.properties = HttpPartSchema.build(b.properties, b.noValidate);
        this.allowEmptyValue = this.resolve(b.allowEmptyValue);
        this.exclusiveMaximum = this.resolve(b.exclusiveMaximum);
        this.exclusiveMinimum = this.resolve(b.exclusiveMinimum);
        this.required = this.resolve(b.required);
        this.uniqueItems = this.resolve(b.uniqueItems);
        this.skipIfEmpty = this.resolve(b.skipIfEmpty);
        this.collectionFormat = b.collectionFormat;
        this.type = b.type;
        this.format = b.format;
        this.pattern = b.pattern;
        this.items = HttpPartSchema.build(b.items, b.noValidate);
        this.additionalProperties = HttpPartSchema.build(b.additionalProperties, b.noValidate);
        this.maximum = b.maximum;
        this.minimum = b.minimum;
        this.multipleOf = b.multipleOf;
        this.maxItems = b.maxItems;
        this.maxLength = b.maxLength;
        this.maxProperties = b.maxProperties;
        this.minItems = b.minItems;
        this.minLength = b.minLength;
        this.minProperties = b.minProperties;
        this.parser = b.parser;
        this.serializer = b.serializer;
        Class parsedType = Object.class;
        if (this.type == HttpPartDataType.ARRAY) {
            if (this.items != null) {
                parsedType = Array.newInstance(this.items.parsedType.getInnerClass(), 0).getClass();
            }
        } else if (this.type == HttpPartDataType.BOOLEAN) {
            parsedType = Boolean.class;
        } else if (this.type == HttpPartDataType.INTEGER) {
            parsedType = this.format == HttpPartFormat.INT64 ? Long.class : Integer.class;
        } else if (this.type == HttpPartDataType.NUMBER) {
            parsedType = this.format == HttpPartFormat.DOUBLE ? Double.class : Float.class;
        } else if (this.type == HttpPartDataType.STRING) {
            parsedType = this.format == HttpPartFormat.BYTE || this.format == HttpPartFormat.BINARY || this.format == HttpPartFormat.BINARY_SPACED ? byte[].class : (this.format == HttpPartFormat.DATE || this.format == HttpPartFormat.DATE_TIME ? Calendar.class : String.class);
        }
        this.parsedType = BeanContext.DEFAULT.getClassMeta(parsedType);
        if (b.noValidate) {
            return;
        }
        ArrayList<String> errors = CollectionUtils.list(new String[0]);
        ListBuilder<String> notAllowed = CollectionUtils.listBuilder(String.class, new Type[0]);
        boolean invalidFormat = false;
        switch (this.type) {
            case STRING: {
                notAllowed.addIf(this.properties != null, "properties").addIf(this.additionalProperties != null, "additionalProperties").addIf(this.exclusiveMaximum, "exclusiveMaximum").addIf(this.exclusiveMinimum, "exclusiveMinimum").addIf(this.uniqueItems, "uniqueItems").addIf(this.collectionFormat != HttpPartCollectionFormat.NO_COLLECTION_FORMAT, "collectionFormat").addIf(this.items != null, "items").addIf(this.maximum != null, "maximum").addIf(this.minimum != null, "minimum").addIf(this.multipleOf != null, "multipleOf").addIf(this.maxItems != null, "maxItems").addIf(this.minItems != null, "minItems").addIf(this.minProperties != null, "minProperties");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.BYTE, HttpPartFormat.BINARY, HttpPartFormat.BINARY_SPACED, HttpPartFormat.DATE, HttpPartFormat.DATE_TIME, HttpPartFormat.PASSWORD, HttpPartFormat.UON, HttpPartFormat.NO_FORMAT);
                break;
            }
            case ARRAY: {
                notAllowed.addIf(this.properties != null, "properties").addIf(this.additionalProperties != null, "additionalProperties").addIf(this.exclusiveMaximum, "exclusiveMaximum").addIf(this.exclusiveMinimum, "exclusiveMinimum").addIf(this.pattern != null, "pattern").addIf(this.maximum != null, "maximum").addIf(this.minimum != null, "minimum").addIf(this.multipleOf != null, "multipleOf").addIf(this.maxLength != null, "maxLength").addIf(this.minLength != null, "minLength").addIf(this.maxProperties != null, "maxProperties").addIf(this.minProperties != null, "minProperties");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.NO_FORMAT, HttpPartFormat.UON);
                break;
            }
            case BOOLEAN: {
                notAllowed.addIf(!this._enum.isEmpty(), "_enum").addIf(this.properties != null, "properties").addIf(this.additionalProperties != null, "additionalProperties").addIf(this.exclusiveMaximum, "exclusiveMaximum").addIf(this.exclusiveMinimum, "exclusiveMinimum").addIf(this.uniqueItems, "uniqueItems").addIf(this.collectionFormat != HttpPartCollectionFormat.NO_COLLECTION_FORMAT, "collectionFormat").addIf(this.pattern != null, "pattern").addIf(this.items != null, "items").addIf(this.maximum != null, "maximum").addIf(this.minimum != null, "minimum").addIf(this.multipleOf != null, "multipleOf").addIf(this.maxItems != null, "maxItems").addIf(this.maxLength != null, "maxLength").addIf(this.maxProperties != null, "maxProperties").addIf(this.minItems != null, "minItems").addIf(this.minLength != null, "minLength").addIf(this.minProperties != null, "minProperties");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.NO_FORMAT, HttpPartFormat.UON);
                break;
            }
            case FILE: {
                break;
            }
            case INTEGER: {
                notAllowed.addIf(this.properties != null, "properties").addIf(this.additionalProperties != null, "additionalProperties").addIf(this.uniqueItems, "uniqueItems").addIf(this.collectionFormat != HttpPartCollectionFormat.NO_COLLECTION_FORMAT, "collectionFormat").addIf(this.pattern != null, "pattern").addIf(this.items != null, "items").addIf(this.maxItems != null, "maxItems").addIf(this.maxLength != null, "maxLength").addIf(this.maxProperties != null, "maxProperties").addIf(this.minItems != null, "minItems").addIf(this.minLength != null, "minLength").addIf(this.minProperties != null, "minProperties");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.NO_FORMAT, HttpPartFormat.UON, HttpPartFormat.INT32, HttpPartFormat.INT64);
                break;
            }
            case NUMBER: {
                notAllowed.addIf(this.properties != null, "properties").addIf(this.additionalProperties != null, "additionalProperties").addIf(this.uniqueItems, "uniqueItems").addIf(this.collectionFormat != HttpPartCollectionFormat.NO_COLLECTION_FORMAT, "collectionFormat").addIf(this.pattern != null, "pattern").addIf(this.items != null, "items").addIf(this.maxItems != null, "maxItems").addIf(this.maxLength != null, "maxLength").addIf(this.maxProperties != null, "maxProperties").addIf(this.minItems != null, "minItems").addIf(this.minLength != null, "minLength").addIf(this.minProperties != null, "minProperties");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.NO_FORMAT, HttpPartFormat.UON, HttpPartFormat.FLOAT, HttpPartFormat.DOUBLE);
                break;
            }
            case OBJECT: {
                notAllowed.addIf(this.exclusiveMaximum, "exclusiveMaximum").addIf(this.exclusiveMinimum, "exclusiveMinimum").addIf(this.uniqueItems, "uniqueItems").addIf(this.pattern != null, "pattern").addIf(this.items != null, "items").addIf(this.maximum != null, "maximum").addIf(this.minimum != null, "minimum").addIf(this.multipleOf != null, "multipleOf").addIf(this.maxItems != null, "maxItems").addIf(this.maxLength != null, "maxLength").addIf(this.minItems != null, "minItems").addIf(this.minLength != null, "minLength");
                invalidFormat = !this.format.isOneOf(HttpPartFormat.NO_FORMAT);
                break;
            }
        }
        List<String> notAllowed2 = notAllowed.build();
        if (!notAllowed2.isEmpty()) {
            errors.add("Attributes not allow for type='" + (Object)((Object)this.type) + "': " + StringUtils.join(notAllowed2, ","));
        }
        if (invalidFormat) {
            errors.add("Invalid format for type='" + (Object)((Object)this.type) + "': '" + (Object)((Object)this.format) + "'");
        }
        if (this.exclusiveMaximum && this.maximum == null) {
            errors.add("Cannot specify exclusiveMaximum with maximum.");
        }
        if (this.exclusiveMinimum && this.minimum == null) {
            errors.add("Cannot specify exclusiveMinimum with minimum.");
        }
        if (this.required && this._default != null) {
            errors.add("Cannot specify a default value on a required value.");
        }
        if (this.minLength != null && this.maxLength != null && this.maxLength < this.minLength) {
            errors.add("maxLength cannot be less than minLength.");
        }
        if (this.minimum != null && this.maximum != null && this.maximum.doubleValue() < this.minimum.doubleValue()) {
            errors.add("maximum cannot be less than minimum.");
        }
        if (this.minItems != null && this.maxItems != null && this.maxItems < this.minItems) {
            errors.add("maxItems cannot be less than minItems.");
        }
        if (this.minProperties != null && this.maxProperties != null && this.maxProperties < this.minProperties) {
            errors.add("maxProperties cannot be less than minProperties.");
        }
        if (this.minLength != null && this.minLength < 0L) {
            errors.add("minLength cannot be less than zero.");
        }
        if (this.maxLength != null && this.maxLength < 0L) {
            errors.add("maxLength cannot be less than zero.");
        }
        if (this.minItems != null && this.minItems < 0L) {
            errors.add("minItems cannot be less than zero.");
        }
        if (this.maxItems != null && this.maxItems < 0L) {
            errors.add("maxItems cannot be less than zero.");
        }
        if (this.minProperties != null && this.minProperties < 0L) {
            errors.add("minProperties cannot be less than zero.");
        }
        if (this.maxProperties != null && this.maxProperties < 0L) {
            errors.add("maxProperties cannot be less than zero.");
        }
        if (this.type == HttpPartDataType.ARRAY && this.items != null && this.items.getType() == HttpPartDataType.OBJECT && this.format != HttpPartFormat.UON && this.format != HttpPartFormat.NO_FORMAT) {
            errors.add("Cannot define an array of objects unless array format is 'uon'.");
        }
        if (!errors.isEmpty()) {
            throw new ContextRuntimeException("Schema specification errors: \n\t" + StringUtils.join(errors, "\n\t"), new Object[0]);
        }
    }

    public ClassMeta<?> getParsedType() {
        return this.parsedType;
    }

    public String getName() {
        return this.name;
    }

    public HttpPartDataType getType() {
        return this.type;
    }

    public HttpPartDataType getType(ClassMeta<?> cm) {
        if (this.type != HttpPartDataType.NO_TYPE) {
            return this.type;
        }
        if (cm.isTemporal() || cm.isDateOrCalendar()) {
            return HttpPartDataType.STRING;
        }
        if (cm.isNumber()) {
            if (cm.isDecimal()) {
                return HttpPartDataType.NUMBER;
            }
            return HttpPartDataType.INTEGER;
        }
        if (cm.isBoolean()) {
            return HttpPartDataType.BOOLEAN;
        }
        if (cm.isMapOrBean()) {
            return HttpPartDataType.OBJECT;
        }
        if (cm.isCollectionOrArray()) {
            return HttpPartDataType.ARRAY;
        }
        return HttpPartDataType.STRING;
    }

    public String getDefault() {
        return this._default;
    }

    public HttpPartCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    public HttpPartFormat getFormat() {
        return this.format;
    }

    public HttpPartFormat getFormat(ClassMeta<?> cm) {
        if (this.format != HttpPartFormat.NO_FORMAT) {
            return this.format;
        }
        if (cm.isNumber()) {
            if (cm.isDecimal()) {
                if (cm.isDouble()) {
                    return HttpPartFormat.DOUBLE;
                }
                return HttpPartFormat.FLOAT;
            }
            if (cm.isLong()) {
                return HttpPartFormat.INT64;
            }
            return HttpPartFormat.INT32;
        }
        return this.format;
    }

    public HttpPartSchema getItems() {
        return this.items;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Long getMaxLength() {
        return this.maxLength;
    }

    public Long getMinLength() {
        return this.minLength;
    }

    public Long getMaxItems() {
        return this.maxItems;
    }

    public Long getMinItems() {
        return this.minItems;
    }

    public Long getMaxProperties() {
        return this.maxProperties;
    }

    public Long getMinProperties() {
        return this.minProperties;
    }

    public boolean isExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public boolean isExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public boolean isUniqueItems() {
        return this.uniqueItems;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isSkipIfEmpty() {
        return this.skipIfEmpty;
    }

    public boolean isAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public Set<String> getEnum() {
        return this._enum;
    }

    public Class<? extends HttpPartParser> getParser() {
        return this.parser;
    }

    public Class<? extends HttpPartSerializer> getSerializer() {
        return this.serializer;
    }

    public String validateInput(String in) throws SchemaValidationException {
        if (!this.isValidRequired(in)) {
            throw new SchemaValidationException("No value specified.", new Object[0]);
        }
        if (in != null) {
            if (!this.isValidAllowEmpty(in)) {
                throw new SchemaValidationException("Empty value not allowed.", new Object[0]);
            }
            if (!this.isValidPattern(in)) {
                throw new SchemaValidationException("Value does not match expected pattern.  Must match pattern: {0}", this.pattern.pattern());
            }
            if (!this.isValidEnum(in)) {
                throw new SchemaValidationException("Value does not match one of the expected values.  Must be one of the following:  {0}", StringUtils.cdl(this._enum));
            }
            if (!this.isValidMaxLength(in)) {
                throw new SchemaValidationException("Maximum length of value exceeded.", new Object[0]);
            }
            if (!this.isValidMinLength(in)) {
                throw new SchemaValidationException("Minimum length of value not met.", new Object[0]);
            }
        }
        return in;
    }

    public <T> T validateOutput(T o, BeanContext bc) throws SchemaValidationException {
        if (o == null) {
            if (!this.isValidRequired(o)) {
                throw new SchemaValidationException("Required value not provided.", new Object[0]);
            }
            return o;
        }
        ClassMeta<T> cm = bc.getClassMetaForObject(o);
        switch (this.getType(cm)) {
            case ARRAY: {
                if (cm.isArray()) {
                    if (!this.isValidMinItems(o)) {
                        throw new SchemaValidationException("Minimum number of items not met.", new Object[0]);
                    }
                    if (!this.isValidMaxItems(o)) {
                        throw new SchemaValidationException("Maximum number of items exceeded.", new Object[0]);
                    }
                    if (!this.isValidUniqueItems(o)) {
                        throw new SchemaValidationException("Duplicate items not allowed.", new Object[0]);
                    }
                    HttpPartSchema items = this.getItems();
                    if (items == null) break;
                    for (int i = 0; i < Array.getLength(o); ++i) {
                        items.validateOutput(Array.get(o, i), bc);
                    }
                    break;
                }
                if (!cm.isCollection()) break;
                Collection c = (Collection)o;
                if (!this.isValidMinItems(c)) {
                    throw new SchemaValidationException("Minimum number of items not met.", new Object[0]);
                }
                if (!this.isValidMaxItems(c)) {
                    throw new SchemaValidationException("Maximum number of items exceeded.", new Object[0]);
                }
                if (!this.isValidUniqueItems(c)) {
                    throw new SchemaValidationException("Duplicate items not allowed.", new Object[0]);
                }
                HttpPartSchema items = this.getItems();
                if (items == null) break;
                c.forEach(x -> items.validateOutput(x, bc));
                break;
            }
            case INTEGER: {
                if (!cm.isNumber()) break;
                Number n = (Number)o;
                if (!this.isValidMinimum(n)) {
                    throw new SchemaValidationException("Minimum value not met.", new Object[0]);
                }
                if (!this.isValidMaximum(n)) {
                    throw new SchemaValidationException("Maximum value exceeded.", new Object[0]);
                }
                if (this.isValidMultipleOf(n)) break;
                throw new SchemaValidationException("Multiple-of not met.", new Object[0]);
            }
            case NUMBER: {
                if (!cm.isNumber()) break;
                Number n = (Number)o;
                if (!this.isValidMinimum(n)) {
                    throw new SchemaValidationException("Minimum value not met.", new Object[0]);
                }
                if (!this.isValidMaximum(n)) {
                    throw new SchemaValidationException("Maximum value exceeded.", new Object[0]);
                }
                if (this.isValidMultipleOf(n)) break;
                throw new SchemaValidationException("Multiple-of not met.", new Object[0]);
            }
            case OBJECT: {
                if (cm.isMapOrBean()) {
                    BeanMap<T> m;
                    BeanMap<T> beanMap = m = cm.isMap() ? (BeanMap<T>)o : bc.toBeanMap(o);
                    if (!this.isValidMinProperties(m)) {
                        throw new SchemaValidationException("Minimum number of properties not met.", new Object[0]);
                    }
                    if (!this.isValidMaxProperties(m)) {
                        throw new SchemaValidationException("Maximum number of properties exceeded.", new Object[0]);
                    }
                    m.forEach((k, v) -> {
                        String key = k.toString();
                        HttpPartSchema s2 = this.getProperty(key);
                        if (s2 != null) {
                            s2.validateOutput(v, bc);
                        }
                    });
                    break;
                }
                if (!cm.isBean()) break;
                break;
            }
        }
        return o;
    }

    private boolean isValidRequired(Object x) {
        return x != null || !this.required;
    }

    private boolean isValidMinProperties(Map<?, ?> x) {
        return this.minProperties == null || (long)x.size() >= this.minProperties;
    }

    private boolean isValidMaxProperties(Map<?, ?> x) {
        return this.maxProperties == null || (long)x.size() <= this.maxProperties;
    }

    private boolean isValidMinimum(Number x) {
        if (x instanceof Integer || x instanceof AtomicInteger) {
            return this.minimum == null || x.intValue() > this.minimum.intValue() || x.intValue() == this.minimum.intValue() && !this.exclusiveMinimum;
        }
        if (x instanceof Short || x instanceof Byte) {
            return this.minimum == null || x.shortValue() > this.minimum.shortValue() || x.intValue() == this.minimum.shortValue() && !this.exclusiveMinimum;
        }
        if (x instanceof Long || x instanceof AtomicLong || x instanceof BigInteger) {
            return this.minimum == null || x.longValue() > this.minimum.longValue() || (long)x.intValue() == this.minimum.longValue() && !this.exclusiveMinimum;
        }
        if (x instanceof Float) {
            return this.minimum == null || x.floatValue() > this.minimum.floatValue() || x.floatValue() == this.minimum.floatValue() && !this.exclusiveMinimum;
        }
        if (x instanceof Double || x instanceof BigDecimal) {
            return this.minimum == null || x.doubleValue() > this.minimum.doubleValue() || x.doubleValue() == this.minimum.doubleValue() && !this.exclusiveMinimum;
        }
        return true;
    }

    private boolean isValidMaximum(Number x) {
        if (x instanceof Integer || x instanceof AtomicInteger) {
            return this.maximum == null || x.intValue() < this.maximum.intValue() || x.intValue() == this.maximum.intValue() && !this.exclusiveMaximum;
        }
        if (x instanceof Short || x instanceof Byte) {
            return this.maximum == null || x.shortValue() < this.maximum.shortValue() || x.intValue() == this.maximum.shortValue() && !this.exclusiveMaximum;
        }
        if (x instanceof Long || x instanceof AtomicLong || x instanceof BigInteger) {
            return this.maximum == null || x.longValue() < this.maximum.longValue() || (long)x.intValue() == this.maximum.longValue() && !this.exclusiveMaximum;
        }
        if (x instanceof Float) {
            return this.maximum == null || x.floatValue() < this.maximum.floatValue() || x.floatValue() == this.maximum.floatValue() && !this.exclusiveMaximum;
        }
        if (x instanceof Double || x instanceof BigDecimal) {
            return this.maximum == null || x.doubleValue() < this.maximum.doubleValue() || x.doubleValue() == this.maximum.doubleValue() && !this.exclusiveMaximum;
        }
        return true;
    }

    private boolean isValidMultipleOf(Number x) {
        if (x instanceof Integer || x instanceof AtomicInteger) {
            return this.multipleOf == null || x.intValue() % this.multipleOf.intValue() == 0;
        }
        if (x instanceof Short || x instanceof Byte) {
            return this.multipleOf == null || x.shortValue() % this.multipleOf.shortValue() == 0;
        }
        if (x instanceof Long || x instanceof AtomicLong || x instanceof BigInteger) {
            return this.multipleOf == null || x.longValue() % this.multipleOf.longValue() == 0L;
        }
        if (x instanceof Float) {
            return this.multipleOf == null || x.floatValue() % this.multipleOf.floatValue() == 0.0f;
        }
        if (x instanceof Double || x instanceof BigDecimal) {
            return this.multipleOf == null || x.doubleValue() % this.multipleOf.doubleValue() == 0.0;
        }
        return true;
    }

    private boolean isValidAllowEmpty(String x) {
        return this.allowEmptyValue || StringUtils.isNotEmpty(x);
    }

    private boolean isValidPattern(String x) {
        return this.pattern == null || this.pattern.matcher(x).matches();
    }

    private boolean isValidEnum(String x) {
        return this._enum.isEmpty() || this._enum.contains(x);
    }

    private boolean isValidMinLength(String x) {
        return this.minLength == null || (long)x.length() >= this.minLength;
    }

    private boolean isValidMaxLength(String x) {
        return this.maxLength == null || (long)x.length() <= this.maxLength;
    }

    private boolean isValidMinItems(Object x) {
        return this.minItems == null || (long)Array.getLength(x) >= this.minItems;
    }

    private boolean isValidMaxItems(Object x) {
        return this.maxItems == null || (long)Array.getLength(x) <= this.maxItems;
    }

    private boolean isValidUniqueItems(Object x) {
        if (this.uniqueItems) {
            HashSet<Object> s = new HashSet<Object>();
            for (int i = 0; i < Array.getLength(x); ++i) {
                Object o = Array.get(x, i);
                if (s.add(o)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidMinItems(Collection<?> x) {
        return this.minItems == null || (long)x.size() >= this.minItems;
    }

    private boolean isValidMaxItems(Collection<?> x) {
        return this.maxItems == null || (long)x.size() <= this.maxItems;
    }

    private boolean isValidUniqueItems(Collection<?> x) {
        if (this.uniqueItems && !(x instanceof Set)) {
            HashSet s = new HashSet();
            for (Object o : x) {
                if (s.add(o)) continue;
                return false;
            }
        }
        return true;
    }

    public HttpPartSchema getProperty(String name) {
        HttpPartSchema schema;
        if (this.properties != null && (schema = this.properties.get(name)) != null) {
            return schema;
        }
        return this.additionalProperties;
    }

    public boolean hasProperties() {
        return this.properties != null || this.additionalProperties != null;
    }

    private static <T> Set<T> copy(Set<T> in) {
        return in == null ? Collections.emptySet() : CollectionUtils.unmodifiable(CollectionUtils.copyOf(in));
    }

    private static Map<String, HttpPartSchema> build(Map<String, Object> in, boolean noValidate) {
        if (in == null) {
            return null;
        }
        LinkedHashMap m = CollectionUtils.map();
        in.forEach((k, v) -> m.put(k, HttpPartSchema.build(v, noValidate)));
        return CollectionUtils.unmodifiable(m);
    }

    private static HttpPartSchema build(Object in, boolean noValidate) {
        if (in == null) {
            return null;
        }
        if (in instanceof HttpPartSchema) {
            return (HttpPartSchema)in;
        }
        return ((Builder)in).noValidate(noValidate).build();
    }

    private boolean resolve(Boolean b) {
        return b == null ? false : b;
    }

    static final Set<String> toSet(String[] ... s) {
        boolean isNotEmpty = false;
        for (String[] ss : s) {
            isNotEmpty |= ss.length > 0;
        }
        if (!isNotEmpty) {
            return null;
        }
        LinkedHashSet<String> set = CollectionUtils.set(new String[0]);
        for (String[] ss : s) {
            if (ss == null) continue;
            for (String ss2 : ss) {
                StringUtils.split(ss2, x -> set.add((String)x));
            }
        }
        return set.isEmpty() ? null : set;
    }

    static final Set<String> toSet(String s) {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        LinkedHashSet<String> set = CollectionUtils.set(new String[0]);
        try {
            StringUtils.parseListOrCdl(s).forEach(x -> set.add(x.toString()));
        }
        catch (ParseException e) {
            throw ThrowableUtils.runtimeException(e);
        }
        return set;
    }

    static final Number toNumber(String ... s) {
        try {
            for (String ss : s) {
                if (!StringUtils.isNotEmpty(ss)) continue;
                return StringUtils.parseNumber(ss, Number.class);
            }
            return null;
        }
        catch (ParseException e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }

    static final JsonMap toJsonMap(String[] ss) {
        String s = StringUtils.joinnl(ss);
        if (s.isEmpty()) {
            return null;
        }
        if (!StringUtils.isJsonObject(s, true)) {
            s = "{" + s + "}";
        }
        try {
            return JsonMap.ofJson(s);
        }
        catch (ParseException e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }

    public String toString() {
        try {
            Predicate<Object> ne = x -> StringUtils.isNotEmpty(StringUtils.stringify(x));
            Predicate<Boolean> nf = ObjectUtils::isTrue;
            Predicate<Number> nm1 = ObjectUtils::isNotMinusOne;
            Predicate<Object> nn = ObjectUtils::isNotNull;
            JsonMap m = new JsonMap().appendIf(ne, "name", this.name).appendIf(ne, "type", this.type).appendIf(ne, "format", this.format).appendIf(ne, "default", this._default).appendIf(ne, "enum", this._enum).appendIf(ne, "properties", this.properties).appendIf(nf, "allowEmptyValue", this.allowEmptyValue).appendIf(nf, "exclusiveMaximum", this.exclusiveMaximum).appendIf(nf, "exclusiveMinimum", this.exclusiveMinimum).appendIf(nf, "required", this.required).appendIf(nf, "uniqueItems", this.uniqueItems).appendIf(nf, "skipIfEmpty", this.skipIfEmpty).appendIf(x -> x != HttpPartCollectionFormat.NO_COLLECTION_FORMAT, "collectionFormat", this.collectionFormat).appendIf(ne, "pattern", this.pattern).appendIf(nn, "items", this.items).appendIf(nn, "additionalProperties", this.additionalProperties).appendIf(nm1, "maximum", this.maximum).appendIf(nm1, "minimum", this.minimum).appendIf(nm1, "multipleOf", this.multipleOf).appendIf(nm1, "maxLength", this.maxLength).appendIf(nm1, "minLength", this.minLength).appendIf(nm1, "maxItems", this.maxItems).appendIf(nm1, "minItems", this.minItems).appendIf(nm1, "maxProperties", this.maxProperties).appendIf(nm1, "minProperties", this.minProperties).append("parsedType", this.parsedType);
            return m.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static class Builder {
        String name;
        String _default;
        Set<Integer> codes;
        Set<String> _enum;
        Boolean allowEmptyValue;
        Boolean exclusiveMaximum;
        Boolean exclusiveMinimum;
        Boolean required;
        Boolean uniqueItems;
        Boolean skipIfEmpty;
        HttpPartCollectionFormat collectionFormat = HttpPartCollectionFormat.NO_COLLECTION_FORMAT;
        HttpPartDataType type = HttpPartDataType.NO_TYPE;
        HttpPartFormat format = HttpPartFormat.NO_FORMAT;
        Pattern pattern;
        Number maximum;
        Number minimum;
        Number multipleOf;
        Long maxLength;
        Long minLength;
        Long maxItems;
        Long minItems;
        Long maxProperties;
        Long minProperties;
        Map<String, Object> properties;
        Object items;
        Object additionalProperties;
        boolean noValidate;
        Class<? extends HttpPartParser> parser;
        Class<? extends HttpPartSerializer> serializer;

        public HttpPartSchema build() {
            return new HttpPartSchema(this);
        }

        Builder apply(Class<? extends Annotation> c, ParamInfo mpi) {
            this.apply(c, mpi.getParameterType().innerType());
            mpi.forEachDeclaredAnnotation(c, x -> true, x -> this.apply((Annotation)x));
            return this;
        }

        Builder applyAll(Class<? extends Annotation> c, ParamInfo mpi) {
            return this.apply(Schema.class, mpi).apply(c, mpi);
        }

        Builder apply(Class<? extends Annotation> c, Method m) {
            this.apply(c, m.getGenericReturnType());
            Annotation a = m.getAnnotation(c);
            if (a != null) {
                return this.apply(a);
            }
            return this;
        }

        Builder applyAll(Class<? extends Annotation> c, Method m) {
            return this.apply(Schema.class, m).apply(c, m);
        }

        Builder apply(Class<? extends Annotation> c, Type t) {
            if (t instanceof Class) {
                ClassInfo.of((Class)t).forEachAnnotation(c, x -> true, x -> this.apply((Annotation)x));
            } else if (Value.isType(t)) {
                this.apply(c, Value.getParameterType(t));
            }
            return this;
        }

        Builder applyAll(Class<? extends Annotation> c, Type t) {
            return this.apply(Schema.class, t).apply(c, t);
        }

        public Builder apply(Annotation a) {
            if (a instanceof Content) {
                this.apply((Content)a);
            } else if (a instanceof Header) {
                this.apply((Header)a);
            } else if (a instanceof FormData) {
                this.apply((FormData)a);
            } else if (a instanceof Query) {
                this.apply((Query)a);
            } else if (a instanceof Path) {
                this.apply((Path)a);
            } else if (a instanceof Response) {
                this.apply((Response)a);
            } else if (a instanceof StatusCode) {
                this.apply((StatusCode)a);
            } else if (a instanceof HasQuery) {
                this.apply((HasQuery)a);
            } else if (a instanceof HasFormData) {
                this.apply((HasFormData)a);
            } else if (a instanceof Schema) {
                this.apply((Schema)a);
            } else {
                throw ThrowableUtils.runtimeException("Builder.apply(@{0}) not defined", ClassUtils.className(a));
            }
            return this;
        }

        Builder apply(Content a) {
            if (!SchemaAnnotation.empty(a.schema())) {
                this.apply(a.schema());
            }
            return this;
        }

        Builder apply(Header a) {
            if (!SchemaAnnotation.empty(a.schema())) {
                this.apply(a.schema());
            }
            this.name(StringUtils.firstNonEmpty(a.name(), a.value()));
            this.parser(a.parser());
            this.serializer(a.serializer());
            return this;
        }

        Builder apply(FormData a) {
            if (!SchemaAnnotation.empty(a.schema())) {
                this.apply(a.schema());
            }
            this.name(StringUtils.firstNonEmpty(a.name(), a.value()));
            this.parser(a.parser());
            this.serializer(a.serializer());
            return this;
        }

        Builder apply(Query a) {
            if (!SchemaAnnotation.empty(a.schema())) {
                this.apply(a.schema());
            }
            this.name(StringUtils.firstNonEmpty(a.name(), a.value()));
            this.parser(a.parser());
            this.serializer(a.serializer());
            return this;
        }

        Builder apply(Path a) {
            if (!SchemaAnnotation.empty(a.schema())) {
                this.apply(a.schema());
            }
            this.name(StringUtils.firstNonEmpty(a.name(), a.value()));
            this.parser(a.parser());
            this.serializer(a.serializer());
            if (StringUtils.startsWith(this.name, '/')) {
                this.allowEmptyValue();
                this.required(false);
            } else if (this.required == null) {
                this.required(true);
            }
            return this;
        }

        Builder apply(Response a) {
            this.allowEmptyValue(true);
            this.apply(a.schema());
            this.parser(a.parser());
            this.required(false);
            this.serializer(a.serializer());
            return this;
        }

        Builder apply(StatusCode a) {
            this.codes(a.value());
            return this;
        }

        Builder apply(Items a) {
            this._default(this.joinnlOrNull(a._default(), a.df()));
            this._enum(this.toSet(a._enum(), a.e()));
            this.collectionFormat(StringUtils.firstNonEmpty(a.collectionFormat(), a.cf()));
            this.exclusiveMaximum(a.exclusiveMaximum() || a.emax());
            this.exclusiveMinimum(a.exclusiveMinimum() || a.emin());
            this.format(StringUtils.firstNonEmpty(a.format(), a.f()));
            this.items(a.items());
            this.maximum(this.toNumber(a.maximum(), a.max()));
            this.maxItems(this.firstNmo(a.maxItems(), a.maxi()));
            this.maxLength(this.firstNmo(a.maxLength(), a.maxl()));
            this.minimum(this.toNumber(a.minimum(), a.min()));
            this.minItems(this.firstNmo(a.minItems(), a.mini()));
            this.minLength(this.firstNmo(a.minLength(), a.minl()));
            this.multipleOf(this.toNumber(a.multipleOf(), a.mo()));
            this.pattern(StringUtils.firstNonEmpty(a.pattern(), a.p()));
            this.type(StringUtils.firstNonEmpty(a.type(), a.t()));
            this.uniqueItems(a.uniqueItems() || a.ui());
            return this;
        }

        Builder apply(SubItems a) {
            this._default(this.joinnlOrNull(a._default(), a.df()));
            this._enum(this.toSet(a._enum(), a.e()));
            this.collectionFormat(StringUtils.firstNonEmpty(a.collectionFormat(), a.cf()));
            this.exclusiveMaximum(a.exclusiveMaximum() || a.emax());
            this.exclusiveMinimum(a.exclusiveMinimum() || a.emin());
            this.format(StringUtils.firstNonEmpty(a.format(), a.f()));
            this.items(HttpPartSchema.toJsonMap(a.items()));
            this.maximum(this.toNumber(a.maximum(), a.max()));
            this.maxItems(this.firstNmo(a.maxItems(), a.maxi()));
            this.maxLength(this.firstNmo(a.maxLength(), a.maxl()));
            this.minimum(this.toNumber(a.minimum(), a.min()));
            this.minItems(this.firstNmo(a.minItems(), a.mini()));
            this.minLength(this.firstNmo(a.minLength(), a.minl()));
            this.multipleOf(this.toNumber(a.multipleOf(), a.mo()));
            this.pattern(StringUtils.firstNonEmpty(a.pattern(), a.p()));
            this.type(StringUtils.firstNonEmpty(a.type(), a.t()));
            this.uniqueItems(a.uniqueItems() || a.ui());
            return this;
        }

        Builder apply(Schema a) {
            this._default(this.joinnlOrNull(a._default(), a.df()));
            this._enum(this.toSet(a._enum(), a.e()));
            this.additionalProperties(HttpPartSchema.toJsonMap(a.additionalProperties()));
            this.allowEmptyValue(a.allowEmptyValue() || a.aev());
            this.collectionFormat(StringUtils.firstNonEmpty(a.collectionFormat(), a.cf()));
            this.exclusiveMaximum(a.exclusiveMaximum() || a.emax());
            this.exclusiveMinimum(a.exclusiveMinimum() || a.emin());
            this.format(StringUtils.firstNonEmpty(a.format(), a.f()));
            this.items(a.items());
            this.maximum(this.toNumber(a.maximum(), a.max()));
            this.maxItems(this.firstNmo(a.maxItems(), a.maxi()));
            this.maxLength(this.firstNmo(a.maxLength(), a.maxl()));
            this.maxProperties(this.firstNmo(a.maxProperties(), a.maxp()));
            this.minimum(this.toNumber(a.minimum(), a.min()));
            this.minItems(this.firstNmo(a.minItems(), a.mini()));
            this.minLength(this.firstNmo(a.minLength(), a.minl()));
            this.minProperties(this.firstNmo(a.minProperties(), a.minp()));
            this.multipleOf(this.toNumber(a.multipleOf(), a.mo()));
            this.pattern(StringUtils.firstNonEmpty(a.pattern(), a.p()));
            this.properties(HttpPartSchema.toJsonMap(a.properties()));
            this.required(a.required() || a.r());
            this.skipIfEmpty(a.skipIfEmpty() || a.sie());
            this.type(StringUtils.firstNonEmpty(a.type(), a.t()));
            this.uniqueItems(a.uniqueItems() || a.ui());
            return this;
        }

        Builder apply(HasQuery a) {
            this.name(StringUtils.firstNonEmpty(a.name(), a.value()));
            return this;
        }

        Builder apply(HasFormData a) {
            this.name(StringUtils.firstNonEmpty(a.name(), a.value()));
            return this;
        }

        Builder apply(JsonMap m) {
            if (m != null && !m.isEmpty()) {
                this._default(m.getString("default"));
                this._enum(HttpPartSchema.toSet(m.getString("enum")));
                this.allowEmptyValue(m.getBoolean("allowEmptyValue"));
                this.exclusiveMaximum(m.getBoolean("exclusiveMaximum"));
                this.exclusiveMinimum(m.getBoolean("exclusiveMinimum"));
                this.required(m.getBoolean("required"));
                this.uniqueItems(m.getBoolean("uniqueItems"));
                this.collectionFormat(m.getString("collectionFormat"));
                this.type(m.getString("type"));
                this.format(m.getString("format"));
                this.pattern(m.getString("pattern"));
                this.maximum(m.get("maximum", Number.class));
                this.minimum(m.get("minimum", Number.class));
                this.multipleOf(m.get("multipleOf", Number.class));
                this.maxItems(m.get("maxItems", Long.class));
                this.maxLength(m.get("maxLength", Long.class));
                this.maxProperties(m.get("maxProperties", Long.class));
                this.minItems(m.get("minItems", Long.class));
                this.minLength(m.get("minLength", Long.class));
                this.minProperties(m.get("minProperties", Long.class));
                this.items(m.getMap("items"));
                this.properties(m.getMap("properties"));
                this.additionalProperties(m.getMap("additionalProperties"));
                this.apply(m.getMap("schema", null));
            }
            return this;
        }

        public Builder name(String value) {
            if (StringUtils.isNotEmpty(value)) {
                this.name = value;
            }
            return this;
        }

        public Builder n(String value) {
            return this.name(value);
        }

        public Builder codes(int[] value) {
            if (value != null && value.length != 0) {
                for (int v : value) {
                    this.code(v);
                }
            }
            return this;
        }

        public Builder code(int value) {
            if (value != 0) {
                if (this.codes == null) {
                    this.codes = new TreeSet<Integer>();
                }
                this.codes.add(value);
            }
            return this;
        }

        public Builder required(Boolean value) {
            this.required = this.resolve(value, this.required);
            return this;
        }

        public Builder r(Boolean value) {
            return this.required(value);
        }

        public Builder required(String value) {
            this.required = this.resolve(value, this.required);
            return this;
        }

        public Builder r(String value) {
            return this.required(value);
        }

        public Builder required() {
            return this.required(true);
        }

        public Builder r() {
            return this.required();
        }

        public Builder type(String value) {
            try {
                if (StringUtils.isNotEmpty(value)) {
                    this.type = HttpPartDataType.fromString(value);
                }
            }
            catch (Exception e) {
                throw new ContextRuntimeException("Invalid value ''{0}'' passed in as type value.  Valid values: {1}", new Object[]{value, HttpPartDataType.values()});
            }
            return this;
        }

        public Builder t(String value) {
            return this.type(value);
        }

        public Builder tString() {
            this.type = HttpPartDataType.STRING;
            return this;
        }

        public Builder tNumber() {
            this.type = HttpPartDataType.NUMBER;
            return this;
        }

        public Builder tInteger() {
            this.type = HttpPartDataType.INTEGER;
            return this;
        }

        public Builder tBoolean() {
            this.type = HttpPartDataType.BOOLEAN;
            return this;
        }

        public Builder tArray() {
            this.type = HttpPartDataType.ARRAY;
            return this;
        }

        public Builder tObject() {
            this.type = HttpPartDataType.OBJECT;
            return this;
        }

        public Builder tFile() {
            this.type = HttpPartDataType.FILE;
            return this;
        }

        public Builder tNone() {
            this.type = HttpPartDataType.NO_TYPE;
            return this;
        }

        public Builder type(HttpPartDataType value) {
            this.type = value;
            return this;
        }

        public Builder t(HttpPartDataType value) {
            return this.type(value);
        }

        public Builder format(String value) {
            try {
                if (StringUtils.isNotEmpty(value)) {
                    this.format = HttpPartFormat.fromString(value);
                }
            }
            catch (Exception e) {
                throw new ContextRuntimeException("Invalid value ''{0}'' passed in as format value.  Valid values: {1}", new Object[]{value, HttpPartFormat.values()});
            }
            return this;
        }

        public Builder f(String value) {
            return this.format(value);
        }

        public Builder format(HttpPartFormat value) {
            this.format = value;
            return this;
        }

        public Builder f(HttpPartFormat value) {
            return this.format(value);
        }

        public Builder fInt32() {
            this.format = HttpPartFormat.INT32;
            return this;
        }

        public Builder fInt64() {
            this.format = HttpPartFormat.INT64;
            return this;
        }

        public Builder fFloat() {
            this.format = HttpPartFormat.FLOAT;
            return this;
        }

        public Builder fDouble() {
            this.format = HttpPartFormat.DOUBLE;
            return this;
        }

        public Builder fByte() {
            this.format = HttpPartFormat.BYTE;
            return this;
        }

        public Builder fBinary() {
            this.format = HttpPartFormat.BINARY;
            return this;
        }

        public Builder fBinarySpaced() {
            this.format = HttpPartFormat.BINARY_SPACED;
            return this;
        }

        public Builder fDate() {
            this.format = HttpPartFormat.DATE;
            return this;
        }

        public Builder fDateTime() {
            this.format = HttpPartFormat.DATE_TIME;
            return this;
        }

        public Builder fPassword() {
            this.format = HttpPartFormat.PASSWORD;
            return this;
        }

        public Builder fUon() {
            this.format = HttpPartFormat.UON;
            return this;
        }

        public Builder fNone() {
            this.format = HttpPartFormat.NO_FORMAT;
            return this;
        }

        public Builder allowEmptyValue(Boolean value) {
            this.allowEmptyValue = this.resolve(value, this.allowEmptyValue);
            return this;
        }

        public Builder aev(Boolean value) {
            return this.allowEmptyValue(value);
        }

        public Builder allowEmptyValue(String value) {
            this.allowEmptyValue = this.resolve(value, this.allowEmptyValue);
            return this;
        }

        public Builder aev(String value) {
            return this.allowEmptyValue(value);
        }

        public Builder allowEmptyValue() {
            return this.allowEmptyValue(true);
        }

        public Builder aev() {
            return this.allowEmptyValue(true);
        }

        public Builder items(Builder value) {
            if (value != null) {
                this.items = value;
            }
            return this;
        }

        public Builder i(Builder value) {
            return this.items(value);
        }

        public Builder items(HttpPartSchema value) {
            if (value != null) {
                this.items = value;
            }
            return this;
        }

        public Builder i(HttpPartSchema value) {
            return this.items(value);
        }

        Builder items(JsonMap value) {
            if (value != null && !value.isEmpty()) {
                this.items = HttpPartSchema.create().apply(value);
            }
            return this;
        }

        Builder items(Items value) {
            if (!ItemsAnnotation.empty(value)) {
                this.items = HttpPartSchema.create().apply(value);
            }
            return this;
        }

        Builder items(SubItems value) {
            if (!SubItemsAnnotation.empty(value)) {
                this.items = HttpPartSchema.create().apply(value);
            }
            return this;
        }

        public Builder collectionFormat(String value) {
            try {
                if (StringUtils.isNotEmpty(value)) {
                    this.collectionFormat = HttpPartCollectionFormat.fromString(value);
                }
            }
            catch (Exception e) {
                throw new ContextRuntimeException("Invalid value ''{0}'' passed in as collectionFormat value.  Valid values: {1}", new Object[]{value, HttpPartCollectionFormat.values()});
            }
            return this;
        }

        public Builder cf(String value) {
            return this.collectionFormat(value);
        }

        public Builder collectionFormat(HttpPartCollectionFormat value) {
            this.collectionFormat = value;
            return this;
        }

        public Builder cf(HttpPartCollectionFormat value) {
            return this.collectionFormat(value);
        }

        public Builder cfCsv() {
            return this.collectionFormat(HttpPartCollectionFormat.CSV);
        }

        public Builder cfSsv() {
            return this.collectionFormat(HttpPartCollectionFormat.SSV);
        }

        public Builder cfTsv() {
            return this.collectionFormat(HttpPartCollectionFormat.TSV);
        }

        public Builder cfPipes() {
            return this.collectionFormat(HttpPartCollectionFormat.PIPES);
        }

        public Builder cfMulti() {
            return this.collectionFormat(HttpPartCollectionFormat.MULTI);
        }

        public Builder cfUon() {
            return this.collectionFormat(HttpPartCollectionFormat.UONC);
        }

        public Builder cfNone() {
            return this.collectionFormat(HttpPartCollectionFormat.NO_COLLECTION_FORMAT);
        }

        public Builder _default(String value) {
            if (value != null) {
                this._default = value;
            }
            return this;
        }

        public Builder df(String value) {
            return this._default(value);
        }

        public Builder maximum(Number value) {
            if (value != null) {
                this.maximum = value;
            }
            return this;
        }

        public Builder max(Number value) {
            return this.maximum(value);
        }

        public Builder exclusiveMaximum(Boolean value) {
            this.exclusiveMaximum = this.resolve(value, this.exclusiveMaximum);
            return this;
        }

        public Builder emax(Boolean value) {
            return this.exclusiveMaximum(value);
        }

        public Builder exclusiveMaximum(String value) {
            this.exclusiveMaximum = this.resolve(value, this.exclusiveMaximum);
            return this;
        }

        public Builder emax(String value) {
            return this.exclusiveMaximum(value);
        }

        public Builder exclusiveMaximum() {
            return this.exclusiveMaximum(true);
        }

        public Builder emax() {
            return this.exclusiveMaximum();
        }

        public Builder minimum(Number value) {
            if (value != null) {
                this.minimum = value;
            }
            return this;
        }

        public Builder min(Number value) {
            return this.minimum(value);
        }

        public Builder exclusiveMinimum(Boolean value) {
            this.exclusiveMinimum = this.resolve(value, this.exclusiveMinimum);
            return this;
        }

        public Builder emin(Boolean value) {
            return this.exclusiveMinimum(value);
        }

        public Builder exclusiveMinimum(String value) {
            this.exclusiveMinimum = this.resolve(value, this.exclusiveMinimum);
            return this;
        }

        public Builder emin(String value) {
            return this.exclusiveMinimum(value);
        }

        public Builder exclusiveMinimum() {
            return this.exclusiveMinimum(true);
        }

        public Builder emin() {
            return this.exclusiveMinimum();
        }

        public Builder maxLength(Long value) {
            this.maxLength = this.resolve(value, this.maxLength);
            return this;
        }

        public Builder maxl(Long value) {
            return this.maxLength(value);
        }

        public Builder maxLength(String value) {
            this.maxLength = this.resolve(value, this.maxLength);
            return this;
        }

        public Builder maxl(String value) {
            return this.maxLength(value);
        }

        public Builder minLength(Long value) {
            this.minLength = this.resolve(value, this.minLength);
            return this;
        }

        public Builder minl(Long value) {
            return this.minLength(value);
        }

        public Builder minLength(String value) {
            this.minLength = this.resolve(value, this.minLength);
            return this;
        }

        public Builder minl(String value) {
            return this.minLength(value);
        }

        public Builder pattern(String value) {
            try {
                if (StringUtils.isNotEmpty(value)) {
                    this.pattern = Pattern.compile(value);
                }
            }
            catch (Exception e) {
                throw new ContextRuntimeException(e, "Invalid value {0} passed in as pattern value.  Must be a valid regular expression.", value);
            }
            return this;
        }

        public Builder p(String value) {
            return this.pattern(value);
        }

        public Builder maxItems(Long value) {
            this.maxItems = this.resolve(value, this.maxItems);
            return this;
        }

        public Builder maxi(Long value) {
            return this.maxItems(value);
        }

        public Builder maxItems(String value) {
            this.maxItems = this.resolve(value, this.maxItems);
            return this;
        }

        public Builder maxi(String value) {
            return this.maxItems(value);
        }

        public Builder minItems(Long value) {
            this.minItems = this.resolve(value, this.minItems);
            return this;
        }

        public Builder mini(Long value) {
            return this.minItems(value);
        }

        public Builder minItems(String value) {
            this.minItems = this.resolve(value, this.minItems);
            return this;
        }

        public Builder mini(String value) {
            return this.minItems(value);
        }

        public Builder uniqueItems(Boolean value) {
            this.uniqueItems = this.resolve(value, this.uniqueItems);
            return this;
        }

        public Builder ui(Boolean value) {
            return this.uniqueItems(value);
        }

        public Builder uniqueItems(String value) {
            this.uniqueItems = this.resolve(value, this.uniqueItems);
            return this;
        }

        public Builder ui(String value) {
            return this.uniqueItems(value);
        }

        public Builder uniqueItems() {
            return this.uniqueItems(true);
        }

        public Builder ui() {
            return this.uniqueItems();
        }

        public Builder skipIfEmpty(Boolean value) {
            this.skipIfEmpty = this.resolve(value, this.skipIfEmpty);
            return this;
        }

        public Builder sie(Boolean value) {
            return this.skipIfEmpty(value);
        }

        public Builder skipIfEmpty(String value) {
            this.skipIfEmpty = this.resolve(value, this.skipIfEmpty);
            return this;
        }

        public Builder sie(String value) {
            return this.skipIfEmpty(value);
        }

        public Builder skipIfEmpty() {
            return this.skipIfEmpty(true);
        }

        public Builder sie() {
            return this.skipIfEmpty();
        }

        public Builder _enum(Set<String> value) {
            if (value != null && !value.isEmpty()) {
                this._enum = value;
            }
            return this;
        }

        public Builder e(Set<String> value) {
            return this._enum(value);
        }

        public Builder _enum(String ... values) {
            return this._enum(CollectionUtils.set(values));
        }

        public Builder e(String ... values) {
            return this._enum(values);
        }

        public Builder multipleOf(Number value) {
            if (value != null) {
                this.multipleOf = value;
            }
            return this;
        }

        public Builder mo(Number value) {
            return this.multipleOf(value);
        }

        public Builder maxProperties(Long value) {
            this.maxProperties = this.resolve(value, this.maxProperties);
            return this;
        }

        public Builder maxp(Long value) {
            return this.maxProperties(value);
        }

        public Builder maxProperties(String value) {
            this.maxProperties = this.resolve(value, this.maxProperties);
            return this;
        }

        public Builder maxp(String value) {
            return this.maxProperties(value);
        }

        public Builder minProperties(Long value) {
            this.minProperties = this.resolve(value, this.minProperties);
            return this;
        }

        public Builder minp(Long value) {
            return this.minProperties(value);
        }

        public Builder minProperties(String value) {
            this.minProperties = this.resolve(value, this.minProperties);
            return this;
        }

        public Builder minp(String value) {
            return this.minProperties(value);
        }

        public Builder property(String key, Builder value) {
            if (key != null && value != null) {
                if (this.properties == null) {
                    this.properties = CollectionUtils.map();
                }
                this.properties.put(key, value);
            }
            return this;
        }

        public Builder property(String key, HttpPartSchema value) {
            if (key != null && value != null) {
                if (this.properties == null) {
                    this.properties = CollectionUtils.map();
                }
                this.properties.put(key, value);
            }
            return this;
        }

        public Builder p(String key, Builder value) {
            return this.property(key, value);
        }

        public Builder p(String key, HttpPartSchema value) {
            return this.property(key, value);
        }

        private Builder properties(JsonMap value) {
            if (value != null) {
                value.forEach((k, v) -> this.property((String)k, HttpPartSchema.create().apply((JsonMap)v)));
            }
            return this;
        }

        public Builder additionalProperties(Builder value) {
            if (value != null) {
                this.additionalProperties = value;
            }
            return this;
        }

        public Builder additionalProperties(HttpPartSchema value) {
            if (value != null) {
                this.additionalProperties = value;
            }
            return this;
        }

        public Builder ap(Builder value) {
            return this.additionalProperties(value);
        }

        public Builder ap(HttpPartSchema value) {
            return this.additionalProperties(value);
        }

        private Builder additionalProperties(JsonMap value) {
            if (value != null && !value.isEmpty()) {
                this.additionalProperties = HttpPartSchema.create().apply(value);
            }
            return this;
        }

        public Builder serializer(Class<? extends HttpPartSerializer> value) {
            if (ClassUtils.isNotVoid(value)) {
                this.serializer = value;
            }
            return this;
        }

        public Builder parser(Class<? extends HttpPartParser> value) {
            if (ClassUtils.isNotVoid(value)) {
                this.parser = value;
            }
            return this;
        }

        public Builder noValidate(Boolean value) {
            if (value != null) {
                this.noValidate = value;
            }
            return this;
        }

        public Builder noValidate() {
            return this.noValidate(true);
        }

        private Boolean resolve(String newValue, Boolean oldValue) {
            return StringUtils.isEmpty(newValue) ? oldValue : Boolean.valueOf(newValue);
        }

        private Boolean resolve(Boolean newValue, Boolean oldValue) {
            return newValue == null ? oldValue : newValue;
        }

        private Long resolve(String newValue, Long oldValue) {
            return StringUtils.isEmpty(newValue) ? oldValue : Long.parseLong(newValue);
        }

        private Long resolve(Long newValue, Long oldValue) {
            return newValue == null || newValue == -1L ? oldValue : newValue;
        }

        private Set<String> toSet(String[] ... s) {
            return HttpPartSchema.toSet(s);
        }

        private Number toNumber(String ... s) {
            return HttpPartSchema.toNumber(s);
        }

        private Long firstNmo(Long ... l) {
            for (Long ll : l) {
                if (ll == null || ll == -1L) continue;
                return ll;
            }
            return null;
        }

        private String joinnlOrNull(String[] ... s) {
            for (Object[] objectArray : s) {
                if (objectArray.length <= 0) continue;
                return StringUtils.joinnl(objectArray);
            }
            return null;
        }
    }
}

