/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.openapi3;

import java.lang.reflect.Type;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.openapi3.OpenApiElement;
import org.apache.juneau.dto.swagger.Contact;
import org.apache.juneau.dto.swagger.License;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.internal.StringUtils;

@Bean(properties="title,description,version,contact,license,termsOfService,*")
@FluentSetters
public class Info
extends OpenApiElement {
    private String title;
    private String description;
    private String termsOfService;
    private String version;
    private Contact contact;
    private License license;

    public Info() {
    }

    public Info(Info copyFrom) {
        super(copyFrom);
        this.title = copyFrom.title;
        this.description = copyFrom.description;
        this.termsOfService = copyFrom.termsOfService;
        this.version = copyFrom.version;
        this.contact = copyFrom.contact == null ? null : copyFrom.contact.copy();
        this.license = copyFrom.license == null ? null : copyFrom.license.copy();
    }

    public Info copy() {
        return new Info(this);
    }

    public String getTitle() {
        return this.title;
    }

    public Info setTitle(String value) {
        this.title = value;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Info setDescription(String value) {
        this.description = value;
        return this;
    }

    public String getTermsOfService() {
        return this.termsOfService;
    }

    public Info setTermsOfService(String value) {
        this.termsOfService = value;
        return this;
    }

    public Contact getContact() {
        return this.contact;
    }

    public Info setContact(Contact value) {
        this.contact = value;
        return this;
    }

    public License getLicense() {
        return this.license;
    }

    public Info setLicense(License value) {
        this.license = value;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Info setVersion(String value) {
        this.version = value;
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "title": {
                return ConverterUtils.toType(this.getTitle(), type);
            }
            case "description": {
                return ConverterUtils.toType(this.getDescription(), type);
            }
            case "termsOfService": {
                return ConverterUtils.toType(this.getTermsOfService(), type);
            }
            case "contact": {
                return ConverterUtils.toType(this.getContact(), type);
            }
            case "license": {
                return ConverterUtils.toType(this.getLicense(), type);
            }
            case "version": {
                return ConverterUtils.toType(this.getVersion(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Info set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "title": {
                return this.setTitle(StringUtils.stringify(value));
            }
            case "description": {
                return this.setDescription(StringUtils.stringify(value));
            }
            case "termsOfService": {
                return this.setTermsOfService(StringUtils.stringify(value));
            }
            case "contact": {
                return this.setContact(ConverterUtils.toType(value, Contact.class));
            }
            case "license": {
                return this.setLicense(ConverterUtils.toType(value, License.class));
            }
            case "version": {
                return this.setVersion(StringUtils.stringify(value));
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setBuilder(String.class, new Type[0]).addIf(this.title != null, "title").addIf(this.description != null, "description").addIf(this.termsOfService != null, "termsOfService").addIf(this.contact != null, "contact").addIf(this.license != null, "license").addIf(this.version != null, "version").build();
        return new MultiSet<String>(s, super.keySet());
    }
}

