/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.jsonschema;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.annotation.Swap;
import org.apache.juneau.dto.jsonschema.JsonSchemaArray;
import org.apache.juneau.dto.jsonschema.JsonSchemaMap;
import org.apache.juneau.dto.jsonschema.JsonSchemaProperty;
import org.apache.juneau.dto.jsonschema.JsonType;
import org.apache.juneau.dto.jsonschema.JsonTypeArray;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.transform.PojoSwap;

@Bean(typeName="schema", bpi="id,$schema,$ref, title,description,type,definitions,properties,patternProperties,dependencies,items,multipleOf,maximum,exclusiveMaximum,minimum,exclusiveMinimum,maxLength,minLength,pattern,additionalItems,maxItems,minItems,uniqueItems,maxProperties,minProperties,required,additionalProperties,enum,allOf,anyOf,oneOf,not")
public class JsonSchema {
    private String name;
    private URI id;
    private URI schemaVersion;
    private String title;
    private String description;
    private JsonType typeJsonType;
    private JsonTypeArray typeJsonTypeArray;
    private Map<String, JsonSchema> definitions;
    private Map<String, JsonSchema> properties;
    private Map<String, JsonSchema> patternProperties;
    private Map<String, JsonSchema> dependencies;
    private JsonSchema itemsSchema;
    private JsonSchemaArray itemsSchemaArray;
    private Number multipleOf;
    private Number maximum;
    private Boolean exclusiveMaximum;
    private Number minimum;
    private Boolean exclusiveMinimum;
    private Integer maxLength;
    private Integer minLength;
    private String pattern;
    private Boolean additionalItemsBoolean;
    private JsonSchemaArray additionalItemsSchemaArray;
    private Integer maxItems;
    private Integer minItems;
    private Boolean uniqueItems;
    private Integer maxProperties;
    private Integer minProperties;
    private List<String> required;
    private Boolean additionalPropertiesBoolean;
    private JsonSchema additionalPropertiesSchema;
    private List<String> _enum;
    private List<JsonSchema> allOf;
    private List<JsonSchema> anyOf;
    private List<JsonSchema> oneOf;
    private JsonSchema not;
    private URI ref;
    private JsonSchemaMap schemaMap;
    private JsonSchema master = this;

    @BeanIgnore
    public String getName() {
        return this.name;
    }

    @BeanIgnore
    public JsonSchema setName(String name) {
        this.name = name;
        return this;
    }

    public URI getId() {
        return this.id;
    }

    public JsonSchema setId(Object id) {
        this.id = StringUtils.toURI(id);
        return this;
    }

    @Beanp(value="$schema")
    public URI getSchemaVersionUri() {
        return this.schemaVersion;
    }

    @Beanp(value="$schema")
    public JsonSchema setSchemaVersionUri(Object schemaVersion) {
        this.schemaVersion = StringUtils.toURI(schemaVersion);
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public JsonSchema setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public JsonSchema setDescription(String description) {
        this.description = description;
        return this;
    }

    @Swap(value=JsonTypeOrJsonTypeArraySwap.class)
    public Object getType() {
        if (this.typeJsonType != null) {
            return this.typeJsonType;
        }
        return this.typeJsonTypeArray;
    }

    @BeanIgnore
    public JsonType getTypeAsJsonType() {
        return this.typeJsonType;
    }

    @BeanIgnore
    public JsonTypeArray getTypeAsJsonTypeArray() {
        return this.typeJsonTypeArray;
    }

    public JsonSchema setType(Object type) {
        this.typeJsonType = null;
        this.typeJsonTypeArray = null;
        if (type != null) {
            if (type instanceof JsonType) {
                this.typeJsonType = (JsonType)((Object)type);
            } else if (type instanceof JsonTypeArray) {
                this.typeJsonTypeArray = (JsonTypeArray)type;
            } else {
                throw new BeanRuntimeException(JsonSchemaProperty.class, "Invalid attribute type ''{0}'' passed in.  Must be one of the following:  SimpleType, SimpleTypeArray", type.getClass().getName());
            }
        }
        return this;
    }

    public JsonSchema addTypes(JsonType ... types) {
        if (this.typeJsonTypeArray == null) {
            this.typeJsonTypeArray = new JsonTypeArray();
        }
        this.typeJsonTypeArray.addAll(types);
        return this;
    }

    public Map<String, JsonSchema> getDefinitions() {
        return this.definitions;
    }

    public JsonSchema setDefinitions(Map<String, JsonSchema> definitions) {
        this.definitions = definitions;
        if (definitions != null) {
            this.setMasterOn(definitions.values());
        }
        return this;
    }

    public JsonSchema addDefinition(String name, JsonSchema definition) {
        if (this.definitions == null) {
            this.definitions = new LinkedHashMap<String, JsonSchema>();
        }
        this.definitions.put(name, definition);
        this.setMasterOn(definition);
        return this;
    }

    public Map<String, JsonSchema> getProperties() {
        return this.properties;
    }

    public JsonSchema getProperty(String name) {
        return this.getProperty(name, false);
    }

    public JsonSchema getProperty(String name, boolean resolve) {
        if (this.properties == null) {
            return null;
        }
        JsonSchema s = this.properties.get(name);
        if (s == null) {
            return null;
        }
        if (resolve) {
            s = s.resolve();
        }
        return s;
    }

    public JsonSchema setProperties(Map<String, JsonSchema> properties) {
        this.properties = properties;
        if (properties != null) {
            for (Map.Entry<String, JsonSchema> e : properties.entrySet()) {
                JsonSchema value = e.getValue();
                this.setMasterOn(value);
                value.setName(e.getKey());
            }
        }
        return this;
    }

    public JsonSchema addProperties(JsonSchema ... properties) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, JsonSchema>();
        }
        for (JsonSchema p : properties) {
            if (p.getName() == null) {
                throw new BeanRuntimeException(JsonSchema.class, "Invalid property passed to JsonSchema.addProperties().  Property name was null.", new Object[0]);
            }
            this.setMasterOn(p);
            this.properties.put(p.getName(), p);
        }
        return this;
    }

    public Map<String, JsonSchema> getPatternProperties() {
        return this.patternProperties;
    }

    public JsonSchema setPatternProperties(Map<String, JsonSchema> patternProperties) {
        this.patternProperties = patternProperties;
        if (patternProperties != null) {
            for (Map.Entry<String, JsonSchema> e : patternProperties.entrySet()) {
                JsonSchema s = e.getValue();
                this.setMasterOn(s);
                s.setName(e.getKey());
            }
        }
        return this;
    }

    public JsonSchema addPatternProperties(JsonSchemaProperty ... properties) {
        if (this.patternProperties == null) {
            this.patternProperties = new LinkedHashMap<String, JsonSchema>();
        }
        for (JsonSchemaProperty p : properties) {
            if (p.getName() == null) {
                throw new BeanRuntimeException(JsonSchema.class, "Invalid property passed to JsonSchema.addProperties().  Property name was null.", new Object[0]);
            }
            this.setMasterOn(p);
            this.patternProperties.put(p.getName(), p);
        }
        return this;
    }

    public Map<String, JsonSchema> getDependencies() {
        return this.dependencies;
    }

    public JsonSchema setDependencies(Map<String, JsonSchema> dependencies) {
        this.dependencies = dependencies;
        if (dependencies != null) {
            this.setMasterOn(dependencies.values());
        }
        return this;
    }

    public JsonSchema addDependency(String name, JsonSchema dependency) {
        if (this.dependencies == null) {
            this.dependencies = new LinkedHashMap<String, JsonSchema>();
        }
        this.dependencies.put(name, dependency);
        this.setMasterOn(dependency);
        return this;
    }

    @Swap(value=JsonSchemaOrSchemaArraySwap.class)
    public Object getItems() {
        if (this.itemsSchema != null) {
            return this.itemsSchema;
        }
        return this.itemsSchemaArray;
    }

    @BeanIgnore
    public JsonSchema getItemsAsSchema() {
        return this.itemsSchema;
    }

    @BeanIgnore
    public JsonSchemaArray getItemsAsSchemaArray() {
        return this.itemsSchemaArray;
    }

    public JsonSchema setItems(Object items) {
        this.itemsSchema = null;
        this.itemsSchemaArray = null;
        if (items != null) {
            if (items instanceof JsonSchema) {
                this.itemsSchema = (JsonSchema)items;
                this.setMasterOn(this.itemsSchema);
            } else if (items instanceof JsonSchemaArray) {
                this.itemsSchemaArray = (JsonSchemaArray)items;
                this.setMasterOn(this.itemsSchemaArray);
            } else {
                throw new BeanRuntimeException(JsonSchemaProperty.class, "Invalid attribute type ''{0}'' passed in.  Must be one of the following:  JsonSchema, JsonSchemaArray", items.getClass().getName());
            }
        }
        return this;
    }

    public JsonSchema addItems(JsonSchema ... items) {
        if (this.itemsSchemaArray == null) {
            this.itemsSchemaArray = new JsonSchemaArray();
        }
        this.itemsSchemaArray.addAll(items);
        this.setMasterOn(items);
        return this;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public JsonSchema setMultipleOf(Number multipleOf) {
        this.multipleOf = multipleOf;
        return this;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public JsonSchema setMaximum(Number maximum) {
        this.maximum = maximum;
        return this;
    }

    public Boolean isExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public JsonSchema setExclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public JsonSchema setMinimum(Number minimum) {
        this.minimum = minimum;
        return this;
    }

    public Boolean isExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public JsonSchema setExclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public JsonSchema setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public JsonSchema setMinLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public JsonSchema setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    @Swap(value=BooleanOrSchemaArraySwap.class)
    public Object getAdditionalItems() {
        if (this.additionalItemsBoolean != null) {
            return this.additionalItemsBoolean;
        }
        return this.additionalItemsSchemaArray;
    }

    @BeanIgnore
    public Boolean getAdditionalItemsAsBoolean() {
        return this.additionalItemsBoolean;
    }

    @BeanIgnore
    public List<JsonSchema> getAdditionalItemsAsSchemaArray() {
        return this.additionalItemsSchemaArray;
    }

    public JsonSchema setAdditionalItems(Object additionalItems) {
        this.additionalItemsBoolean = null;
        this.additionalItemsSchemaArray = null;
        if (additionalItems != null) {
            if (additionalItems instanceof Boolean) {
                this.additionalItemsBoolean = (Boolean)additionalItems;
            } else if (additionalItems instanceof JsonSchemaArray) {
                this.additionalItemsSchemaArray = (JsonSchemaArray)additionalItems;
                this.setMasterOn(this.additionalItemsSchemaArray);
            } else {
                throw new BeanRuntimeException(JsonSchemaProperty.class, "Invalid attribute type ''{0}'' passed in.  Must be one of the following:  Boolean, JsonSchemaArray", additionalItems.getClass().getName());
            }
        }
        return this;
    }

    public JsonSchema addAdditionalItems(JsonSchema ... additionalItems) {
        if (this.additionalItemsSchemaArray == null) {
            this.additionalItemsSchemaArray = new JsonSchemaArray();
        }
        this.additionalItemsSchemaArray.addAll(additionalItems);
        this.setMasterOn(additionalItems);
        return this;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public JsonSchema setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public JsonSchema setMinItems(Integer minItems) {
        this.minItems = minItems;
        return this;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public JsonSchema setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
        return this;
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public JsonSchema setMaxProperties(Integer maxProperties) {
        this.maxProperties = maxProperties;
        return this;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public JsonSchema setMinProperties(Integer minProperties) {
        this.minProperties = minProperties;
        return this;
    }

    public List<String> getRequired() {
        return this.required;
    }

    public JsonSchema setRequired(List<String> required) {
        this.required = required;
        return this;
    }

    public JsonSchema addRequired(List<String> required) {
        if (this.required == null) {
            this.required = new LinkedList<String>();
        }
        for (String r : required) {
            this.required.add(r);
        }
        return this;
    }

    public JsonSchema addRequired(String ... required) {
        if (this.required == null) {
            this.required = new LinkedList<String>();
        }
        for (String r : required) {
            this.required.add(r);
        }
        return this;
    }

    public JsonSchema addRequired(JsonSchemaProperty ... properties) {
        if (this.required == null) {
            this.required = new LinkedList<String>();
        }
        for (JsonSchemaProperty p : properties) {
            this.required.add(p.getName());
        }
        return this;
    }

    @Swap(value=BooleanOrSchemaSwap.class)
    public Object getAdditionalProperties() {
        if (this.additionalPropertiesBoolean != null) {
            return this.additionalItemsBoolean;
        }
        return this.additionalPropertiesSchema;
    }

    @BeanIgnore
    public Boolean getAdditionalPropertiesAsBoolean() {
        return this.additionalPropertiesBoolean;
    }

    @BeanIgnore
    public JsonSchema getAdditionalPropertiesAsSchema() {
        return this.additionalPropertiesSchema;
    }

    @Beanp(dictionary={JsonSchema.class})
    public JsonSchema setAdditionalProperties(Object additionalProperties) {
        this.additionalPropertiesBoolean = null;
        this.additionalPropertiesSchema = null;
        if (additionalProperties != null) {
            if (additionalProperties instanceof Boolean) {
                this.additionalPropertiesBoolean = (Boolean)additionalProperties;
            } else if (additionalProperties instanceof JsonSchema) {
                this.additionalPropertiesSchema = (JsonSchema)additionalProperties;
                this.setMasterOn(this.additionalPropertiesSchema);
            } else {
                throw new BeanRuntimeException(JsonSchemaProperty.class, "Invalid attribute type ''{0}'' passed in.  Must be one of the following:  Boolean, JsonSchema", additionalProperties.getClass().getName());
            }
        }
        return this;
    }

    public List<String> getEnum() {
        return this._enum;
    }

    public JsonSchema setEnum(List<String> _enum) {
        this._enum = _enum;
        return this;
    }

    public JsonSchema addEnum(String ... _enum) {
        if (this._enum == null) {
            this._enum = new LinkedList<String>();
        }
        for (String e : _enum) {
            this._enum.add(e);
        }
        return this;
    }

    public List<JsonSchema> getAllOf() {
        return this.allOf;
    }

    public JsonSchema setAllOf(List<JsonSchema> allOf) {
        this.allOf = allOf;
        this.setMasterOn(allOf);
        return this;
    }

    public JsonSchema addAllOf(JsonSchema ... allOf) {
        if (this.allOf == null) {
            this.allOf = new LinkedList<JsonSchema>();
        }
        this.setMasterOn(allOf);
        for (JsonSchema s : allOf) {
            this.allOf.add(s);
        }
        return this;
    }

    public List<JsonSchema> getAnyOf() {
        return this.anyOf;
    }

    public JsonSchema setAnyOf(List<JsonSchema> anyOf) {
        this.anyOf = anyOf;
        this.setMasterOn(anyOf);
        return this;
    }

    public JsonSchema addAnyOf(JsonSchema ... anyOf) {
        if (this.anyOf == null) {
            this.anyOf = new LinkedList<JsonSchema>();
        }
        this.setMasterOn(anyOf);
        for (JsonSchema s : anyOf) {
            this.anyOf.add(s);
        }
        return this;
    }

    public List<JsonSchema> getOneOf() {
        return this.oneOf;
    }

    public JsonSchema setOneOf(List<JsonSchema> oneOf) {
        this.oneOf = oneOf;
        this.setMasterOn(oneOf);
        return this;
    }

    public JsonSchema addOneOf(JsonSchema ... oneOf) {
        if (this.oneOf == null) {
            this.oneOf = new LinkedList<JsonSchema>();
        }
        this.setMasterOn(oneOf);
        for (JsonSchema s : oneOf) {
            this.oneOf.add(s);
        }
        return this;
    }

    public JsonSchema getNot() {
        return this.not;
    }

    public JsonSchema setNot(JsonSchema not) {
        this.not = not;
        this.setMasterOn(not);
        return this;
    }

    @Beanp(value="$ref")
    public URI getRef() {
        return this.ref;
    }

    @Beanp(value="$ref")
    public JsonSchema setRef(Object ref) {
        this.ref = StringUtils.toURI(ref);
        return this;
    }

    private void setMasterOn(JsonSchema s) {
        if (s != null) {
            s.setMaster(this);
        }
    }

    private void setMasterOn(JsonSchema[] ss) {
        if (ss != null) {
            for (JsonSchema s : ss) {
                this.setMasterOn(s);
            }
        }
    }

    private void setMasterOn(Collection<JsonSchema> ss) {
        if (ss != null) {
            for (JsonSchema s : ss) {
                this.setMasterOn(s);
            }
        }
    }

    private void setMasterOn(JsonSchemaArray ss) {
        if (ss != null) {
            for (JsonSchema s : ss) {
                this.setMasterOn(s);
            }
        }
    }

    protected void setMaster(JsonSchema master) {
        this.master = master;
        if (this.definitions != null) {
            for (JsonSchema s : this.definitions.values()) {
                s.setMaster(master);
            }
        }
        if (this.properties != null) {
            for (JsonSchema s : this.properties.values()) {
                s.setMaster(master);
            }
        }
        if (this.patternProperties != null) {
            for (JsonSchema s : this.patternProperties.values()) {
                s.setMaster(master);
            }
        }
        if (this.dependencies != null) {
            for (JsonSchema s : this.dependencies.values()) {
                s.setMaster(master);
            }
        }
        if (this.itemsSchema != null) {
            this.itemsSchema.setMaster(master);
        }
        if (this.itemsSchemaArray != null) {
            for (JsonSchema s : this.itemsSchemaArray) {
                s.setMaster(master);
            }
        }
        if (this.additionalItemsSchemaArray != null) {
            for (JsonSchema s : this.additionalItemsSchemaArray) {
                s.setMaster(master);
            }
        }
        if (this.additionalPropertiesSchema != null) {
            this.additionalPropertiesSchema.setMaster(master);
        }
        if (this.allOf != null) {
            for (JsonSchema s : this.allOf) {
                s.setMaster(master);
            }
        }
        if (this.anyOf != null) {
            for (JsonSchema s : this.anyOf) {
                s.setMaster(master);
            }
        }
        if (this.oneOf != null) {
            for (JsonSchema s : this.oneOf) {
                s.setMaster(master);
            }
        }
        if (this.not != null) {
            this.not.setMaster(master);
        }
    }

    public JsonSchema resolve() {
        if (this.ref == null || this.master.schemaMap == null) {
            return this;
        }
        return this.master.schemaMap.get(this.ref);
    }

    public JsonSchema setSchemaMap(JsonSchemaMap schemaMap) {
        this.schemaMap = schemaMap;
        return this;
    }

    public String toString() {
        return JsonSerializer.DEFAULT.toString(this);
    }

    public static class BooleanOrSchemaSwap
    extends PojoSwap<Object, Object> {
        @Override
        public Object swap(BeanSession session, Object o) throws SerializeException {
            return o;
        }

        @Override
        public Object unswap(BeanSession session, Object o, ClassMeta<?> hint) throws ParseException {
            ClassMeta<Object> cm = o instanceof Boolean ? session.getClassMeta(Boolean.class) : session.getClassMeta(JsonSchema.class);
            return session.convertToType(o, cm);
        }
    }

    public static class BooleanOrSchemaArraySwap
    extends PojoSwap<Object, Object> {
        @Override
        public Object swap(BeanSession session, Object o) throws SerializeException {
            return o;
        }

        @Override
        public Object unswap(BeanSession session, Object o, ClassMeta<?> hint) throws ParseException {
            ClassMeta<Serializable> cm = o instanceof Collection ? session.getClassMeta(JsonSchemaArray.class) : session.getClassMeta(Boolean.class);
            return session.convertToType(o, cm);
        }
    }

    public static class JsonSchemaOrSchemaArraySwap
    extends PojoSwap<Object, Object> {
        @Override
        public Object swap(BeanSession session, Object o) throws SerializeException {
            return o;
        }

        @Override
        public Object unswap(BeanSession session, Object o, ClassMeta<?> hint) throws ParseException {
            ClassMeta<Object> cm = o instanceof Collection ? session.getClassMeta(JsonSchemaArray.class) : session.getClassMeta(JsonSchema.class);
            return session.convertToType(o, cm);
        }
    }

    public static class JsonTypeOrJsonTypeArraySwap
    extends PojoSwap<Object, Object> {
        @Override
        public Object swap(BeanSession session, Object o) throws SerializeException {
            return o;
        }

        @Override
        public Object unswap(BeanSession session, Object o, ClassMeta<?> hint) throws ParseException {
            ClassMeta<Object> cm = o instanceof Collection ? session.getClassMeta(JsonTypeArray.class) : session.getClassMeta(JsonType.class);
            return session.convertToType(o, cm);
        }
    }
}

