/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.search.tika;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Database;
import org.apache.tika.metadata.IPTC;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.PDF;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.search.LuceneSearchProvider;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TikaSearchProvider
extends LuceneSearchProvider {
    private static final Logger LOG = LogManager.getLogger(TikaSearchProvider.class);
    final AutoDetectParser parser = new AutoDetectParser();
    final Set<String> textualMetadataFields = new HashSet<String>();

    public TikaSearchProvider() {
        this.textualMetadataFields.add(TikaCoreProperties.TITLE.getName());
        this.textualMetadataFields.add(TikaCoreProperties.COMMENTS.getName());
        this.textualMetadataFields.add(TikaCoreProperties.SUBJECT.getName());
        this.textualMetadataFields.add(TikaCoreProperties.DESCRIPTION.getName());
        this.textualMetadataFields.add(TikaCoreProperties.TYPE.getName());
        this.textualMetadataFields.add("resourceName");
        this.textualMetadataFields.add(PDF.DOC_INFO_TITLE.getName());
        this.textualMetadataFields.add(PDF.DOC_INFO_KEY_WORDS.getName());
        this.textualMetadataFields.add(PDF.DOC_INFO_SUBJECT.getName());
        this.textualMetadataFields.add(OfficeOpenXMLCore.SUBJECT.getName());
        this.textualMetadataFields.add(Office.KEYWORDS.getName());
        this.textualMetadataFields.add(TikaCoreProperties.TYPE.getName());
        this.textualMetadataFields.add("Content-Type");
        this.textualMetadataFields.add(IPTC.HEADLINE.getName());
        this.textualMetadataFields.add(Database.COLUMN_NAME.getName());
        this.textualMetadataFields.add(Database.TABLE_NAME.getName());
        this.textualMetadataFields.add("Work-Type");
        this.textualMetadataFields.add("comment");
        this.textualMetadataFields.add("history");
        this.textualMetadataFields.add("institution");
    }

    protected String getAttachmentContent(Attachment att) {
        AttachmentManager mgr = (AttachmentManager)this.getEngine().getManager(AttachmentManager.class);
        StringBuilder out = new StringBuilder();
        try (InputStream attStream = mgr.getAttachmentStream(att);){
            String[] names;
            Metadata metadata = new Metadata();
            metadata.set("resourceName", att.getFileName());
            BodyContentHandler handler = new BodyContentHandler(-1);
            this.parser.parse(attStream, (ContentHandler)handler, metadata);
            out.append(handler);
            for (String name : names = metadata.names()) {
                if (!this.textualMetadataFields.contains(name)) continue;
                out.append(" ").append(metadata.get(name));
            }
        }
        catch (TikaException | SAXException e) {
            LOG.error("Attachment cannot be parsed", e);
        }
        catch (IOException | ProviderException e) {
            LOG.error("Attachment cannot be loaded", e);
        }
        return out.toString();
    }
}

