/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.Optional;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.TransverseMercator;
import org.apache.sis.referencing.operation.provider.ZonedTransverseMercator;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DomainDefinition;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.internal.Numerics;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class ZonedGridSystem
extends AbstractMathTransform2D
implements Serializable {
    private static final long serialVersionUID = -7219325241026170925L;
    private static final double RANGE = 360.0;
    private static final double ZONE_SCALE = 1000000.0;
    final double initialLongitude;
    final double zoneWidth;
    final AbstractMathTransform projection;
    private final MathTransform2D inverse;

    public ZonedGridSystem(OperationMethod method, Parameters parameters, MathTransformFactory factory) throws FactoryException {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, org.apache.sis.referencing.operation.provider.TransverseMercator.SCALE_FACTOR);
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.referencing.operation.provider.TransverseMercator.FALSE_EASTING);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.referencing.operation.provider.TransverseMercator.FALSE_NORTHING);
        Initializer initializer = new Initializer(method, parameters, roles, null);
        this.initialLongitude = initializer.getAndStore(ZonedTransverseMercator.INITIAL_LONGITUDE);
        this.zoneWidth = initializer.getAndStore(ZonedTransverseMercator.ZONE_WIDTH);
        MatrixSIS normalize = initializer.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        normalize.convertBefore(0, null, this.zoneWidth / -2.0);
        this.projection = (AbstractMathTransform)new TransverseMercator(initializer).createMapProjection(factory);
        this.inverse = new Inverse(this);
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.projection.getParameterValues();
    }

    @Override
    public Optional<Envelope> getDomain(DomainDefinition criteria) {
        double y = -1.4660765716752369;
        return Optional.of(new Envelope2D(null, -Math.PI, -1.4660765716752369, Math.PI * 2, 2.9321531433504737));
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        double \u03bb = srcPts[srcOff] - this.initialLongitude;
        double \u03c6 = srcPts[srcOff + 1];
        \u03bb -= 360.0 * Math.floor(\u03bb / 360.0);
        double zone = Math.floor(\u03bb / this.zoneWidth);
        dstPts[dstOff] = \u03bb -= zone * this.zoneWidth;
        dstPts[dstOff + 1] = \u03c6;
        Matrix derivative = this.projection.transform(dstPts, dstOff, dstPts, dstOff, derivate);
        int n = dstOff;
        dstPts[n] = dstPts[n] + (zone + 1.0) * 1000000.0;
        return derivative;
    }

    @Override
    public MathTransform2D inverse() {
        return this.inverse;
    }

    @Override
    protected int computeHashCode() {
        long c = Double.doubleToLongBits(this.initialLongitude) + 31L * Double.doubleToLongBits(this.zoneWidth);
        return (super.computeHashCode() ^ Long.hashCode(c)) + 37 * this.projection.hashCode();
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            ZonedGridSystem that = (ZonedGridSystem)object;
            return Numerics.equals(this.initialLongitude, that.initialLongitude) && Numerics.equals(this.zoneWidth, that.zoneWidth) && this.projection.equals(that.projection, mode);
        }
        return false;
    }

    private static final class Inverse
    extends AbstractMathTransform2D.Inverse
    implements Serializable {
        private static final long serialVersionUID = -4417726238412154175L;
        private final ZonedGridSystem forward;
        private final AbstractMathTransform inverseProjection;

        Inverse(ZonedGridSystem forward) throws FactoryException {
            this.forward = forward;
            try {
                this.inverseProjection = (AbstractMathTransform)forward.projection.inverse();
            }
            catch (NoninvertibleTransformException e2) {
                throw new FactoryException(e2);
            }
        }

        @Override
        public MathTransform2D inverse() {
            return this.forward;
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
            double x = srcPts[srcOff];
            double y = srcPts[srcOff + 1];
            double zone = Math.floor(x / 1000000.0) - 1.0;
            dstPts[dstOff] = x -= (zone + 1.0) * 1000000.0;
            dstPts[dstOff + 1] = y;
            Matrix derivative = this.inverseProjection.transform(dstPts, dstOff, dstPts, dstOff, derivate);
            int n = dstOff;
            dstPts[n] = dstPts[n] + (zone * this.forward.zoneWidth + this.forward.initialLongitude);
            return derivative;
        }
    }
}

