/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.datatype;

import org.apache.jena.datatypes.BaseDatatype;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.datatype.GMLDatatype;
import org.apache.jena.geosparql.implementation.datatype.WKTDatatype;
import org.apache.jena.geosparql.implementation.index.GeometryLiteralIndex;
import org.apache.jena.sys.JenaSystem;

public abstract class GeometryDatatype
extends BaseDatatype {
    public GeometryDatatype(String uri) {
        super(uri);
    }

    public abstract GeometryWrapper read(String var1);

    @Override
    public final GeometryWrapper parse(String lexicalForm) throws DatatypeFormatException {
        return this.parse(lexicalForm, GeometryLiteralIndex.GeometryIndex.PRIMARY);
    }

    public final GeometryWrapper parse(String lexicalForm, GeometryLiteralIndex.GeometryIndex targetIndex) throws DatatypeFormatException {
        try {
            return GeometryLiteralIndex.retrieve(lexicalForm, this, targetIndex);
        }
        catch (IllegalArgumentException ex) {
            throw new DatatypeFormatException(ex.getMessage() + " - Illegal Geometry Literal: " + lexicalForm);
        }
    }

    public static void registerDatatypes() {
        Types.init();
    }

    private static TypeMapper typeMapper() {
        return Types.MAPPER;
    }

    public static final GeometryDatatype get(RDFDatatype rdfDatatype) throws DatatypeFormatException {
        if (rdfDatatype instanceof GeometryDatatype) {
            return (GeometryDatatype)rdfDatatype;
        }
        throw new DatatypeFormatException("Unrecognised Geometry Datatype: " + rdfDatatype.getURI() + " Ensure that Datatype is extending GeometryDatatype.");
    }

    public static final GeometryDatatype get(String datatypeURI) {
        GeometryDatatype.checkURI(datatypeURI);
        RDFDatatype rdfDatatype = GeometryDatatype.typeMapper().getTypeByName(datatypeURI);
        return GeometryDatatype.get(rdfDatatype);
    }

    public static final boolean checkURI(String datatypeURI) throws DatatypeFormatException {
        RDFDatatype rdfDatatype = GeometryDatatype.typeMapper().getTypeByName(datatypeURI);
        if (rdfDatatype != null) {
            return rdfDatatype instanceof GeometryDatatype;
        }
        throw new DatatypeFormatException("Datatype not found: " + datatypeURI + " Ensure that GeoSPARQL is enabled and Datatype has been registered.");
    }

    public static final boolean check(RDFDatatype rdfDatatype) {
        return GeometryDatatype.checkURI(rdfDatatype.getURI());
    }

    private static class Types {
        private static final TypeMapper MAPPER;

        private Types() {
        }

        public static TypeMapper addDatatypes() {
            TypeMapper mapper = TypeMapper.getInstance();
            mapper.registerDatatype(WKTDatatype.INSTANCE);
            mapper.registerDatatype(GMLDatatype.INSTANCE);
            return mapper;
        }

        public static void init() {
        }

        static {
            JenaSystem.init();
            MAPPER = Types.addDatatypes();
        }
    }
}

