/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogOperationType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.AccessLogReader;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAbandonForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAbandonForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAbandonRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAbandonResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAddAssuranceCompletedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAddForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAddForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAddRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAddResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedBindForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedBindForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedBindRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedBindResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedClientCertificateAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedCompareForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedCompareForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedCompareRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedCompareResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedConnectAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedDeleteAssuranceCompletedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedDeleteForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedDeleteForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedDeleteRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedDeleteResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedDisconnectAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedEntryRebalancingRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedEntryRebalancingResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedExtendedForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedExtendedForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedExtendedRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedExtendedResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedIntermediateResponseAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedModifyAssuranceCompletedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedModifyDNAssuranceCompletedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedModifyDNForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedModifyDNForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedModifyDNRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedModifyDNResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedModifyForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedModifyForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedModifyRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedModifyResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedSearchEntryAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedSearchForwardAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedSearchForwardFailedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedSearchReferenceAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedSearchRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedSearchResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedSecurityNegotiationAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedUnbindRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextLogMessages;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class TextFormattedAccessLogReader
implements AccessLogReader {
    @NotNull
    private final BufferedReader logReader;

    public TextFormattedAccessLogReader(@NotNull String logFilePath) throws IOException {
        this(new File(logFilePath));
    }

    public TextFormattedAccessLogReader(@NotNull File logFile) throws IOException {
        this.logReader = new BufferedReader(new FileReader(logFile));
    }

    public TextFormattedAccessLogReader(@NotNull InputStream inputStream) {
        this.logReader = new BufferedReader(new InputStreamReader(inputStream));
    }

    @Override
    @Nullable
    public TextFormattedAccessLogMessage readMessage() throws IOException, LogException {
        String messageString;
        do {
            if ((messageString = this.logReader.readLine()) != null) continue;
            return null;
        } while (messageString.isEmpty() || messageString.startsWith("#"));
        return TextFormattedAccessLogReader.parseMessage(messageString);
    }

    @NotNull
    public static TextFormattedAccessLogMessage parseMessage(@NotNull String messageString) throws LogException {
        TextFormattedLogMessage m = new TextFormattedLogMessage(messageString);
        List<String> unnamedFields = m.getFields().get("");
        if (unnamedFields == null || unnamedFields.isEmpty()) {
            throw new LogException(messageString, TextLogMessages.ERR_TEXT_ACCESS_READER_CANNOT_DETERMINE_MESSAGE_TYPE.get(messageString));
        }
        String messageOrOpType = unnamedFields.get(0);
        AccessLogMessageType messageType = AccessLogMessageType.forName(messageOrOpType);
        if (messageType != null) {
            switch (messageType) {
                case CONNECT: {
                    return new TextFormattedConnectAccessLogMessage(m);
                }
                case DISCONNECT: {
                    return new TextFormattedDisconnectAccessLogMessage(m);
                }
                case SECURITY_NEGOTIATION: {
                    return new TextFormattedSecurityNegotiationAccessLogMessage(m);
                }
                case CLIENT_CERTIFICATE: {
                    return new TextFormattedClientCertificateAccessLogMessage(m);
                }
                case ENTRY_REBALANCING_REQUEST: {
                    return new TextFormattedEntryRebalancingRequestAccessLogMessage(m);
                }
                case ENTRY_REBALANCING_RESULT: {
                    return new TextFormattedEntryRebalancingResultAccessLogMessage(m);
                }
            }
            throw new LogException(messageString, TextLogMessages.ERR_TEXT_ACCESS_READER_CANNOT_DETERMINE_MESSAGE_TYPE.get(messageString));
        }
        AccessLogOperationType opType = AccessLogOperationType.forName(messageOrOpType);
        if (opType == null) {
            throw new LogException(messageString, TextLogMessages.ERR_TEXT_ACCESS_READER_CANNOT_DETERMINE_MESSAGE_TYPE.get(messageOrOpType));
        }
        if (unnamedFields.size() < 2) {
            throw new LogException(messageString, TextLogMessages.ERR_TEXT_ACCESS_READER_CANNOT_DETERMINE_MESSAGE_TYPE.get(messageString));
        }
        messageType = AccessLogMessageType.forName(unnamedFields.get(1));
        if (messageType == null) {
            throw new LogException(messageString, TextLogMessages.ERR_TEXT_ACCESS_READER_CANNOT_DETERMINE_MESSAGE_TYPE.get(messageString));
        }
        switch (messageType) {
            case REQUEST: {
                switch (opType) {
                    case ABANDON: {
                        return new TextFormattedAbandonRequestAccessLogMessage(m);
                    }
                    case ADD: {
                        return new TextFormattedAddRequestAccessLogMessage(m);
                    }
                    case BIND: {
                        return new TextFormattedBindRequestAccessLogMessage(m);
                    }
                    case COMPARE: {
                        return new TextFormattedCompareRequestAccessLogMessage(m);
                    }
                    case DELETE: {
                        return new TextFormattedDeleteRequestAccessLogMessage(m);
                    }
                    case EXTENDED: {
                        return new TextFormattedExtendedRequestAccessLogMessage(m);
                    }
                    case MODIFY: {
                        return new TextFormattedModifyRequestAccessLogMessage(m);
                    }
                    case MODDN: {
                        return new TextFormattedModifyDNRequestAccessLogMessage(m);
                    }
                    case SEARCH: {
                        return new TextFormattedSearchRequestAccessLogMessage(m);
                    }
                    case UNBIND: {
                        return new TextFormattedUnbindRequestAccessLogMessage(m);
                    }
                }
                throw new LogException(messageString, TextLogMessages.ERR_TEXT_ACCESS_READER_UNSUPPORTED_REQUEST_OP_TYPE.get(messageString));
            }
            case FORWARD: {
                switch (opType) {
                    case ABANDON: {
                        return new TextFormattedAbandonForwardAccessLogMessage(m);
                    }
                    case ADD: {
                        return new TextFormattedAddForwardAccessLogMessage(m);
                    }
                    case BIND: {
                        return new TextFormattedBindForwardAccessLogMessage(m);
                    }
                    case COMPARE: {
                        return new TextFormattedCompareForwardAccessLogMessage(m);
                    }
                    case DELETE: {
                        return new TextFormattedDeleteForwardAccessLogMessage(m);
                    }
                    case EXTENDED: {
                        return new TextFormattedExtendedForwardAccessLogMessage(m);
                    }
                    case MODIFY: {
                        return new TextFormattedModifyForwardAccessLogMessage(m);
                    }
                    case MODDN: {
                        return new TextFormattedModifyDNForwardAccessLogMessage(m);
                    }
                    case SEARCH: {
                        return new TextFormattedSearchForwardAccessLogMessage(m);
                    }
                }
                throw new LogException(messageString, TextLogMessages.ERR_TEXT_ACCESS_READER_UNSUPPORTED_FORWARD_OP_TYPE.get(messageString));
            }
            case FORWARD_FAILED: {
                switch (opType) {
                    case ABANDON: {
                        return new TextFormattedAbandonForwardFailedAccessLogMessage(m);
                    }
                    case ADD: {
                        return new TextFormattedAddForwardFailedAccessLogMessage(m);
                    }
                    case BIND: {
                        return new TextFormattedBindForwardFailedAccessLogMessage(m);
                    }
                    case COMPARE: {
                        return new TextFormattedCompareForwardFailedAccessLogMessage(m);
                    }
                    case DELETE: {
                        return new TextFormattedDeleteForwardFailedAccessLogMessage(m);
                    }
                    case EXTENDED: {
                        return new TextFormattedExtendedForwardFailedAccessLogMessage(m);
                    }
                    case MODIFY: {
                        return new TextFormattedModifyForwardFailedAccessLogMessage(m);
                    }
                    case MODDN: {
                        return new TextFormattedModifyDNForwardFailedAccessLogMessage(m);
                    }
                    case SEARCH: {
                        return new TextFormattedSearchForwardFailedAccessLogMessage(m);
                    }
                }
                throw new LogException(messageString, TextLogMessages.ERR_TEXT_ACCESS_READER_UNSUPPORTED_FORWARD_FAILED_OP_TYPE.get(messageString));
            }
            case RESULT: {
                switch (opType) {
                    case ABANDON: {
                        return new TextFormattedAbandonResultAccessLogMessage(m);
                    }
                    case ADD: {
                        return new TextFormattedAddResultAccessLogMessage(m);
                    }
                    case BIND: {
                        return new TextFormattedBindResultAccessLogMessage(m);
                    }
                    case COMPARE: {
                        return new TextFormattedCompareResultAccessLogMessage(m);
                    }
                    case DELETE: {
                        return new TextFormattedDeleteResultAccessLogMessage(m);
                    }
                    case EXTENDED: {
                        return new TextFormattedExtendedResultAccessLogMessage(m);
                    }
                    case MODIFY: {
                        return new TextFormattedModifyResultAccessLogMessage(m);
                    }
                    case MODDN: {
                        return new TextFormattedModifyDNResultAccessLogMessage(m);
                    }
                    case SEARCH: {
                        return new TextFormattedSearchResultAccessLogMessage(m);
                    }
                }
                throw new LogException(messageString, TextLogMessages.ERR_TEXT_ACCESS_READER_UNSUPPORTED_RESULT_OP_TYPE.get(messageString));
            }
            case ASSURANCE_COMPLETE: {
                switch (opType) {
                    case ADD: {
                        return new TextFormattedAddAssuranceCompletedAccessLogMessage(m);
                    }
                    case DELETE: {
                        return new TextFormattedDeleteAssuranceCompletedAccessLogMessage(m);
                    }
                    case MODIFY: {
                        return new TextFormattedModifyAssuranceCompletedAccessLogMessage(m);
                    }
                    case MODDN: {
                        return new TextFormattedModifyDNAssuranceCompletedAccessLogMessage(m);
                    }
                }
                throw new LogException(messageString, TextLogMessages.ERR_TEXT_ACCESS_READER_UNSUPPORTED_ASSURANCE_OP_TYPE.get(messageString));
            }
            case ENTRY: {
                return new TextFormattedSearchEntryAccessLogMessage(m);
            }
            case REFERENCE: {
                return new TextFormattedSearchReferenceAccessLogMessage(m);
            }
            case INTERMEDIATE_RESPONSE: {
                return new TextFormattedIntermediateResponseAccessLogMessage(m, opType);
            }
        }
        throw new LogException(messageString, TextLogMessages.ERR_TEXT_ACCESS_READER_CANNOT_DETERMINE_MESSAGE_TYPE.get(messageString));
    }

    @Override
    public void close() throws IOException {
        this.logReader.close();
    }
}

