/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.function;

import com.github.f4b6a3.uuid.util.internal.RandomUtil;
import java.util.function.LongSupplier;

@FunctionalInterface
public interface NodeIdFunction
extends LongSupplier {
    public static long getRandom() {
        return NodeIdFunction.toExpectedRange(RandomUtil.newSecureRandom().nextLong());
    }

    public static long getMulticastRandom() {
        return NodeIdFunction.toMulticast(NodeIdFunction.getRandom());
    }

    public static long toExpectedRange(long nodeid) {
        return nodeid & 0xFFFFFFFFFFFFL;
    }

    public static long toMulticast(long nodeid) {
        return nodeid & 0xFFFFFFFFFFFFL | 0x10000000000L;
    }

    public static boolean isMulticast(long nodeid) {
        return (nodeid & 0x10000000000L) == 0x10000000000L;
    }
}

