/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.mail.Flags;
import java.util.List;
import org.apache.james.mailbox.ApplicableFlagBuilder;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.util.streams.Iterators;

public class ApplicableFlagCalculator {
    private final Iterable<MailboxMessage> mailboxMessages;

    public ApplicableFlagCalculator(Iterable<MailboxMessage> mailboxMessages) {
        Preconditions.checkNotNull(mailboxMessages);
        this.mailboxMessages = mailboxMessages;
    }

    public Flags computeApplicableFlags() {
        return ApplicableFlagBuilder.builder().add((List)Iterators.toStream(this.mailboxMessages.iterator()).map(MailboxMessage::createFlags).collect(ImmutableList.toImmutableList())).build();
    }
}

