/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.memory.upload;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.jmap.api.upload.UploadUsageRepository;
import reactor.core.publisher.Mono;

public class InMemoryUploadUsageRepository
implements UploadUsageRepository {
    private static final QuotaSizeUsage DEFAULT_QUOTA_SIZE_USAGE = QuotaSizeUsage.size((long)0L);
    private final Map<Username, AtomicReference<QuotaSizeUsage>> cache = new ConcurrentHashMap<Username, AtomicReference<QuotaSizeUsage>>();

    public Mono<Void> increaseSpace(Username username, QuotaSizeUsage usage) {
        return this.updateSpace(username, usage.asLong());
    }

    public Mono<Void> decreaseSpace(Username username, QuotaSizeUsage usage) {
        return this.updateSpace(username, Math.negateExact(usage.asLong()));
    }

    private Mono<Void> updateSpace(Username username, long amount) {
        return Mono.fromRunnable(() -> {
            AtomicReference<QuotaSizeUsage> quotaSizeUsageAtomicReference = this.cache.get(username);
            if (Objects.isNull(quotaSizeUsageAtomicReference)) {
                this.cache.put(username, new AtomicReference<QuotaSizeUsage>(QuotaSizeUsage.size((long)amount)));
            } else {
                quotaSizeUsageAtomicReference.updateAndGet(quotaSizeUsage -> quotaSizeUsage.add(amount));
            }
        });
    }

    public Mono<QuotaSizeUsage> getSpaceUsage(Username username) {
        return Mono.just(this.cache.getOrDefault(username, new AtomicReference<QuotaSizeUsage>(DEFAULT_QUOTA_SIZE_USAGE))).map(quotaSizeUsageAtomicReference -> (QuotaSizeUsage)quotaSizeUsageAtomicReference.get());
    }

    public Mono<Void> resetSpace(Username username, QuotaSizeUsage usage) {
        return this.getSpaceUsage(username).flatMap(quotaSizeUsage -> Mono.from(this.decreaseSpace(username, (QuotaSizeUsage)quotaSizeUsage))).then(this.increaseSpace(username, usage));
    }
}

