/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.google.inject.Inject;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.lib.handler.ProtocolHandlerLoader;
import org.apache.james.utils.ClassName;
import org.apache.james.utils.GuiceLoader;

public class GuiceProtocolHandlerLoader
implements ProtocolHandlerLoader {
    private final GuiceLoader guiceLoader;

    @Inject
    public GuiceProtocolHandlerLoader(GuiceLoader genericLoader) {
        this.guiceLoader = genericLoader;
    }

    public ProtocolHandler load(String name, Configuration config) throws ProtocolHandlerLoader.LoadingException {
        ProtocolHandler handler = this.createProtocolHandler(name);
        try {
            handler.init(config);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        return handler;
    }

    private ProtocolHandler createProtocolHandler(String name) throws ProtocolHandlerLoader.LoadingException {
        try {
            ClassName className = new ClassName(name);
            return (ProtocolHandler)this.guiceLoader.instantiate(className);
        }
        catch (Exception e) {
            throw new ProtocolHandlerLoader.LoadingException("Can not load " + name, (Throwable)e);
        }
    }
}

