/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt;

import com.github.fge.lambdas.Throwing;
import jakarta.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RecipientRewriteTableUserDeletionTaskStep
implements DeleteUserDataTaskStep {
    private final RecipientRewriteTable rrt;

    @Inject
    public RecipientRewriteTableUserDeletionTaskStep(RecipientRewriteTable rrt) {
        this.rrt = rrt;
    }

    @Override
    public DeleteUserDataTaskStep.StepName name() {
        return new DeleteUserDataTaskStep.StepName("RecipientRewriteTableUserDeletionTaskStep");
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Publisher<Void> deleteUserData(Username username) {
        return this.deleteRRT(username).then(this.deleteForwards(username)).then(this.deleteGroup(username));
    }

    private Flux<Void> deleteRRT(Username username) {
        MappingSource mappingSource = MappingSource.fromUser(username);
        return Mono.fromCallable(() -> this.rrt.getStoredMappings(mappingSource)).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).flatMapMany(mappings -> Flux.fromStream(mappings.asStream())).flatMap(mapping -> this.deleteMapping(mappingSource, (Mapping)mapping));
    }

    private Mono<Void> deleteMapping(MappingSource mappingSource, Mapping mapping) {
        return Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.rrt.removeMapping(mappingSource, mapping))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).then();
    }

    private Mono<Void> deleteForwards(Username username) {
        return this.deleteSource(Mapping.forward(username.asString()));
    }

    private Mono<Void> deleteGroup(Username username) {
        return this.deleteSource(Mapping.group(username.asString()));
    }

    private Mono<Void> deleteSource(Mapping mapping) {
        return Mono.fromCallable(() -> this.rrt.listSources(mapping)).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).flatMapMany(Flux::fromStream).flatMap(source -> this.deleteMapping((MappingSource)source, mapping)).then();
    }
}

