/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.core.healthcheck.ResultStatus;
import org.apache.james.webadmin.PublicRoutes;
import org.apache.james.webadmin.dto.HealthCheckDto;
import org.apache.james.webadmin.dto.HealthCheckExecutionResultDto;
import org.apache.james.webadmin.dto.HeathCheckAggregationExecutionResultDto;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

public class HealthCheckRoutes
implements PublicRoutes {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckRoutes.class);
    public static final String HEALTHCHECK = "/healthcheck";
    public static final String CHECKS = "/checks";
    private static final String PARAM_COMPONENT_NAME = "componentName";
    private static final String QUERY_PARAM_COMPONENT_NAMES = "check";
    private static final String QUERY_PARAM_STRICT = "strict";
    private final JsonTransformer jsonTransformer;
    private final Set<HealthCheck> healthChecks;

    @Inject
    public HealthCheckRoutes(@Named(value="resolved-checks") Set<HealthCheck> healthChecks, JsonTransformer jsonTransformer) {
        this.healthChecks = healthChecks;
        this.jsonTransformer = jsonTransformer;
    }

    @Override
    public String getBasePath() {
        return HEALTHCHECK;
    }

    @Override
    public void define(Service service) {
        service.get(HEALTHCHECK, this::validateHealthChecks, (ResponseTransformer)this.jsonTransformer);
        service.get("/healthcheck/checks/:componentName", this::performHealthCheckForComponent, (ResponseTransformer)this.jsonTransformer);
        service.get("/healthcheck/checks", this::getHealthChecks, (ResponseTransformer)this.jsonTransformer);
    }

    public Object validateHealthChecks(Request request, Response response) {
        Set<ComponentName> selectedComponentNames = this.getComponentNames(request);
        StatusCodeConvertMode convertMode = this.getStatusCodeConvertMode(request);
        Collection<HealthCheck> selectedHealthChecks = this.selectHealthChecks(selectedComponentNames);
        List results = (List)this.executeHealthChecks(selectedHealthChecks).collectList().block();
        ResultStatus status = this.retrieveAggregationStatus(results);
        response.status(convertMode.getCorrespondingStatusCode(status));
        return new HeathCheckAggregationExecutionResultDto(status, this.mapResultToDto(results));
    }

    public Object performHealthCheckForComponent(Request request, Response response) {
        String componentName = request.params(PARAM_COMPONENT_NAME);
        StatusCodeConvertMode convertMode = this.getStatusCodeConvertMode(request);
        HealthCheck healthCheck = this.healthChecks.stream().filter(c -> c.componentName().getName().equals(componentName)).findFirst().orElseThrow(() -> this.throw404(componentName));
        Result result = (Result)Mono.from((Publisher)healthCheck.check()).block();
        this.logFailedCheck(result);
        response.status(convertMode.getCorrespondingStatusCode(result.getStatus()));
        return new HealthCheckExecutionResultDto(result);
    }

    public Object getHealthChecks(Request request, Response response) {
        return this.healthChecks.stream().map(healthCheck -> new HealthCheckDto(healthCheck.componentName())).collect(ImmutableList.toImmutableList());
    }

    private Collection<HealthCheck> selectHealthChecks(Set<ComponentName> selectedComponentNames) {
        if (selectedComponentNames.isEmpty()) {
            return this.healthChecks;
        }
        return this.getHealthChecks(selectedComponentNames);
    }

    private Set<ComponentName> getComponentNames(Request request) {
        return (Set)Optional.ofNullable(request.queryParamsValues(QUERY_PARAM_COMPONENT_NAMES)).stream().flatMap(Stream::of).map(ComponentName::new).collect(ImmutableSet.toImmutableSet());
    }

    private StatusCodeConvertMode getStatusCodeConvertMode(Request request) {
        return Optional.ofNullable(request.queryParamsValues(QUERY_PARAM_STRICT)).map(s -> StatusCodeConvertMode.STRICT).orElse(StatusCodeConvertMode.RELAXED);
    }

    private Collection<HealthCheck> getHealthChecks(Set<ComponentName> selectedComponentNames) {
        Set componentNames = (Set)this.healthChecks.stream().map(HealthCheck::componentName).collect(ImmutableSet.toImmutableSet());
        List<ComponentName> nonExistedComponentNames = selectedComponentNames.stream().filter(selectedComponentName -> !componentNames.contains(selectedComponentName)).toList();
        if (!nonExistedComponentNames.isEmpty()) {
            throw this.throw404(nonExistedComponentNames.stream().map(ComponentName::getName).toList());
        }
        return this.healthChecks.stream().filter(healthCheck -> selectedComponentNames.contains(healthCheck.componentName())).toList();
    }

    private void logFailedCheck(Result result) {
        switch (result.getStatus()) {
            case UNHEALTHY: {
                if (result.getError().isPresent()) {
                    LOGGER.error("HealthCheck failed for {} : {}", new Object[]{result.getComponentName().getName(), result.getCause().orElse(""), result.getError().get()});
                    break;
                }
                LOGGER.error("HealthCheck failed for {} : {}", (Object)result.getComponentName().getName(), (Object)result.getCause().orElse(""));
                break;
            }
            case DEGRADED: {
                if (result.getError().isPresent()) {
                    LOGGER.warn("HealthCheck is unstable for {} : {}", new Object[]{result.getComponentName().getName(), result.getCause().orElse(""), result.getError().get()});
                    break;
                }
                LOGGER.warn("HealthCheck is unstable for {} : {}", (Object)result.getComponentName().getName(), (Object)result.getCause().orElse(""));
                break;
            }
        }
    }

    private Flux<Result> executeHealthChecks(Collection<HealthCheck> healthChecks) {
        return Flux.fromIterable(healthChecks).flatMap(HealthCheck::check, 16).doOnNext(this::logFailedCheck);
    }

    private ResultStatus retrieveAggregationStatus(List<Result> results) {
        return results.stream().map(Result::getStatus).reduce(ResultStatus::merge).orElse(ResultStatus.HEALTHY);
    }

    private ImmutableList<HealthCheckExecutionResultDto> mapResultToDto(List<Result> results) {
        return (ImmutableList)results.stream().map(HealthCheckExecutionResultDto::new).collect(ImmutableList.toImmutableList());
    }

    private HaltException throw404(String componentName) {
        return this.throw404("Component with name %s cannot be found", componentName);
    }

    private HaltException throw404(Collection<String> componentNames) {
        return this.throw404("Components with name %s cannot be found", componentNames.stream().collect(Collectors.joining(", ")));
    }

    private HaltException throw404(String message, String componentNames) {
        return ErrorResponder.builder().message(message, componentNames).statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).haltError();
    }

    public static enum StatusCodeConvertMode {
        STRICT(resultStatus -> {
            switch (resultStatus) {
                case HEALTHY: {
                    return 200;
                }
                case DEGRADED: 
                case UNHEALTHY: {
                    return 503;
                }
            }
            throw new NotImplementedException(String.valueOf(resultStatus) + " is not supported");
        }),
        RELAXED(resultStatus -> {
            switch (resultStatus) {
                case HEALTHY: 
                case DEGRADED: {
                    return 200;
                }
                case UNHEALTHY: {
                    return 503;
                }
            }
            throw new NotImplementedException(String.valueOf(resultStatus) + " is not supported");
        });

        private Function<ResultStatus, Integer> converter;

        private StatusCodeConvertMode(Function<ResultStatus, Integer> converter) {
            this.converter = converter;
        }

        public int getCorrespondingStatusCode(ResultStatus result) {
            return this.converter.apply(result);
        }
    }
}

