/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import java.util.Collections;
import java.util.Map;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.QueryImpl;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.slice.DistributedConfiguration;
import org.apache.openjpa.slice.QueryTargetPolicy;
import org.apache.openjpa.slice.ReentrantSliceLock;
import org.apache.openjpa.slice.jdbc.TargetFetchConfiguration;

public class DistributedQueryImpl
extends QueryImpl {
    private static final long serialVersionUID = 1L;
    private final ReentrantSliceLock _lock = new ReentrantSliceLock();
    private DistributedConfiguration _conf;

    public DistributedQueryImpl(Broker broker, String language, StoreQuery storeQuery) {
        super(broker, language, storeQuery);
        this._conf = (DistributedConfiguration)broker.getConfiguration();
    }

    @Override
    public Object execute(Map params) {
        QueryTargetPolicy policy;
        TargetFetchConfiguration fetch = (TargetFetchConfiguration)this.getFetchConfiguration();
        if (!fetch.isExplicitTarget() && (policy = this._conf.getQueryTargetPolicyInstance()) != null) {
            String[] targets = policy.getTargets(this.getQueryString(), Collections.unmodifiableMap(params), this.getLanguage(), this._conf.getActiveSliceNames(), this.getBroker());
            fetch.setTargets(targets);
        }
        return super.execute(params);
    }

    @Override
    public void lock() {
        this._lock.lock();
    }

    @Override
    public void unlock() {
        this._lock.unlock();
    }
}

