/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.VectorType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.DefaultVectorType;
import com.datastax.oss.driver.internal.core.type.util.VIntCoding;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;

public class VectorCodec<SubtypeT>
implements TypeCodec<CqlVector<SubtypeT>> {
    private final VectorType cqlType;
    private final GenericType<CqlVector<SubtypeT>> javaType;
    private final TypeCodec<SubtypeT> subtypeCodec;

    public VectorCodec(@NonNull VectorType cqlType, @NonNull TypeCodec<SubtypeT> subtypeCodec) {
        this.cqlType = cqlType;
        this.subtypeCodec = subtypeCodec;
        this.javaType = GenericType.vectorOf(subtypeCodec.getJavaType());
    }

    public VectorCodec(int dimensions, @NonNull TypeCodec<SubtypeT> subtypeCodec) {
        this(new DefaultVectorType(subtypeCodec.getCqlType(), dimensions), subtypeCodec);
    }

    @Override
    @NonNull
    public GenericType<CqlVector<SubtypeT>> getJavaType() {
        return this.javaType;
    }

    @Override
    @NonNull
    public Optional<Integer> serializedSize() {
        return this.subtypeCodec.serializedSize().isPresent() ? Optional.of(this.subtypeCodec.serializedSize().get() * this.cqlType.getDimensions()) : Optional.empty();
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.cqlType;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable CqlVector<SubtypeT> value, @NonNull ProtocolVersion protocolVersion) {
        boolean isVarSized;
        boolean bl = isVarSized = !this.subtypeCodec.serializedSize().isPresent();
        if (value == null || this.cqlType.getDimensions() <= 0) {
            return null;
        }
        ByteBuffer[] valueBuffs = new ByteBuffer[this.cqlType.getDimensions()];
        Iterator<SubtypeT> values = value.iterator();
        int allValueBuffsSize = 0;
        for (int i = 0; i < this.cqlType.getDimensions(); ++i) {
            ByteBuffer valueBuff;
            SubtypeT valueObj;
            try {
                valueObj = values.next();
            }
            catch (NoSuchElementException nsee) {
                throw new IllegalArgumentException(String.format("Not enough elements; must provide elements for %d dimensions", this.cqlType.getDimensions()));
            }
            try {
                valueBuff = this.subtypeCodec.encode(valueObj, protocolVersion);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Invalid type for element: " + valueObj.getClass());
            }
            if (valueBuff == null) {
                throw new NullPointerException("Vector elements cannot encode to CQL NULL");
            }
            int elementSize = valueBuff.limit();
            if (isVarSized) {
                allValueBuffsSize += VIntCoding.computeVIntSize(elementSize);
            }
            allValueBuffsSize += elementSize;
            valueBuff.rewind();
            valueBuffs[i] = valueBuff;
        }
        if (values.hasNext()) {
            throw new IllegalArgumentException(String.format("Too many elements; must provide elements for %d dimensions", this.cqlType.getDimensions()));
        }
        assert (valueBuffs.length > 0);
        ByteBuffer rv = ByteBuffer.allocate(allValueBuffsSize);
        for (int i = 0; i < this.cqlType.getDimensions(); ++i) {
            if (isVarSized) {
                VIntCoding.writeUnsignedVInt32(valueBuffs[i].remaining(), rv);
            }
            rv.put(valueBuffs[i]);
        }
        rv.flip();
        return rv;
    }

    @Override
    @Nullable
    public CqlVector<SubtypeT> decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        this.subtypeCodec.serializedSize().ifPresent(fixed_size -> {
            if (bytes.remaining() != this.cqlType.getDimensions() * fixed_size) {
                throw new IllegalArgumentException(String.format("Expected elements of uniform size, observed %d elements with total bytes %d", this.cqlType.getDimensions(), bytes.remaining()));
            }
        });
        ByteBuffer slice = bytes.slice();
        ArrayList<SubtypeT> rv = new ArrayList<SubtypeT>(this.cqlType.getDimensions());
        for (int i = 0; i < this.cqlType.getDimensions(); ++i) {
            int size = this.subtypeCodec.serializedSize().orElseGet(() -> VIntCoding.getUnsignedVInt32(slice, slice.position()));
            if (!this.subtypeCodec.serializedSize().isPresent()) {
                slice.position(slice.position() + VIntCoding.computeUnsignedVIntSize(size));
            }
            int originalPosition = slice.position();
            slice.limit(originalPosition + size);
            rv.add(this.subtypeCodec.decode(slice, protocolVersion));
            slice.position(originalPosition + size);
            slice.limit(slice.capacity());
        }
        if (slice.hasRemaining()) {
            throw new IllegalArgumentException(String.format("Too many elements; must provide elements for %d dimensions", this.cqlType.getDimensions()));
        }
        return CqlVector.newInstance(rv);
    }

    @Override
    @NonNull
    public String format(CqlVector<SubtypeT> value) {
        if (value == null) {
            return "NULL";
        }
        return value.stream().map(this.subtypeCodec::format).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    @Nullable
    public CqlVector<SubtypeT> parse(@Nullable String value) {
        return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : CqlVector.from(value, this.subtypeCodec);
    }
}

