/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.metrics.DefaultMetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.DropwizardMetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.NoopMetricsFactory;
import com.datastax.oss.driver.internal.core.util.Dependency;
import com.datastax.oss.driver.internal.core.util.GraalDependencyChecker;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import java.util.function.BooleanSupplier;

public class DefaultMetricsFactorySubstitutions {

    public static class DropwizardMissing
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return !GraalDependencyChecker.isPresent(Dependency.DROPWIZARD);
        }
    }

    @TargetClass(value=DropwizardMetricsFactory.class, onlyWith={DropwizardMissing.class})
    @Delete
    public static final class DeleteDropwizardMetricsFactory {
    }

    @TargetClass(value=DefaultMetricsFactory.class, onlyWith={DropwizardMissing.class})
    public static final class DefaultMetricsFactoryDropwizardMissing {
        @Alias
        @TargetElement(name="delegate")
        private MetricsFactory delegate;

        @Substitute
        @TargetElement(name="<init>")
        public DefaultMetricsFactoryDropwizardMissing(DriverContext context) {
            this.delegate = new NoopMetricsFactory(context);
        }
    }
}

