/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.onami.lifecycle;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import org.apache.james.onami.lifecycle.AbstractBasicStageable;
import org.apache.james.onami.lifecycle.DefaultStager;
import org.apache.james.onami.lifecycle.StageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StageableMethod
extends AbstractBasicStageable<Object> {
    private final Method stageMethod;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStager.class);

    StageableMethod(Method stageMethod, Object injectee) {
        super(injectee);
        this.stageMethod = stageMethod;
    }

    @Override
    public final void stage(StageHandler stageHandler) {
        LOGGER.trace("Closing object: {}", this.object);
        try {
            AccessController.doPrivileged(() -> {
                this.stageMethod.setAccessible(true);
                return null;
            });
            this.stageMethod.invoke(this.object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            stageHandler.onError(this.object, e.getCause());
            return;
        }
        catch (Throwable e) {
            stageHandler.onError(this.object, e);
            return;
        }
        stageHandler.onSuccess(this.object);
    }
}

