/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.core;

import java.net.UnknownHostException;
import org.apache.james.jspf.core.Inet6Util;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.xbill.DNS.Address;

public class IPAddr {
    private static final int MASK8 = 255;
    private static final int MASK16 = 65535;
    private int[] address = new int[4];
    private int[] mask = new int[4];
    private int maskLength = 32;
    private int ipLength = 4;
    private int ipRun = 4;
    private String ipJoiner = ".";
    private static String ipv4MappedRegex = "::FFFF:[1-9][0-9]{0,2}\\.[1-9][0-9]{0,2}\\.[1-9][0-9]{0,2}\\.[1-9][0-9]{0,2}";

    private IPAddr() {
    }

    public static IPAddr getAddress(String netAddress, int maskLength) throws PermErrorException {
        IPAddr returnAddress = new IPAddr();
        returnAddress.stringToInternal(netAddress);
        returnAddress.setMask(maskLength);
        return returnAddress;
    }

    public static IPAddr getAddress(String netAddress) throws PermErrorException {
        IPAddr returnAddress = new IPAddr();
        returnAddress.stringToInternal(netAddress);
        returnAddress.setMask(returnAddress.maskLength);
        return returnAddress;
    }

    public static boolean isIPAddr(String data) {
        try {
            IPAddr.getAddress(data);
            return true;
        }
        catch (PermErrorException e) {
            return false;
        }
    }

    private void setIP6Defaults() {
        this.ipLength = 16;
        this.ipJoiner = ":";
        this.address = new int[8];
        this.mask = new int[8];
        this.ipRun = 8;
    }

    public void setMask(int maskLength) {
        int startMask;
        int maskSize;
        this.maskLength = maskLength;
        if (this.ipLength == 4) {
            if (maskLength <= -1 || maskLength >= 33) {
                maskLength = 32;
            }
            maskSize = 8;
            startMask = (maskLength - 1) / maskSize;
        } else {
            if (maskLength <= -1 || maskLength >= 129) {
                maskLength = 128;
            }
            maskSize = 16;
            startMask = (maskLength - 1) / maskSize;
        }
        for (int i = 0; i < this.ipRun; ++i) {
            if (i < startMask) {
                this.mask[i] = 65535;
                continue;
            }
            if (i == startMask) {
                int shift = (i + 1) * maskSize - maskLength;
                this.mask[i] = 65535 << shift & 0xFFFF;
                continue;
            }
            this.mask[i] = 0;
        }
    }

    public static String stripDot(String data) {
        if ((data = data.trim()).endsWith(".")) {
            return data.substring(0, data.length() - 1);
        }
        return data;
    }

    private void stringToInternal(String netAddress) throws PermErrorException {
        block6: {
            netAddress = IPAddr.stripDot(netAddress);
            try {
                byte[] bytes = Inet6Util.createByteArrayFromIPAddressString(netAddress);
                if (bytes.length == 4) {
                    for (int i = 0; i < bytes.length; ++i) {
                        this.address[i] = bytes[i];
                    }
                    break block6;
                }
                if (bytes.length == 16) {
                    this.setIP6Defaults();
                    for (int i = 0; i < bytes.length / 2; ++i) {
                        this.address[i] = this.unsigned(bytes[i * 2]) * 256 + this.unsigned(bytes[i * 2 + 1]);
                    }
                    break block6;
                }
                throw new PermErrorException("Not a valid address: " + netAddress);
            }
            catch (NumberFormatException e) {
                throw new PermErrorException("Not a valid address: " + netAddress);
            }
        }
    }

    private String getHex(long data) {
        StringBuffer fullHex = new StringBuffer();
        fullHex.append("0000" + Long.toHexString(data).toUpperCase());
        fullHex = fullHex.delete(0, fullHex.length() - 4);
        return fullHex.toString();
    }

    public String getIPAddress() {
        return this.getIPAddress(this.address);
    }

    private String getIPAddress(int[] addressData) {
        StringBuffer createAddress = new StringBuffer();
        if (this.ipLength == 4) {
            int[] workingAddress = this.get8BitAddress(addressData);
            createAddress.append(workingAddress[0]);
            for (int i = 1; i < this.ipRun; ++i) {
                createAddress.append(this.ipJoiner + workingAddress[i]);
            }
        } else {
            int[] workingAddress = addressData;
            createAddress.append(this.getHex(workingAddress[0]));
            for (int i = 1; i < this.ipRun; ++i) {
                createAddress.append(this.ipJoiner + this.getHex(workingAddress[i]));
            }
        }
        return createAddress.toString();
    }

    public String getMaskedIPAddress() {
        return this.getIPAddress(this.maskedAddress(this.address, this.mask));
    }

    public String getNibbleFormat() {
        return this.getNibbleFormat(this.address);
    }

    private String getNibbleFormat(int[] address) {
        StringBuffer sb = new StringBuffer();
        int[] ip = address;
        for (int i = 0; i < ip.length; ++i) {
            String hex = this.getHex(ip[i]);
            for (int j = 0; j < hex.length(); ++j) {
                sb.append(hex.charAt(j));
                if (i == ip.length - 1 && j == hex.length() - 1) continue;
                sb.append(".");
            }
        }
        return sb.toString();
    }

    public String getReverseIP() {
        if (IPAddr.isIPV6(this.getIPAddress())) {
            StringBuffer ip6 = new StringBuffer(this.getNibbleFormat());
            return ip6.reverse().append(".ip6.arpa").toString();
        }
        return this.getIPAddress(this.reverseIP(this.address)) + ".in-addr.arpa";
    }

    private int[] get8BitAddress(int[] addressData) {
        int[] convertAddress = new int[4];
        for (int i = 0; i < this.ipRun; ++i) {
            convertAddress[i] = addressData[i] & 0xFF;
        }
        return convertAddress;
    }

    private int[] maskedAddress(int[] addressData, int[] maskData) {
        int[] maskedAddress = new int[this.ipLength];
        for (int i = 0; i < this.ipRun; ++i) {
            maskedAddress[i] = addressData[i] & maskData[i];
        }
        return maskedAddress;
    }

    private int[] reverseIP(int[] addressData) {
        int[] reverseIP = new int[this.ipLength];
        for (int i = 0; i < this.ipRun; ++i) {
            int temp = addressData[i];
            reverseIP[i] = addressData[this.ipRun - 1 - i];
            reverseIP[this.ipRun - 1 - i] = temp;
        }
        return reverseIP;
    }

    public int getMaskLength() {
        return this.maskLength;
    }

    public String toString() {
        return this.getIPAddress();
    }

    private int unsigned(byte data) {
        return data >= 0 ? data : 256 + data;
    }

    public static String getInAddress(String ipAddress) throws PermErrorException {
        if (ipAddress == null) {
            throw new PermErrorException("IP is not a valid ipv4 or ipv6 address");
        }
        if (Inet6Util.isValidIPV4Address(ipAddress)) {
            return "in-addr";
        }
        if (Inet6Util.isValidIP6Address(ipAddress)) {
            return "ip6";
        }
        throw new PermErrorException("IP is not a valid ipv4 or ipv6 address");
    }

    public static boolean isValidIP(String ip) {
        return ip != null && (Inet6Util.isValidIPV4Address(ip) || Inet6Util.isValidIP6Address(ip));
    }

    public static boolean isIPV6(String ip) {
        return Inet6Util.isValidIP6Address(ip);
    }

    public static String getReadableIP(String ip) {
        if (Inet6Util.isValidIP6Address(ip)) {
            try {
                return IPAddr.getConvertedIP(ip);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return ip;
    }

    private static String getConvertedIP(String ip) throws UnknownHostException {
        return Address.getByName((String)ip).getHostAddress();
    }

    public static String getProperIpAddress(String ip) throws PermErrorException {
        if (IPAddr.isIPV6(ip) && IPAddr.isIPV4MappedIP(ip)) {
            try {
                return IPAddr.getConvertedIP(ip);
            }
            catch (UnknownHostException e) {
                throw new PermErrorException("Invalid ipAddress: " + ip);
            }
        }
        return ip;
    }

    private static boolean isIPV4MappedIP(String ip) {
        return ip.toUpperCase().matches(ipv4MappedRegex);
    }
}

