/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.term;

import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.ArithmeticOperator;
import com.datastax.oss.driver.internal.querybuilder.term.ArithmeticTerm;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class BinaryArithmeticTerm
extends ArithmeticTerm {
    private final Term left;
    private final Term right;

    public BinaryArithmeticTerm(@NonNull ArithmeticOperator operator, @NonNull Term left, @NonNull Term right) {
        super(operator);
        Preconditions.checkNotNull((Object)left);
        Preconditions.checkNotNull((Object)right);
        this.left = left;
        this.right = right;
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        BinaryArithmeticTerm.appendAndMaybeParenthesize(this.operator.getPrecedenceLeft(), this.left, builder);
        builder.append(this.operator.getSymbol());
        BinaryArithmeticTerm.appendAndMaybeParenthesize(this.operator.getPrecedenceRight(), this.right, builder);
    }

    @Override
    public boolean isIdempotent() {
        return this.left.isIdempotent() && this.right.isIdempotent();
    }

    @NonNull
    public Term getLeft() {
        return this.left;
    }

    @NonNull
    public Term getRight() {
        return this.right;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof BinaryArithmeticTerm) {
            BinaryArithmeticTerm that = (BinaryArithmeticTerm)other;
            return this.operator.equals((Object)that.operator) && this.left.equals(that.left) && this.right.equals(that.right);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.left, this.right});
    }
}

