/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.modules.mailbox.ListenerConfiguration;

public class ListenersConfiguration {
    private final List<ListenerConfiguration> listenersConfiguration;
    private final boolean enableGroupListenerConsumption;

    public static ListenersConfiguration of(ListenerConfiguration ... listenersConfiguration) {
        return new ListenersConfiguration((List<ListenerConfiguration>)ImmutableList.copyOf((Object[])listenersConfiguration), true);
    }

    public static ListenersConfiguration disabled() {
        return new ListenersConfiguration((List<ListenerConfiguration>)ImmutableList.of(), false);
    }

    public static ListenersConfiguration from(HierarchicalConfiguration<ImmutableNode> configuration) {
        List listeners = configuration.configurationsAt("listener");
        Optional<Boolean> consumeGroups = Optional.ofNullable(configuration.getBoolean("executeGroupListeners", null));
        return new ListenersConfiguration((List)listeners.stream().map(ListenerConfiguration::from).collect(ImmutableList.toImmutableList()), consumeGroups.orElse(true));
    }

    @VisibleForTesting
    ListenersConfiguration(List<ListenerConfiguration> listenersConfiguration, boolean enableGroupListenerConsumption) {
        Preconditions.checkArgument((enableGroupListenerConsumption || listenersConfiguration.isEmpty() ? 1 : 0) != 0, (Object)"'executeGroupListeners' can not be false while extra listeners are configured");
        this.listenersConfiguration = listenersConfiguration;
        this.enableGroupListenerConsumption = enableGroupListenerConsumption;
    }

    public List<ListenerConfiguration> getListenersConfiguration() {
        return this.listenersConfiguration;
    }

    public boolean isGroupListenerConsumptionEnabled() {
        return this.enableGroupListenerConsumption;
    }
}

