/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Extensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public class LDAPConnectionPoolHealthCheck {
    public void ensureNewConnectionValid(@NotNull LDAPConnection connection) throws LDAPException {
    }

    public void ensureConnectionValidAfterAuthentication(@NotNull LDAPConnection connection, @NotNull BindResult bindResult) throws LDAPException {
    }

    public void ensureConnectionValidForCheckout(@NotNull LDAPConnection connection) throws LDAPException {
    }

    public void ensureConnectionValidForRelease(@NotNull LDAPConnection connection) throws LDAPException {
    }

    public void ensureConnectionValidForContinuedUse(@NotNull LDAPConnection connection) throws LDAPException {
    }

    public void performPoolMaintenance(@NotNull AbstractConnectionPool pool) {
    }

    public void ensureConnectionValidAfterException(@NotNull LDAPConnection connection, @NotNull LDAPException exception) throws LDAPException {
        if (!ResultCode.isConnectionUsable(exception.getResultCode())) {
            throw new LDAPException(ResultCode.SERVER_DOWN, LDAPMessages.ERR_POOL_HEALTH_CHECK_CONN_INVALID_AFTER_EXCEPTION.get(StaticUtils.getExceptionMessage(exception)), exception);
        }
    }

    @NotNull
    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("LDAPConnectionPoolHealthCheck()");
    }
}

