/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.vavr.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.events.EventBus;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SearchResUtil;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.AbstractMailboxSelectionRequest;
import org.apache.james.imap.message.response.ExistsResponse;
import org.apache.james.imap.message.response.RecentResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.EnableProcessor;
import org.apache.james.imap.processor.PermitEnableCapabilityProcessor;
import org.apache.james.imap.processor.base.SelectedMailboxImpl;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class AbstractSelectionProcessor<R extends AbstractMailboxSelectionRequest>
extends AbstractMailboxProcessor<R>
implements PermitEnableCapabilityProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSelectionProcessor.class);
    private static final List<Capability> CAPS = ImmutableList.of((Object)ImapConstants.SUPPORTS_QRESYNC, (Object)ImapConstants.SUPPORTS_CONDSTORE);
    private final StatusResponseFactory statusResponseFactory;
    private final boolean openReadOnly;
    private final EventBus eventBus;

    public AbstractSelectionProcessor(Class<R> acceptableClass, MailboxManager mailboxManager, StatusResponseFactory statusResponseFactory, boolean openReadOnly, MetricFactory metricFactory, EventBus eventBus) {
        super(acceptableClass, mailboxManager, statusResponseFactory, metricFactory);
        this.statusResponseFactory = statusResponseFactory;
        this.openReadOnly = openReadOnly;
        this.eventBus = eventBus;
    }

    @Override
    protected Mono<Void> processRequestReactive(R request, ImapSession session, ImapProcessor.Responder responder) {
        String mailboxName = ((AbstractMailboxSelectionRequest)request).getMailboxName();
        MailboxPath fullMailboxPath = PathConverter.forSession(session).buildFullPath(mailboxName);
        return this.respond(session, fullMailboxPath, (AbstractMailboxSelectionRequest)request, responder).onErrorResume(MailboxNotFoundException.class, e -> {
            responder.respond(this.statusResponseFactory.taggedNo(request.getTag(), request.getCommand(), HumanReadableText.FAILURE_NO_SUCH_MAILBOX));
            return ReactorUtils.logAsMono(() -> LOGGER.debug("Select failed as mailbox does not exist {}", (Object)mailboxName, e));
        }).onErrorResume(MailboxException.class, e -> {
            this.no((ImapRequest)request, responder, HumanReadableText.SELECT);
            return ReactorUtils.logAsMono(() -> LOGGER.error("Select failed for mailbox {}", (Object)mailboxName, (Object)e));
        });
    }

    private Mono<Void> respond(ImapSession session, MailboxPath fullMailboxPath, AbstractMailboxSelectionRequest request, ImapProcessor.Responder responder) {
        AbstractMailboxSelectionRequest.ClientSpecifiedUidValidity lastKnownUidValidity = request.getLastKnownUidValidity();
        IdRange[] knownSequences = request.getKnownSequenceSet();
        UidRange[] knownUids = request.getKnownUidSet();
        if (!lastKnownUidValidity.isUnknown() && !EnableProcessor.getEnabledCapabilities(session).contains(ImapConstants.SUPPORTS_QRESYNC)) {
            this.taggedBad(request, responder, HumanReadableText.QRESYNC_NOT_ENABLED);
            return Mono.empty();
        }
        return this.selectMailbox(fullMailboxPath, session, responder).doOnNext(metaData -> {
            SelectedMailbox selected = session.getSelected();
            this.mailboxId(responder, selected.getMailboxId());
            this.flags(responder, selected);
            this.exists(responder, (MessageManager.MailboxMetaData)metaData);
            this.recent(responder, selected);
            this.uidValidity(responder, (MessageManager.MailboxMetaData)metaData);
        }).flatMap(metadata -> this.firstUnseen(session, fullMailboxPath, responder, metadata.getFirstUnseen(), session.getSelected()).thenReturn(metadata)).doOnNext(metaData -> {
            SelectedMailbox selected = session.getSelected();
            this.permanentFlags(responder, metaData.getPermanentFlags(), selected);
            this.highestModSeq(responder, (MessageManager.MailboxMetaData)metaData);
            this.uidNext(responder, (MessageManager.MailboxMetaData)metaData);
            if (request.getCondstore()) {
                this.condstoreEnablingCommand(session, responder, (MessageManager.MailboxMetaData)metaData, false);
            }
            if (!lastKnownUidValidity.isUnknown()) {
                if (lastKnownUidValidity.correspondsTo(metaData.getUidValidity())) {
                    this.uidSet(request, (MessageManager.MailboxMetaData)metaData).ifPresent(Throwing.consumer(uidSet -> this.respondVanished(session, responder, knownSequences, knownUids, selected, (UidRange[])uidSet)).sneakyThrow());
                    this.taggedOk(responder, request, (MessageManager.MailboxMetaData)metaData, HumanReadableText.SELECT);
                } else {
                    this.taggedOk(responder, request, (MessageManager.MailboxMetaData)metaData, HumanReadableText.QRESYNC_UIDVALIDITY_MISMATCH);
                }
            } else {
                this.taggedOk(responder, request, (MessageManager.MailboxMetaData)metaData, HumanReadableText.SELECT);
            }
            SearchResUtil.resetSavedSequenceSet(session);
        }).then();
    }

    private Mono<MessageUid> firstUnseen(ImapSession session, MailboxPath fullMailboxPath, ImapProcessor.Responder responder, MessageUid firstUnseen, SelectedMailbox selected) {
        if (firstUnseen == null) {
            return Mono.empty();
        }
        return Flux.concat((Publisher[])new Publisher[]{Flux.just((Object)firstUnseen), Flux.range((int)0, (int)5).concatMap(i -> this.retrieveFirstUnseen(session, fullMailboxPath, responder))}).filter(unseenUid -> this.unseen(responder, firstUnseen, selected)).next().switchIfEmpty(Mono.fromCallable(() -> {
            LOGGER.info("Unable to uid for unseen message {} in mailbox {}", (Object)firstUnseen, (Object)selected.getMailboxId().serialize());
            return firstUnseen;
        }));
    }

    private Mono<MessageUid> retrieveFirstUnseen(ImapSession session, MailboxPath fullMailboxPath, ImapProcessor.Responder responder) {
        return this.selectMailbox(fullMailboxPath, session, responder).map(MessageManager.MailboxMetaData::getFirstUnseen);
    }

    private Optional<UidRange[]> uidSet(AbstractMailboxSelectionRequest request, MessageManager.MailboxMetaData metaData) {
        return Optional.ofNullable(request.getUidSet()).or(() -> {
            MessageUid uidNext = metaData.getUidNext();
            if (!uidNext.isFirst()) {
                return Optional.of(new UidRange[]{new UidRange(MessageUid.MIN_VALUE, uidNext.previous())});
            }
            return Optional.empty();
        });
    }

    private void respondVanished(ImapSession session, ImapProcessor.Responder responder, IdRange[] knownSequences, UidRange[] knownUids, SelectedMailbox selected, UidRange[] uidSet) {
        if (knownSequences != null && knownUids != null) {
            uidSet = this.recomputeUidSet(knownSequences, knownUids, selected, uidSet);
        }
        ArrayList<MessageRange> ranges = new ArrayList<MessageRange>();
        for (UidRange range : uidSet) {
            MessageRange messageSet = range.toMessageRange();
            if (messageSet == null) continue;
            MessageRange normalizedMessageSet = this.normalizeMessageRange(session.getSelected(), messageSet);
            ranges.add(normalizedMessageSet);
        }
        this.respondVanished(selected, ranges, responder);
    }

    @VisibleForTesting
    UidRange[] recomputeUidSet(IdRange[] knownSequences, UidRange[] knownUids, SelectedMailbox selected, UidRange[] uidSet) {
        int size = Math.min(knownSequences.length, knownUids.length);
        MessageUid firstKnownUid = IntStream.range(0, size).mapToObj(i -> Pair.of((Object)knownSequences[i], (Object)knownUids[i])).map(pair -> Pair.of((Object)((IdRange)pair.getLeft()).getLowVal(), (Object)((UidRange)pair.getRight()).getLowVal())).map(pair -> Tuple.of((Object)((Long)pair.getLeft()), (Object)((MessageUid)pair.getRight()), (Object)selected.uid(((Long)pair.getLeft()).intValue()).filter(selectedUid -> selectedUid.equals(pair.getRight())).isPresent())).takeWhile(t3 -> (Boolean)t3._3).map(t3 -> (MessageUid)t3._2).reduce((t3_1, t3_2) -> t3_2).orElse(MessageUid.MIN_VALUE);
        return this.filter(uidSet, firstKnownUid);
    }

    private UidRange[] filter(UidRange[] uidSet, MessageUid lowerBound) {
        return (UidRange[])Arrays.stream(uidSet).flatMap(range -> this.filter((UidRange)range, lowerBound)).toArray(UidRange[]::new);
    }

    private Stream<UidRange> filter(UidRange range, MessageUid lowerBound) {
        if (range.getLowVal().compareTo(lowerBound) < 0) {
            if (range.getHighVal().compareTo(lowerBound) > 0) {
                return Stream.of(new UidRange(lowerBound, range.getHighVal()));
            }
            return Stream.empty();
        }
        return Stream.of(range);
    }

    private void highestModSeq(ImapProcessor.Responder responder, MessageManager.MailboxMetaData metaData) {
        ModSeq highestModSeq = metaData.getHighestModSeq();
        StatusResponse untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.HIGHEST_MOD_SEQ, StatusResponse.ResponseCode.highestModSeq(highestModSeq));
        responder.respond(untaggedOk);
    }

    private void uidNext(ImapProcessor.Responder responder, MessageManager.MailboxMetaData metaData) {
        MessageUid uid = metaData.getUidNext();
        StatusResponse untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.UIDNEXT, StatusResponse.ResponseCode.uidNext(uid));
        responder.respond(untaggedOk);
    }

    private void taggedOk(ImapProcessor.Responder responder, ImapRequest request, MessageManager.MailboxMetaData metaData, HumanReadableText text) {
        boolean writeable = metaData.isWriteable() && !this.openReadOnly;
        StatusResponse.ResponseCode code = writeable ? StatusResponse.ResponseCode.readWrite() : StatusResponse.ResponseCode.readOnly();
        StatusResponse taggedOk = this.statusResponseFactory.taggedOk(request.getTag(), request.getCommand(), text, code);
        responder.respond(taggedOk);
    }

    private boolean unseen(ImapProcessor.Responder responder, MessageUid firstUnseen, SelectedMailbox selected) {
        if (firstUnseen != null) {
            MessageUid unseenUid = firstUnseen;
            return selected.msn(unseenUid).foldSilent(() -> {
                LOGGER.debug("No message found with uid {} in mailbox {}", (Object)unseenUid, (Object)selected.getMailboxId().serialize());
                return false;
            }, msn -> {
                StatusResponse untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.unseen(msn), StatusResponse.ResponseCode.unseen(msn));
                responder.respond(untaggedOk);
                return true;
            });
        }
        return true;
    }

    private void uidValidity(ImapProcessor.Responder responder, MessageManager.MailboxMetaData metaData) {
        UidValidity uidValidity = metaData.getUidValidity();
        StatusResponse untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.UID_VALIDITY, StatusResponse.ResponseCode.uidValidity(uidValidity));
        responder.respond(untaggedOk);
    }

    private void recent(ImapProcessor.Responder responder, SelectedMailbox selected) {
        int recentCount = selected.recentCount();
        RecentResponse recentResponse = new RecentResponse(recentCount);
        responder.respond(recentResponse);
    }

    private void exists(ImapProcessor.Responder responder, MessageManager.MailboxMetaData metaData) {
        long messageCount = metaData.getMessageCount();
        ExistsResponse existsResponse = new ExistsResponse(messageCount);
        responder.respond(existsResponse);
    }

    private void mailboxId(ImapProcessor.Responder responder, MailboxId mailboxId) {
        StatusResponse untaggedOk = this.statusResponseFactory.untaggedOk(HumanReadableText.OK, StatusResponse.ResponseCode.mailboxId(mailboxId));
        responder.respond(untaggedOk);
    }

    private Mono<MessageManager.MailboxMetaData> selectMailbox(MailboxPath mailboxPath, ImapSession session, ImapProcessor.Responder responder) {
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxSession mailboxSession = session.getMailboxSession();
        SelectedMailbox currentMailbox = session.getSelected();
        return Mono.from((Publisher)mailboxManager.getMailboxReactive(mailboxPath, mailboxSession)).flatMap((Function)Throwing.function(mailbox -> this.selectMailbox(session, responder, (MessageManager)mailbox, currentMailbox).flatMap((Function)Throwing.function(sessionMailbox -> mailbox.getMetaDataReactive(this.recentMode(!this.openReadOnly), mailboxSession, EnumSet.of(MessageManager.MailboxMetaData.Item.FirstUnseen, MessageManager.MailboxMetaData.Item.HighestModSeq, MessageManager.MailboxMetaData.Item.NextUid, MessageManager.MailboxMetaData.Item.MailboxCounters)).doOnNext(next -> this.addRecent((MessageManager.MailboxMetaData)next, (SelectedMailbox)sessionMailbox))))));
    }

    private MessageManager.MailboxMetaData.RecentMode recentMode(boolean reset) {
        if (reset) {
            return MessageManager.MailboxMetaData.RecentMode.RESET;
        }
        return MessageManager.MailboxMetaData.RecentMode.RETRIEVE;
    }

    private Mono<SelectedMailbox> selectMailbox(ImapSession session, ImapProcessor.Responder responder, MessageManager mailbox, SelectedMailbox currentMailbox) throws MailboxException {
        if (currentMailbox == null || !currentMailbox.getMailboxId().equals(mailbox.getId())) {
            if (currentMailbox != null && EnableProcessor.getEnabledCapabilities(session).contains(ImapConstants.SUPPORTS_QRESYNC)) {
                responder.respond(this.getStatusResponseFactory().untaggedOk(HumanReadableText.QRESYNC_CLOSED, StatusResponse.ResponseCode.closed()));
            }
            SelectedMailboxImpl selectedMailbox = new SelectedMailboxImpl(this.getMailboxManager(), this.eventBus, session, mailbox);
            return session.selected(selectedMailbox).then(selectedMailbox.finishInit()).thenReturn((Object)selectedMailbox);
        }
        return Mono.just((Object)currentMailbox);
    }

    private void addRecent(MessageManager.MailboxMetaData metaData, SelectedMailbox sessionMailbox) {
        List recentUids = metaData.getRecent();
        for (MessageUid uid : recentUids) {
            sessionMailbox.addRecent(uid);
        }
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    public List<Capability> getPermitEnableCapabilities(ImapSession session) {
        return CAPS;
    }

    @Override
    public Mono<Void> enable(ImapMessage message, ImapProcessor.Responder responder, ImapSession session, Capability capability) {
        if (!EnableProcessor.getEnabledCapabilities(session).contains(capability)) {
            SelectedMailbox sm = session.getSelected();
            if (capability.equals(ImapConstants.SUPPORTS_CONDSTORE) || capability.equals(ImapConstants.SUPPORTS_QRESYNC)) {
                if (sm != null) {
                    boolean send = true;
                    return this.getSelectedMailboxReactive(session, (Mono<MessageManager>)Mono.error(() -> new PermitEnableCapabilityProcessor.EnableException("Unable to enable " + capability.asString(), new MailboxException("Session not in SELECTED state")))).flatMap((Function)Throwing.function(mailbox -> mailbox.getMetaDataReactive(MessageManager.MailboxMetaData.RecentMode.IGNORE, session.getMailboxSession(), EnumSet.of(MessageManager.MailboxMetaData.Item.HighestModSeq)))).doOnNext(metaData -> this.condstoreEnablingCommand(session, responder, (MessageManager.MailboxMetaData)metaData, send)).then();
                }
                boolean send = false;
                MessageManager.MailboxMetaData metaData2 = null;
                return Mono.fromRunnable(() -> this.condstoreEnablingCommand(session, responder, metaData2, send));
            }
        }
        return Mono.empty();
    }
}

