/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.lucene.search;

import java.io.Reader;
import org.apache.james.mailbox.lucene.search.UpperCaseFilter;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cn.smart.SentenceTokenizer;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;

public final class StrictImapSearchAnalyzer
extends Analyzer {
    private final int minTokenLength;
    private final int maxTokenLength;

    public StrictImapSearchAnalyzer() {
        this(3, 40);
    }

    public StrictImapSearchAnalyzer(int minTokenLength, int maxTokenLength) {
        this.minTokenLength = minTokenLength;
        this.maxTokenLength = maxTokenLength;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return new NGramTokenFilter((TokenStream)new UpperCaseFilter((TokenStream)new SentenceTokenizer(reader)), this.minTokenLength, this.maxTokenLength);
    }
}

