/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.base;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapCommandParser;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImapCommandParser
implements ImapCommandParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractImapCommandParser.class);
    private final ImapCommand command;
    private final StatusResponseFactory statusResponseFactory;

    public AbstractImapCommandParser(ImapCommand command, StatusResponseFactory statusResponseFactory) {
        this.command = command;
        this.statusResponseFactory = statusResponseFactory;
    }

    public ImapCommand getCommand() {
        return this.command;
    }

    protected StatusResponse taggedNo(Tag tag, ImapCommand command, HumanReadableText displayTextKey, StatusResponse.ResponseCode code) {
        return this.statusResponseFactory.taggedNo(tag, command, displayTextKey, code);
    }

    @Override
    public final ImapMessage parse(ImapRequestLineReader request, Tag tag, ImapSession session) {
        if (this.command.validForState(session.getState())) {
            try {
                return this.decode(request, tag, session);
            }
            catch (DecodingException e) {
                LOGGER.debug("Cannot parse protocol ", (Throwable)e);
                return this.statusResponseFactory.taggedBad(tag, this.command, e.getKey());
            }
        }
        return this.statusResponseFactory.taggedNo(tag, this.command, HumanReadableText.INVALID_COMMAND);
    }

    protected abstract ImapMessage decode(ImapRequestLineReader var1, Tag var2, ImapSession var3) throws DecodingException;
}

