/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class MDCBuilder {
    public static final String HOST = "host";
    public static final String IP = "ip";
    public static final String PROTOCOL = "protocol";
    public static final String USER = "user";
    public static final String ACTION = "action";
    public static final String SESSION_ID = "sessionId";
    public static final String CHARSET = "charset";
    private static final Logger LOGGER = LoggerFactory.getLogger(MDCBuilder.class);
    private final ImmutableMap.Builder<String, String> contextMap = ImmutableMap.builder();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T withMdc(MDCBuilder mdcBuilder, Supplier<T> answerSupplier) {
        try (Closeable closeable = mdcBuilder.build();){
            T t = answerSupplier.get();
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            LOGGER.error("Got error, logging its context", (Throwable)e);
            throw e;
        }
    }

    public static void withMdc(MDCBuilder mdcBuilder, VoidOperation logOperation) {
        MDCBuilder.withMdc(mdcBuilder, () -> {
            logOperation.perform();
            return null;
        });
    }

    public static MDCBuilder create() {
        return new MDCBuilder();
    }

    @Deprecated
    public static MDCBuilder of(String key, Object value) {
        return MDCBuilder.create().addContext(key, value);
    }

    public static MDCBuilder ofValue(String key, String value) {
        return MDCBuilder.create().addToContext(key, value);
    }

    private MDCBuilder() {
    }

    @Deprecated
    public MDCBuilder addContext(MDCBuilder nested) {
        this.contextMap.putAll((Map)nested.contextMap.build());
        return this;
    }

    @Deprecated
    public MDCBuilder addContext(String key, Object value) {
        Preconditions.checkNotNull((Object)key);
        Optional.ofNullable(value).ifPresent(nonNullValue -> this.contextMap.put((Object)key, (Object)nonNullValue.toString()));
        return this;
    }

    public MDCBuilder addToContext(MDCBuilder nested) {
        this.contextMap.putAll((Map)nested.contextMap.build());
        return this;
    }

    public MDCBuilder addToContextIfPresent(String key, Optional<String> value) {
        Preconditions.checkNotNull((Object)key);
        value.ifPresent(nonNullValue -> this.contextMap.put((Object)key, nonNullValue));
        return this;
    }

    public MDCBuilder addToContext(String key, String value) {
        Preconditions.checkNotNull((Object)key);
        Optional.ofNullable(value).ifPresent(nonNullValue -> this.contextMap.put((Object)key, nonNullValue));
        return this;
    }

    @VisibleForTesting
    Map<String, String> buildContextMap() {
        return this.contextMap.build();
    }

    public <T> T execute(Supplier<T> supplier) {
        return MDCBuilder.withMdc(this, supplier);
    }

    public <T> Supplier<T> wrapArround(Supplier<T> supplier) {
        return () -> this.execute(supplier);
    }

    public Closeable build() {
        Map<String, String> contextMap = this.buildContextMap();
        contextMap.forEach(MDC::put);
        return () -> contextMap.keySet().forEach(MDC::remove);
    }

    public MDCBuilder duplicate() {
        return MDCBuilder.create().addToContext(this);
    }

    public static interface VoidOperation {
        public void perform();
    }
}

