/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch.json;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mailbox.opensearch.json.MimePart;
import org.apache.james.mailbox.opensearch.json.MimePartContainerBuilder;
import org.apache.james.mime4j.stream.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootMimePartContainerBuilder
implements MimePartContainerBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RootMimePartContainerBuilder.class);
    private MimePart.ParsedMimePart rootMimePart;

    @Override
    public MimePart.ParsedMimePart build() {
        return this.rootMimePart;
    }

    @Override
    public MimePartContainerBuilder addToHeaders(Field field) {
        LOGGER.warn("Trying to add headers to the Root MimePart container");
        return this;
    }

    @Override
    public MimePartContainerBuilder addBodyContent(InputStream bodyContent) {
        LOGGER.warn("Trying to add body content to the Root MimePart container");
        return this;
    }

    @Override
    public MimePartContainerBuilder addChild(MimePart.ParsedMimePart mimePart) {
        if (this.rootMimePart == null) {
            this.rootMimePart = mimePart;
        } else {
            LOGGER.warn("Trying to add several children to the Root MimePart container");
        }
        return this;
    }

    @Override
    public MimePartContainerBuilder addFileName(String fileName) {
        LOGGER.warn("Trying to add fineName to the Root MimePart container");
        return this;
    }

    @Override
    public MimePartContainerBuilder addMediaType(ContentType.MediaType mediaType) {
        LOGGER.warn("Trying to add media type to the Root MimePart container");
        return this;
    }

    @Override
    public MimePartContainerBuilder addSubType(ContentType.SubType subType) {
        LOGGER.warn("Trying to add sub type to the Root MimePart container");
        return this;
    }

    @Override
    public MimePartContainerBuilder addContentDisposition(String contentDisposition) {
        LOGGER.warn("Trying to add content disposition to the Root MimePart container");
        return this;
    }

    @Override
    public MimePartContainerBuilder charset(Charset charset) {
        LOGGER.warn("Trying to add content charset to the Root MimePart container");
        return this;
    }
}

