/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import java.io.Serializable;
import org.apache.james.jmap.api.exception.ChangeNotFoundException;
import org.apache.james.jmap.core.ErrorCode$AccountNotFound$;
import org.apache.james.jmap.core.ErrorCode$CannotCalculateChanges$;
import org.apache.james.jmap.core.ErrorCode$Forbidden$;
import org.apache.james.jmap.core.ErrorCode$InvalidArguments$;
import org.apache.james.jmap.core.ErrorCode$RequestTooLarge$;
import org.apache.james.jmap.core.ErrorCode$UnsupportedFilter$;
import org.apache.james.jmap.core.ErrorCode$UnsupportedSort$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.SessionTranslator;
import org.apache.james.jmap.delegation.ForbiddenAccountManagementException;
import org.apache.james.jmap.mail.IdentityIdNotFoundException;
import org.apache.james.jmap.mail.RequestTooLargeException;
import org.apache.james.jmap.mail.UnsupportedFilterException;
import org.apache.james.jmap.mail.UnsupportedNestingException;
import org.apache.james.jmap.mail.UnsupportedRequestParameterException;
import org.apache.james.jmap.mail.UnsupportedSortException;
import org.apache.james.jmap.method.AccountNotFoundException;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.WithAccountId;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005=ba\u0002\u0005\n!\u0003\r\t\u0001\u0006\u0005\u0006A\u0001!\t!\t\u0005\u0006K\u00011\tA\n\u0005\u0006_\u00011\t\u0001\r\u0005\u0006o\u00011\t\u0001\u000f\u0005\u0006\u007f\u0001!\t\u0005\u0011\u0005\u0006e\u00021\ta\u001d\u0005\b\u0003\u0013\u0001a\u0011AA\u0006\u0005aiU\r\u001e5pIJ+\u0017/^5sS:<\u0017iY2pk:$\u0018\n\u001a\u0006\u0003\u0015-\ta!\\3uQ>$'B\u0001\u0007\u000e\u0003\u0011QW.\u00199\u000b\u00059y\u0011!\u00026b[\u0016\u001c(B\u0001\t\u0012\u0003\u0019\t\u0007/Y2iK*\t!#A\u0002pe\u001e\u001c\u0001!\u0006\u0002\u0016wN\u0019\u0001A\u0006\u000f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g!\tib$D\u0001\n\u0013\ty\u0012B\u0001\u0004NKRDw\u000eZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003\t\u0002\"aF\u0012\n\u0005\u0011B\"\u0001B+oSR\fQ\"\\3ue&\u001cg)Y2u_JLX#A\u0014\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013aA1qS*\u0011A&D\u0001\b[\u0016$(/[2t\u0013\tq\u0013FA\u0007NKR\u0014\u0018n\u0019$bGR|'/_\u0001\u0010g\u0016\u001c8/[8o'V\u0004\b\u000f\\5feV\t\u0011\u0007\u0005\u00023k5\t1G\u0003\u00025\u0017\u00051!o\\;uKNL!AN\u001a\u0003\u001fM+7o]5p]N+\b\u000f\u001d7jKJ\f\u0011c]3tg&|g\u000e\u0016:b]Nd\u0017\r^8s+\u0005I\u0004C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\f\u0003\u0011\u0019wN]3\n\u0005yZ$!E*fgNLwN\u001c+sC:\u001cH.\u0019;pe\u00069\u0001O]8dKN\u001cH\u0003B!KQ*\u00042AQ#H\u001b\u0005\u0019%B\u0001#\u0012\u0003=\u0011X-Y2uSZ,7\u000f\u001e:fC6\u001c\u0018B\u0001$D\u0005%\u0001VO\u00197jg\",'\u000f\u0005\u0002\u001e\u0011&\u0011\u0011*\u0003\u0002\u0016\u0013:4xnY1uS>tw+\u001b;i\u0007>tG/\u001a=u\u0011\u0015YU\u00011\u0001M\u00031\u0019\u0017\r]1cS2LG/[3t!\riEk\u0016\b\u0003\u001dJ\u0003\"a\u0014\r\u000e\u0003AS!!U\n\u0002\rq\u0012xn\u001c;?\u0013\t\u0019\u0006$\u0001\u0004Qe\u0016$WMZ\u0005\u0003+Z\u00131aU3u\u0015\t\u0019\u0006\u0004\u0005\u0002YK:\u0011\u0011l\u0019\b\u00035\nt!aW1\u000f\u0005q\u0003gBA/`\u001d\tye,C\u0001\u0013\u0013\t\u0001\u0012#\u0003\u0002\u000f\u001f%\u0011A\"D\u0005\u0003y-I!\u0001Z\u001e\u0002)\r\u000b\u0007/\u00192jY&$\u00180\u00133f]RLg-[3s\u0013\t1wM\u0001\u000bDCB\f'-\u001b7jifLE-\u001a8uS\u001aLWM\u001d\u0006\u0003InBQ![\u0003A\u0002\u001d\u000b!\"\u001b8w_\u000e\fG/[8o\u0011\u0015YW\u00011\u0001m\u00039i\u0017-\u001b7c_b\u001cVm]:j_:\u0004\"!\u001c9\u000e\u00039T!a\\\u0007\u0002\u000f5\f\u0017\u000e\u001c2pq&\u0011\u0011O\u001c\u0002\u000f\u001b\u0006LGNY8y'\u0016\u001c8/[8o\u0003%!w\u000e\u0015:pG\u0016\u001c8\u000fF\u0003BiV4x\u000fC\u0003L\r\u0001\u0007A\nC\u0003j\r\u0001\u0007q\tC\u0003l\r\u0001\u0007A\u000eC\u0003y\r\u0001\u0007\u00110A\u0004sKF,Xm\u001d;\u0011\u0005i\\H\u0002\u0001\u0003\u0006y\u0002\u0011\r! \u0002\b%\u0016\u000bV+R*U#\rq\u00181\u0001\t\u0003/}L1!!\u0001\u0019\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!HA\u0003\u0013\r\t9!\u0003\u0002\u000e/&$\b.Q2d_VtG/\u00133\u0002\u0015\u001d,GOU3rk\u0016\u001cH\u000f\u0006\u0004\u0002\u000e\u0005\u0015\u0012q\u0005\t\b\u0003\u001f\tI\"a\bz\u001d\u0011\t\t\"!\u0006\u000f\u0007=\u000b\u0019\"C\u0001\u001a\u0013\r\t9\u0002G\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY\"!\b\u0003\r\u0015KG\u000f[3s\u0015\r\t9\u0002\u0007\t\u0005\u0003\u001f\t\t#\u0003\u0003\u0002$\u0005u!!C#yG\u0016\u0004H/[8o\u0011\u0015Yw\u00011\u0001m\u0011\u0019Iw\u00011\u0001\u0002*A\u0019!(a\u000b\n\u0007\u000552H\u0001\u0006J]Z|7-\u0019;j_:\u0004")
public interface MethodRequiringAccountId<REQUEST extends WithAccountId>
extends Method {
    public MetricFactory metricFactory();

    public SessionSupplier sessionSupplier();

    public SessionTranslator sessionTranslator();

    public static /* synthetic */ Publisher process$(MethodRequiringAccountId $this, Set capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return $this.process((Set<Refined<String, string.Uri>>)capabilities, invocation, mailboxSession);
    }

    @Override
    default public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        Either either = this.getRequest(mailboxSession, invocation.invocation()).map((Function1 & Serializable)request -> {
            SMono<MailboxSession> translatedMailboxSession = this.sessionTranslator().delegateIfNeeded(mailboxSession, request.accountId());
            return new Tuple2(request, translatedMailboxSession);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                WithAccountId request = (WithAccountId)tuple2._1();
                SMono translatedMailboxSession = (SMono)tuple2._2();
                return translatedMailboxSession.flatMapMany((Function1 & Serializable)translatedSession -> SFlux$.MODULE$.apply(this.doProcess(capabilities, invocation, (MailboxSession)translatedSession, (Object)request)));
            }
            throw new MatchError((Object)tuple2);
        });
        SFlux result = SFlux$.MODULE$.fromPublisher((Publisher)either.fold((Function1 & Serializable)e -> SFlux$.MODULE$.error((Throwable)e, SFlux$.MODULE$.error$default$2()), (Function1 & Serializable)r -> r)).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof AccountNotFoundException) {
                return SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$AccountNotFound$.MODULE$, invocation.invocation().methodCallId()), invocation.processingContext())}));
            }
            if (throwable instanceof ForbiddenAccountManagementException) {
                return SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$Forbidden$.MODULE$, "Access to other accounts settings is forbidden", invocation.invocation().methodCallId()), invocation.processingContext())}));
            }
            if (throwable instanceof UnsupportedRequestParameterException) {
                UnsupportedRequestParameterException unsupportedRequestParameterException = (UnsupportedRequestParameterException)throwable;
                return SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, new StringBuilder(84).append("The following parameter ").append(unsupportedRequestParameterException.unsupportedParam()).append(" is syntactically valid, but is not supported by the server.").toString(), invocation.invocation().methodCallId()), invocation.processingContext())}));
            }
            if (throwable instanceof UnsupportedSortException) {
                UnsupportedSortException unsupportedSortException = (UnsupportedSortException)throwable;
                return SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$UnsupportedSort$.MODULE$, new StringBuilder(144).append("The sort ").append(unsupportedSortException.unsupportedSort()).append(" is syntactically valid, but it includes a property the server does not support sorting on or a collation method it does not recognise.").toString(), invocation.invocation().methodCallId()), invocation.processingContext())}));
            }
            if (throwable instanceof UnsupportedFilterException) {
                UnsupportedFilterException unsupportedFilterException = (UnsupportedFilterException)throwable;
                return SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$UnsupportedFilter$.MODULE$, new StringBuilder(187).append("The filter ").append(unsupportedFilterException.unsupportedFilter()).append(" is syntactically valid, but the server cannot process it. If the filter was the result of a user\u2019s search input, the client SHOULD suggest that the user simplify their search.").toString(), invocation.invocation().methodCallId()), invocation.processingContext())}));
            }
            if (throwable instanceof UnsupportedNestingException) {
                UnsupportedNestingException unsupportedNestingException = (UnsupportedNestingException)throwable;
                return SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$UnsupportedFilter$.MODULE$, unsupportedNestingException.message(), invocation.invocation().methodCallId()), invocation.processingContext())}));
            }
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                return SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, illegalArgumentException.getMessage(), invocation.invocation().methodCallId()), invocation.processingContext())}));
            }
            if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                return SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, mailboxNotFoundException.getMessage(), invocation.invocation().methodCallId()), invocation.processingContext())}));
            }
            if (throwable instanceof ChangeNotFoundException) {
                ChangeNotFoundException changeNotFoundException = (ChangeNotFoundException)throwable;
                return SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$CannotCalculateChanges$.MODULE$, changeNotFoundException.getMessage(), invocation.invocation().methodCallId()), invocation.processingContext())}));
            }
            if (throwable instanceof RequestTooLargeException) {
                RequestTooLargeException requestTooLargeException = (RequestTooLargeException)throwable;
                return SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$RequestTooLarge$.MODULE$, requestTooLargeException.description(), invocation.invocation().methodCallId()), invocation.processingContext())}));
            }
            if (throwable instanceof IdentityIdNotFoundException) {
                IdentityIdNotFoundException identityIdNotFoundException = (IdentityIdNotFoundException)throwable;
                return SFlux$.MODULE$.just((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InvocationWithContext[]{new InvocationWithContext(Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, identityIdNotFoundException.description(), invocation.invocation().methodCallId()), invocation.processingContext())}));
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                return SFlux$.MODULE$.error(throwable2, SFlux$.MODULE$.error$default$2());
            }
            throw new MatchError((Object)throwable);
        });
        return this.metricFactory().decoratePublisherWithTimerMetric(new StringBuilder(0).append(this.JMAP_RFC8621_PREFIX()).append(new Refined((Object)this.methodName().value())).toString(), (Publisher)result);
    }

    public Publisher<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> var1, InvocationWithContext var2, MailboxSession var3, REQUEST var4);

    public Either<Exception, REQUEST> getRequest(MailboxSession var1, Invocation var2);

    public static void $init$(MethodRequiringAccountId $this) {
    }
}

