/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import eu.timepit.refined.api.Refined;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.mail.Email$;
import org.apache.james.jmap.mail.EmailFastViewReader;
import org.apache.james.jmap.mail.EmailFastViewWithAttachmentsMetadataReader;
import org.apache.james.jmap.mail.EmailFullViewReader;
import org.apache.james.jmap.mail.EmailGetRequest;
import org.apache.james.jmap.mail.EmailHeaderViewReader;
import org.apache.james.jmap.mail.EmailMetadataViewReader;
import org.apache.james.jmap.mail.EmailView;
import org.apache.james.jmap.mail.EmailViewReader;
import org.apache.james.jmap.mail.FastViewReadLevel$;
import org.apache.james.jmap.mail.FastViewWithAttachmentsMetadataReadLevel$;
import org.apache.james.jmap.mail.FullReadLevel$;
import org.apache.james.jmap.mail.HeaderReadLevel$;
import org.apache.james.jmap.mail.MetadataReadLevel$;
import org.apache.james.jmap.mail.ReadLevel;
import org.apache.james.jmap.mail.ReadLevel$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.collection.IterableOnceOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000593A\u0001C\u0005\u0001)!A1\u0004\u0001B\u0001B\u0003%A\u0004\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\"\u0011!!\u0003A!A!\u0002\u0013)\u0003\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\t\u00111\u0002!\u0011!Q\u0001\n5BQ\u0001\r\u0001\u0005\u0002EBQ!\u0011\u0001\u0005\u0002\t\u0013a#R7bS24\u0016.Z<SK\u0006$WM\u001d$bGR|'/\u001f\u0006\u0003\u0015-\tA!\\1jY*\u0011A\"D\u0001\u0005U6\f\u0007O\u0003\u0002\u000f\u001f\u0005)!.Y7fg*\u0011\u0001#E\u0001\u0007CB\f7\r[3\u000b\u0003I\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g\u00039iW\r^1eCR\f'+Z1eKJ\u0004\"!\b\u0010\u000e\u0003%I!aH\u0005\u0003/\u0015k\u0017-\u001b7NKR\fG-\u0019;b-&,wOU3bI\u0016\u0014\u0018\u0001\u00045fC\u0012,'OU3bI\u0016\u0014\bCA\u000f#\u0013\t\u0019\u0013BA\u000bF[\u0006LG\u000eS3bI\u0016\u0014h+[3x%\u0016\fG-\u001a:\u0002\u001d\u0019\f7\u000f\u001e,jK^\u0014V-\u00193feB\u0011QDJ\u0005\u0003O%\u00111#R7bS24\u0015m\u001d;WS\u0016<(+Z1eKJ\fQEZ1tiZKWm^,ji\"\fE\u000f^1dQ6,g\u000e^:NKR\fG-\u0019;b%\u0016\fG-\u001a:\u0011\u0005uQ\u0013BA\u0016\n\u0005)*U.Y5m\r\u0006\u001cHOV5fo^KG\u000f[!ui\u0006\u001c\u0007.\\3oiNlU\r^1eCR\f'+Z1eKJ\f!BZ;mYJ+\u0017\rZ3s!\tib&\u0003\u00020\u0013\t\u0019R)\\1jY\u001a+H\u000e\u001c,jK^\u0014V-\u00193fe\u00061A(\u001b8jiz\"bAM\u001a5kY:\u0004CA\u000f\u0001\u0011\u0015Yb\u00011\u0001\u001d\u0011\u0015\u0001c\u00011\u0001\"\u0011\u0015!c\u00011\u0001&\u0011\u0015Ac\u00011\u0001*\u0011\u0015ac\u00011\u0001.Q\t1\u0011\b\u0005\u0002;\u007f5\t1H\u0003\u0002={\u00051\u0011N\u001c6fGRT\u0011AP\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u0001n\u0012a!\u00138kK\u000e$\u0018\u0001D:fY\u0016\u001cGOU3bI\u0016\u0014HCA\"J!\riBIR\u0005\u0003\u000b&\u0011q\"R7bS24\u0016.Z<SK\u0006$WM\u001d\t\u0003;\u001dK!\u0001S\u0005\u0003\u0013\u0015k\u0017-\u001b7WS\u0016<\b\"\u0002&\b\u0001\u0004Y\u0015a\u0002:fcV,7\u000f\u001e\t\u0003;1K!!T\u0005\u0003\u001f\u0015k\u0017-\u001b7HKR\u0014V-];fgR\u0004")
public class EmailViewReaderFactory {
    private final EmailMetadataViewReader metadataReader;
    private final EmailHeaderViewReader headerReader;
    private final EmailFastViewReader fastViewReader;
    private final EmailFastViewWithAttachmentsMetadataReader fastViewWithAttachmentsMetadataReader;
    private final EmailFullViewReader fullReader;

    public EmailViewReader<EmailView> selectReader(EmailGetRequest request) {
        ReadLevel readLevel = (ReadLevel)((IterableOnceOps)((Properties)request.properties().getOrElse((Function0 & Serializable)() -> Email$.MODULE$.defaultProperties())).value().map((Function1 & Serializable)property -> ReadLevel$.MODULE$.of((String)((Refined)property).value()))).reduceOption((Function2 & Serializable)(readLevel1, readLevel2) -> ReadLevel$.MODULE$.combine((ReadLevel)readLevel1, (ReadLevel)readLevel2)).getOrElse((Function0 & Serializable)() -> MetadataReadLevel$.MODULE$);
        ReadLevel readLevel3 = readLevel;
        if (MetadataReadLevel$.MODULE$.equals(readLevel3)) {
            return this.metadataReader;
        }
        if (HeaderReadLevel$.MODULE$.equals(readLevel3)) {
            return this.headerReader;
        }
        if (FastViewReadLevel$.MODULE$.equals(readLevel3)) {
            return this.fastViewReader;
        }
        if (FastViewWithAttachmentsMetadataReadLevel$.MODULE$.equals(readLevel3)) {
            if (FastViewWithAttachmentsMetadataReadLevel$.MODULE$.supportedByFastViewWithAttachments(request.bodyProperties())) {
                return this.fastViewWithAttachmentsMetadataReader;
            }
            return this.fullReader;
        }
        if (FullReadLevel$.MODULE$.equals(readLevel3)) {
            return this.fullReader;
        }
        throw new MatchError((Object)readLevel3);
    }

    @Inject
    public EmailViewReaderFactory(EmailMetadataViewReader metadataReader, EmailHeaderViewReader headerReader, EmailFastViewReader fastViewReader, EmailFastViewWithAttachmentsMetadataReader fastViewWithAttachmentsMetadataReader, EmailFullViewReader fullReader) {
        this.metadataReader = metadataReader;
        this.headerReader = headerReader;
        this.fastViewReader = fastViewReader;
        this.fastViewWithAttachmentsMetadataReader = fastViewWithAttachmentsMetadataReader;
        this.fullReader = fullReader;
    }
}

