/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class IndicesVersions
implements JsonpSerializable {
    private final int indexCount;
    private final int primaryShardCount;
    private final long totalPrimaryBytes;
    private final String version;
    public static final JsonpDeserializer<IndicesVersions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicesVersions::setupIndicesVersionsDeserializer);

    private IndicesVersions(Builder builder) {
        this.indexCount = ApiTypeHelper.requireNonNull(builder.indexCount, this, "indexCount");
        this.primaryShardCount = ApiTypeHelper.requireNonNull(builder.primaryShardCount, this, "primaryShardCount");
        this.totalPrimaryBytes = ApiTypeHelper.requireNonNull(builder.totalPrimaryBytes, this, "totalPrimaryBytes");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
    }

    public static IndicesVersions of(Function<Builder, ObjectBuilder<IndicesVersions>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int indexCount() {
        return this.indexCount;
    }

    public final int primaryShardCount() {
        return this.primaryShardCount;
    }

    public final long totalPrimaryBytes() {
        return this.totalPrimaryBytes;
    }

    public final String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index_count");
        generator.write(this.indexCount);
        generator.writeKey("primary_shard_count");
        generator.write(this.primaryShardCount);
        generator.writeKey("total_primary_bytes");
        generator.write(this.totalPrimaryBytes);
        generator.writeKey("version");
        generator.write(this.version);
    }

    protected static void setupIndicesVersionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexCount, JsonpDeserializer.integerDeserializer(), "index_count");
        op.add(Builder::primaryShardCount, JsonpDeserializer.integerDeserializer(), "primary_shard_count");
        op.add(Builder::totalPrimaryBytes, JsonpDeserializer.longDeserializer(), "total_primary_bytes");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndicesVersions> {
        private Integer indexCount;
        private Integer primaryShardCount;
        private Long totalPrimaryBytes;
        private String version;

        public final Builder indexCount(int value) {
            this.indexCount = value;
            return this;
        }

        public final Builder primaryShardCount(int value) {
            this.primaryShardCount = value;
            return this;
        }

        public final Builder totalPrimaryBytes(long value) {
            this.totalPrimaryBytes = value;
            return this;
        }

        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        @Override
        public IndicesVersions build() {
            this._checkSingleUse();
            return new IndicesVersions(this);
        }
    }
}

