/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.james.imap.api.process.ImapLineHandler;
import org.apache.james.imap.api.process.ImapSession;

@ChannelHandler.Sharable
public class ImapLineHandlerAdapter
extends ChannelInboundHandlerAdapter {
    private final ImapLineHandler lineHandler;
    private final ImapSession session;

    public ImapLineHandlerAdapter(ImapSession session, ImapLineHandler lineHandler) {
        this.lineHandler = lineHandler;
        this.session = session;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf buf = (ByteBuf)msg;
        byte[] data = new byte[buf.readableBytes()];
        buf.readBytes(data);
        this.lineHandler.onLine(this.session, data);
        ctx.channel().flush();
    }
}

