/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.task.Task;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.dto.MailboxResponse;
import org.apache.james.webadmin.service.ClearMailboxContentTask;
import org.apache.james.webadmin.utils.MailboxHaveChildrenException;
import org.apache.james.webadmin.validation.MailboxName;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class UserMailboxesService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserMailboxesService.class);
    private final MailboxManager mailboxManager;
    private final UsersRepository usersRepository;

    @Inject
    public UserMailboxesService(MailboxManager mailboxManager, UsersRepository usersRepository) {
        this.mailboxManager = mailboxManager;
        this.usersRepository = usersRepository;
    }

    public void createMailbox(Username username, MailboxName mailboxName, Options options) throws MailboxException, UsersRepositoryException {
        this.usernamePreconditions(username, options);
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        try {
            MailboxPath mailboxPath = MailboxPath.forUser((Username)username, (String)mailboxName.asString()).assertAcceptable(mailboxSession.getPathDelimiter());
            this.mailboxManager.createMailbox(mailboxPath, mailboxSession);
            this.mailboxManager.endProcessingRequest(mailboxSession);
        }
        catch (MailboxExistsException e) {
            LOGGER.info("Attempt to create mailbox {} for user {} that already exists", (Object)mailboxName, (Object)username);
        }
    }

    public void deleteMailboxes(Username username, Options options) throws UsersRepositoryException {
        this.usernamePreconditions(username, options);
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        this.listUserMailboxes(mailboxSession).map(MailboxMetaData::getPath).forEach((Consumer<MailboxPath>)Throwing.consumer(mailboxPath -> this.deleteMailbox(mailboxSession, (MailboxPath)mailboxPath)));
        this.mailboxManager.endProcessingRequest(mailboxSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MailboxResponse> listMailboxes(Username username, Options options) throws UsersRepositoryException {
        this.usernamePreconditions(username, options);
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        try {
            List list = (List)this.listUserMailboxes(mailboxSession).map(mailboxMetaData -> new MailboxResponse(mailboxMetaData.getPath().getName(), mailboxMetaData.getId())).collect(ImmutableList.toImmutableList());
            return list;
        }
        finally {
            this.mailboxManager.endProcessingRequest(mailboxSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testMailboxExists(Username username, MailboxName mailboxName, Options options) throws MailboxException, UsersRepositoryException {
        this.usernamePreconditions(username, options);
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        MailboxPath mailboxPath = MailboxPath.forUser((Username)username, (String)mailboxName.asString()).assertAcceptable(mailboxSession.getPathDelimiter());
        try {
            boolean bl = (Boolean)Mono.from((Publisher)this.mailboxManager.mailboxExists(mailboxPath, mailboxSession)).block();
            return bl;
        }
        finally {
            this.mailboxManager.endProcessingRequest(mailboxSession);
        }
    }

    public Mono<Task.Result> clearMailboxContent(Username username, MailboxName mailboxName, ClearMailboxContentTask.Context context) {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        return Mono.from((Publisher)this.mailboxManager.getMailboxReactive(MailboxPath.forUser((Username)username, (String)mailboxName.asString()), mailboxSession)).flatMapMany(messageManager -> Flux.from((Publisher)messageManager.listMessagesMetadata(MessageRange.all(), mailboxSession)).map(metaData -> metaData.getComposedMessageId().getUid()).concatMap(messageUid -> this.deleteMessage((MessageManager)messageManager, (MessageUid)messageUid, mailboxSession, context))).onErrorResume(e -> {
            LOGGER.error("Error when clear mailbox content. Mailbox {} for user {}", new Object[]{mailboxName.asString(), username, e});
            context.incrementMessageFails();
            return Mono.just((Object)Task.Result.PARTIAL);
        }).reduce(Task::combine).switchIfEmpty(Mono.just((Object)Task.Result.COMPLETED)).doFinally(any -> this.mailboxManager.endProcessingRequest(mailboxSession));
    }

    private Mono<Task.Result> deleteMessage(MessageManager messageManager, MessageUid messageUid, MailboxSession mailboxSession, ClearMailboxContentTask.Context context) {
        return Mono.from((Publisher)messageManager.deleteReactive(List.of(messageUid), mailboxSession)).thenReturn((Object)Task.Result.COMPLETED).doOnNext(next -> context.incrementSuccesses()).onErrorResume(e -> {
            context.incrementMessageFails();
            return Mono.just((Object)Task.Result.PARTIAL);
        });
    }

    public void deleteMailbox(Username username, MailboxName mailboxName, Options options) throws MailboxException, UsersRepositoryException, MailboxHaveChildrenException {
        this.usernamePreconditions(username, options);
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        MailboxPath mailboxPath = MailboxPath.forUser((Username)username, (String)mailboxName.asString()).assertAcceptable(mailboxSession.getPathDelimiter());
        this.listChildren(mailboxPath, mailboxSession).forEach((Consumer<MailboxPath>)Throwing.consumer(path -> this.deleteMailbox(mailboxSession, (MailboxPath)path)));
        this.mailboxManager.endProcessingRequest(mailboxSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long messageCount(Username username, MailboxName mailboxName, Options options) throws UsersRepositoryException, MailboxException {
        this.usernamePreconditions(username, options);
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        try {
            long l = this.mailboxManager.getMailbox(MailboxPath.forUser((Username)username, (String)mailboxName.asString()), mailboxSession).getMessageCount(mailboxSession);
            return l;
        }
        finally {
            this.mailboxManager.endProcessingRequest(mailboxSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long unseenMessageCount(Username username, MailboxName mailboxName, Options options) throws UsersRepositoryException, MailboxException {
        this.usernamePreconditions(username, options);
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        try {
            long l = this.mailboxManager.getMailbox(MailboxPath.forUser((Username)username, (String)mailboxName.asString()), mailboxSession).getMailboxCounters(mailboxSession).getUnseen();
            return l;
        }
        finally {
            this.mailboxManager.endProcessingRequest(mailboxSession);
        }
    }

    private Stream<MailboxPath> listChildren(MailboxPath mailboxPath, MailboxSession mailboxSession) {
        return this.listUserMailboxes(mailboxSession).map(MailboxMetaData::getPath).filter(path -> path.getHierarchyLevels(mailboxSession.getPathDelimiter()).contains(mailboxPath));
    }

    private void deleteMailbox(MailboxSession mailboxSession, MailboxPath mailboxPath) throws MailboxException {
        try {
            this.mailboxManager.deleteMailbox(mailboxPath, mailboxSession);
        }
        catch (MailboxNotFoundException e) {
            LOGGER.info("Attempt to delete mailbox {} for user {} that does not exists", (Object)mailboxPath.getName(), (Object)mailboxPath.getUser());
        }
    }

    public void usernamePreconditions(Username username, Options options) throws UsersRepositoryException {
        Preconditions.checkState((options == Options.Force || this.usersRepository.contains(username) ? 1 : 0) != 0, (Object)"User does not exist");
    }

    public void mailboxExistPreconditions(Username username, MailboxName mailboxName) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        MailboxPath mailboxPath = MailboxPath.forUser((Username)username, (String)mailboxName.asString()).assertAcceptable(mailboxSession.getPathDelimiter());
        Preconditions.checkState((boolean)Boolean.TRUE.equals(Mono.from((Publisher)this.mailboxManager.mailboxExists(mailboxPath, mailboxSession)).block()), (Object)("Mailbox does not exist. " + mailboxPath.asString()));
        this.mailboxManager.endProcessingRequest(mailboxSession);
    }

    private Stream<MailboxMetaData> listUserMailboxes(MailboxSession mailboxSession) {
        return this.mailboxManager.search(MailboxQuery.privateMailboxesBuilder((MailboxSession)mailboxSession).build(), MailboxManager.MailboxSearchFetchType.Minimal, mailboxSession).toStream();
    }

    public static enum Options {
        Force,
        Check;

    }
}

