/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.data.jmap;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import javax.mail.internet.AddressException;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.identity.IdentityNotFoundException;
import org.apache.james.jmap.api.identity.IdentityRepository;
import org.apache.james.jmap.api.model.IdentityId;
import org.apache.james.util.FunctionalUtils;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.data.jmap.dto.UserIdentity;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.ParametersExtractor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;
import spark.Spark;

public class UserIdentityRoutes
implements Routes {
    public static final String USERS = "/users";
    public static final String IDENTITIES = "identities";
    private static final String USER_NAME = ":userName";
    private static final String IDENTITY_ID = ":identityId";
    public static final String USERS_IDENTITY_BASE_PATH = "/users/:userName/identities";
    private Service service;
    private final IdentityRepository identityRepository;
    private final JsonTransformer jsonTransformer;
    private final ObjectMapper jsonDeserialize;

    @Inject
    public UserIdentityRoutes(IdentityRepository identityRepository, JsonTransformer jsonTransformer) {
        this.identityRepository = identityRepository;
        this.jsonTransformer = jsonTransformer;
        this.jsonDeserialize = new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new GuavaModule());
        this.jsonDeserialize.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public String getBasePath() {
        return USERS;
    }

    public void define(Service service) {
        this.service = service;
        this.getUserIdentities();
        this.createUserIdentity();
        this.updateUserIdentity();
    }

    public void getUserIdentities() {
        this.service.get(USERS_IDENTITY_BASE_PATH, this::listIdentities, (ResponseTransformer)this.jsonTransformer);
    }

    public void createUserIdentity() {
        this.service.post(USERS_IDENTITY_BASE_PATH, this::createIdentity);
    }

    public void updateUserIdentity() {
        this.service.put("/users/:userName/identities/:identityId", this::updateIdentity);
    }

    private List<UserIdentity> listIdentities(Request request, Response response) {
        Username username = this.extractUsername(request);
        Optional defaultFilter = ParametersExtractor.extractBoolean((Request)request, (String)"default");
        List identities = (List)Flux.from((Publisher)this.identityRepository.list(username)).map(UserIdentity::from).collectList().block();
        return defaultFilter.filter(FunctionalUtils.identityPredicate()).map(queryDefault -> this.getDefaultIdentity(identities).map(List::of).orElseThrow(() -> this.throw404("Default identity can not be found"))).orElse(identities);
    }

    private HaltException createIdentity(Request request, Response response) {
        Username username = this.extractUsername(request);
        try {
            UserIdentity.UserIdentityUpsert creationRequest = (UserIdentity.UserIdentityUpsert)this.jsonDeserialize.readValue(request.body(), UserIdentity.UserIdentityUpsert.class);
            Mono.from((Publisher)this.identityRepository.save(username, creationRequest.asCreationRequest())).block();
            return Spark.halt((int)201);
        }
        catch (JsonProcessingException | AddressException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("JSON payload of the request is not valid").cause((Exception)e).haltError();
        }
    }

    private HaltException updateIdentity(Request request, Response response) {
        Username username = this.extractUsername(request);
        IdentityId identityId = Optional.ofNullable(request.params(IDENTITY_ID)).map(UUID::fromString).map(IdentityId::new).orElseThrow(() -> new IllegalArgumentException("Can not parse identityId"));
        try {
            UserIdentity.UserIdentityUpsert updateRequest = (UserIdentity.UserIdentityUpsert)this.jsonDeserialize.readValue(request.body(), UserIdentity.UserIdentityUpsert.class);
            Mono.from((Publisher)this.identityRepository.update(username, identityId, updateRequest.asUpdateRequest())).block();
            return Spark.halt((int)204);
        }
        catch (JsonProcessingException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("JSON payload of the request is not valid").cause((Exception)((Object)e)).haltError();
        }
        catch (IdentityNotFoundException notFoundException) {
            throw this.throw404(String.format("IdentityId '%s' can not be found", identityId.id().toString()));
        }
    }

    private Optional<UserIdentity> getDefaultIdentity(List<UserIdentity> identities) {
        return identities.stream().filter(UserIdentity::getMayDelete).min(Comparator.comparing(UserIdentity::getSortOrder));
    }

    private HaltException throw404(String message) {
        throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message(message).haltError();
    }

    private Username extractUsername(Request request) {
        return Username.of((String)request.params(USER_NAME));
    }
}

