/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.DocValuesPropertyBase;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class WildcardProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final String nullValue;
    public static final JsonpDeserializer<WildcardProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WildcardProperty::setupWildcardPropertyDeserializer);

    private WildcardProperty(Builder builder) {
        super(builder);
        this.nullValue = builder.nullValue;
    }

    public static WildcardProperty of(Function<Builder, ObjectBuilder<WildcardProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Wildcard;
    }

    @Nullable
    public final String nullValue() {
        return this.nullValue;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "wildcard");
        super.serializeInternal(generator, mapper);
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue);
        }
    }

    protected static void setupWildcardPropertyDeserializer(ObjectDeserializer<Builder> op) {
        WildcardProperty.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::nullValue, JsonpDeserializer.stringDeserializer(), "null_value");
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<WildcardProperty> {
        @Nullable
        private String nullValue;

        public final Builder nullValue(@Nullable String value) {
            this.nullValue = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WildcardProperty build() {
            this._checkSingleUse();
            return new WildcardProperty(this);
        }
    }
}

