/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.task;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.model.CurrentQuotas;
import org.apache.james.mailbox.model.QuotaOperation;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import org.apache.james.mailbox.quota.UserQuotaRootResolver;
import org.apache.james.mailbox.store.quota.CurrentQuotaCalculator;
import org.apache.james.task.Task;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RecomputeCurrentQuotasService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecomputeCurrentQuotasService.class);
    private final UsersRepository usersRepository;
    private final CurrentQuotaManager storeCurrentQuotaManager;
    private final CurrentQuotaCalculator currentQuotaCalculator;
    private final UserQuotaRootResolver userQuotaRootResolver;
    private final SessionProvider sessionProvider;
    private final MailboxManager mailboxManager;

    @Inject
    public RecomputeCurrentQuotasService(UsersRepository usersRepository, CurrentQuotaManager storeCurrentQuotaManager, CurrentQuotaCalculator currentQuotaCalculator, UserQuotaRootResolver userQuotaRootResolver, SessionProvider sessionProvider, MailboxManager mailboxManager) {
        this.usersRepository = usersRepository;
        this.storeCurrentQuotaManager = storeCurrentQuotaManager;
        this.currentQuotaCalculator = currentQuotaCalculator;
        this.userQuotaRootResolver = userQuotaRootResolver;
        this.sessionProvider = sessionProvider;
        this.mailboxManager = mailboxManager;
    }

    public Mono<Task.Result> recomputeCurrentQuotas(Context context, RunningOptions runningOptions) {
        return Flux.from((Publisher)this.usersRepository.listReactive()).transform(ReactorUtils.throttle().elements(runningOptions.getUsersPerSecond()).per(Duration.ofSeconds(1L)).forOperation(username -> this.recomputeUserCurrentQuotas(context, (Username)username))).reduce((Object)Task.Result.COMPLETED, Task::combine).onErrorResume(UsersRepositoryException.class, e -> {
            LOGGER.error("Error while accessing users from repository", (Throwable)e);
            return Mono.just((Object)Task.Result.PARTIAL);
        });
    }

    private Mono<Task.Result> recomputeUserCurrentQuotas(Context context, Username username) {
        MailboxSession session = this.sessionProvider.createSystemSession(username);
        QuotaRoot quotaRoot = this.userQuotaRootResolver.forUser(username);
        return this.currentQuotaCalculator.recalculateCurrentQuotas(quotaRoot, session).map(recalculatedQuotas -> QuotaOperation.from((QuotaRoot)quotaRoot, (CurrentQuotas)recalculatedQuotas)).flatMap(quotaOperation -> Mono.from((Publisher)this.storeCurrentQuotaManager.setCurrentQuotas(quotaOperation))).then(Mono.just((Object)Task.Result.COMPLETED)).doOnNext(any -> {
            LOGGER.info("Current quotas recomputed for {}", (Object)quotaRoot);
            context.incrementProcessed();
        }).onErrorResume(e -> {
            LOGGER.error("Error while recomputing current quotas for {}", (Object)quotaRoot, e);
            context.addToFailedMailboxes(quotaRoot);
            return Mono.just((Object)Task.Result.PARTIAL);
        }).doFinally(any -> this.mailboxManager.endProcessingRequest(session));
    }

    public static class Context {
        private final AtomicLong processedQuotaRootCount;
        private final ConcurrentLinkedDeque<QuotaRoot> failedQuotaRoots;

        public Context() {
            this.processedQuotaRootCount = new AtomicLong();
            this.failedQuotaRoots = new ConcurrentLinkedDeque();
        }

        public Context(long processedQuotaRootCount, Collection<QuotaRoot> failedQuotaRoots) {
            this.processedQuotaRootCount = new AtomicLong(processedQuotaRootCount);
            this.failedQuotaRoots = new ConcurrentLinkedDeque<QuotaRoot>(failedQuotaRoots);
        }

        void incrementProcessed() {
            this.processedQuotaRootCount.incrementAndGet();
        }

        void addToFailedMailboxes(QuotaRoot quotaRoot) {
            this.failedQuotaRoots.add(quotaRoot);
        }

        public Snapshot snapshot() {
            return new Snapshot(this.processedQuotaRootCount.get(), (ImmutableList<QuotaRoot>)ImmutableList.copyOf(this.failedQuotaRoots));
        }

        static class Snapshot {
            private final long processedQuotaRootCount;
            private final ImmutableList<QuotaRoot> failedQuotaRoots;

            private Snapshot(long processedQuotaRootCount, ImmutableList<QuotaRoot> failedQuotaRoots) {
                this.processedQuotaRootCount = processedQuotaRootCount;
                this.failedQuotaRoots = failedQuotaRoots;
            }

            long getProcessedQuotaRootCount() {
                return this.processedQuotaRootCount;
            }

            ImmutableList<QuotaRoot> getFailedQuotaRoots() {
                return this.failedQuotaRoots;
            }

            public final boolean equals(Object o) {
                if (o instanceof Snapshot) {
                    Snapshot that = (Snapshot)o;
                    return Objects.equals(this.processedQuotaRootCount, that.processedQuotaRootCount) && Objects.equals(this.failedQuotaRoots, that.failedQuotaRoots);
                }
                return false;
            }

            public final int hashCode() {
                return Objects.hash(this.processedQuotaRootCount, this.failedQuotaRoots);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("processedQuotaRootCount", this.processedQuotaRootCount).add("failedQuotaRoots", this.failedQuotaRoots).toString();
            }
        }
    }

    public static class RunningOptions {
        public static final RunningOptions DEFAULT = RunningOptions.withUsersPerSecond(1);
        private final int usersPerSecond;

        public static RunningOptions withUsersPerSecond(int usersPerSecond) {
            return new RunningOptions(usersPerSecond);
        }

        private RunningOptions(int usersPerSecond) {
            Preconditions.checkArgument((usersPerSecond > 0 ? 1 : 0) != 0, (Object)"'usersPerSecond' needs to be strictly positive");
            this.usersPerSecond = usersPerSecond;
        }

        public int getUsersPerSecond() {
            return this.usersPerSecond;
        }
    }
}

