/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public abstract class GenericRegexMatcher
extends GenericMatcher {
    protected Object[][] patterns;

    public void compile(Object[][] patterns) throws PatternSyntaxException {
        this.patterns = patterns;
        for (int i = 0; i < patterns.length; ++i) {
            String pattern = (String)patterns[i][1];
            patterns[i][1] = Pattern.compile(pattern);
        }
    }

    public abstract void init() throws MessagingException;

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        if (this.patterns != null) {
            for (Object[] pattern1 : this.patterns) {
                String headerName = (String)pattern1[0];
                Pattern pattern = (Pattern)pattern1[1];
                String[] headers = message.getHeader(headerName);
                if (headers == null) continue;
                for (String header : headers) {
                    if (!pattern.matcher(header).matches()) continue;
                    return mail.getRecipients();
                }
            }
        }
        return null;
    }
}

