/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.executor;

import org.apache.james.jspf.core.SPFSession;

public class SPFResult {
    protected String headerTextAsString = "";
    protected static final String HEADER_NAME = "Received-SPF";
    protected String result = null;
    protected String explanation = null;

    protected SPFResult() {
    }

    public SPFResult(SPFSession spfSession) {
        this.setSPFSession(spfSession);
    }

    protected void setSPFSession(SPFSession spfSession) {
        this.explanation = spfSession.getExplanation();
        this.result = spfSession.getCurrentResultExpanded();
        this.headerTextAsString = this.generateHeader(this.result, spfSession);
    }

    public String getHeader() {
        return "Received-SPF: " + this.getHeaderText();
    }

    public String getHeaderName() {
        return HEADER_NAME;
    }

    public String getHeaderText() {
        return this.headerTextAsString != null ? this.headerTextAsString : "";
    }

    private String generateHeader(String result, SPFSession spfData) {
        String headerTextAsString;
        StringBuffer headerText = new StringBuffer();
        if (result.equals("pass")) {
            headerText.append(result + " (spfCheck: domain of " + spfData.getCurrentDomain() + " designates " + spfData.getIpAddress() + " as permitted sender) ");
        } else if (result.equals("fail")) {
            headerText.append(result + " (spfCheck: domain of " + spfData.getCurrentDomain() + " does not designate " + spfData.getIpAddress() + " as permitted sender) ");
        } else if (result.equals("neutral") || result.equals("none")) {
            headerText.append(result + " (spfCheck: " + spfData.getIpAddress() + " is neither permitted nor denied by domain of " + spfData.getCurrentDomain() + ") ");
        } else if (result.equals("softfail")) {
            headerText.append(result + " (spfCheck: transitioning domain of " + spfData.getCurrentDomain() + " does not designate " + spfData.getIpAddress() + " as permitted sender) ");
        } else if (result.equals("permerror")) {
            headerText.append(result + " (spfCheck: Error in processing SPF Record) ");
        } else if (result.equals("temperror")) {
            headerText.append(result + " (spfCheck: Error in retrieving data from DNS) ");
        }
        if (headerText.length() > 0) {
            headerText.append("client-ip=" + spfData.getIpAddress() + "; envelope-from=" + spfData.getMailFrom() + "; helo=" + spfData.getHostName() + ";");
            headerTextAsString = headerText.toString();
        } else {
            headerTextAsString = "";
        }
        return headerTextAsString;
    }

    public String getResult() {
        return this.result;
    }

    public String getExplanation() {
        return this.explanation != null ? this.explanation : "";
    }
}

