/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.tester;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.james.jspf.tester.ResponseGenerator;

public final class TCPListener
implements Runnable {
    private final int port;
    private final InetAddress addr;
    private ResponseGenerator responseGenerator;

    public TCPListener(InetAddress addr, int port, ResponseGenerator rg) {
        this.port = port;
        this.addr = addr;
        this.responseGenerator = rg;
    }

    @Override
    public void run() {
        try {
            ServerSocket sock = new ServerSocket(this.port, 128, this.addr);
            while (true) {
                new Thread(new TCPServer(sock.accept(), this.responseGenerator)).start();
            }
        }
        catch (IOException e) {
            System.out.println("serveTCP(" + this.addr.getHostAddress() + "#" + this.port + "): " + e);
            return;
        }
    }

    private static final class TCPServer
    implements Runnable {
        private final Socket serverSocket;
        private ResponseGenerator responseGenerator;

        private TCPServer(Socket s, ResponseGenerator rg) {
            this.serverSocket = s;
            this.responseGenerator = rg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                InputStream is = this.serverSocket.getInputStream();
                DataInputStream dataIn = new DataInputStream(is);
                int inLength = dataIn.readUnsignedShort();
                byte[] in = new byte[inLength];
                dataIn.readFully(in);
                int length = in.length;
                byte[] response = this.responseGenerator.generateReply(in, length);
                if (response == null) {
                    return;
                }
                DataOutputStream dataOut = new DataOutputStream(this.serverSocket.getOutputStream());
                dataOut.writeShort(response.length);
                dataOut.write(response);
            }
            catch (IOException e) {
                System.out.println("TCPclient(" + this.serverSocket.getLocalAddress().getHostAddress() + "#" + this.serverSocket.getLocalPort() + "): " + e);
            }
            finally {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

