/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.iwork;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.detect.XmlRootExtractor;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.iwork.KeynoteContentHandler;
import org.apache.tika.parser.iwork.NumbersContentHandler;
import org.apache.tika.parser.iwork.PagesContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IWorkPackageParser
extends AbstractParser {
    public static final Set<String> IWORK_CONTENT_ENTRIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("index.apxl", "index.xml", "presentation.apxl")));
    public static final String IWORK_COMMON_ENTRY = "buildVersionHistory.plist";
    private static final long serialVersionUID = -2160322853809682372L;
    private static final Set<MediaType> supportedTypes = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application("vnd.apple.iwork"), IWORKDocumentType.KEYNOTE.getType(), IWORKDocumentType.NUMBERS.getType(), IWORKDocumentType.PAGES.getType())));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return supportedTypes;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ZipArchiveInputStream zip = new ZipArchiveInputStream(stream);
        ZipArchiveEntry entry = zip.getNextZipEntry();
        while (entry != null) {
            if (!IWORK_CONTENT_ENTRIES.contains(entry.getName())) {
                entry = zip.getNextZipEntry();
                continue;
            }
            BufferedInputStream entryStream = new BufferedInputStream((InputStream)zip, 4096);
            ((InputStream)entryStream).mark(4096);
            IWORKDocumentType type = IWORKDocumentType.detectType(entryStream);
            ((InputStream)entryStream).reset();
            if (type != null) {
                DefaultHandler contentHandler;
                XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
                switch (type) {
                    case KEYNOTE: {
                        contentHandler = new KeynoteContentHandler(xhtml, metadata);
                        break;
                    }
                    case NUMBERS: {
                        contentHandler = new NumbersContentHandler(xhtml, metadata);
                        break;
                    }
                    case PAGES: {
                        contentHandler = new PagesContentHandler(xhtml, metadata);
                        break;
                    }
                    case ENCRYPTED: {
                        contentHandler = null;
                        break;
                    }
                    default: {
                        throw new TikaException("Unhandled iWorks file " + (Object)((Object)type));
                    }
                }
                metadata.add("Content-Type", type.getType().toString());
                xhtml.startDocument();
                if (contentHandler != null) {
                    XMLReaderUtils.parseSAX(new CloseShieldInputStream(entryStream), contentHandler, context);
                }
                xhtml.endDocument();
            }
            entry = zip.getNextZipEntry();
        }
    }

    public static enum IWORKDocumentType {
        KEYNOTE("http://developer.apple.com/namespaces/keynote2", "presentation", MediaType.application("vnd.apple.keynote")),
        NUMBERS("http://developer.apple.com/namespaces/ls", "document", MediaType.application("vnd.apple.numbers")),
        PAGES("http://developer.apple.com/namespaces/sl", "document", MediaType.application("vnd.apple.pages")),
        ENCRYPTED(null, null, MediaType.application("x-tika-iworks-protected"));

        private final String namespace;
        private final String part;
        private final MediaType type;

        private IWORKDocumentType(String namespace, String part, MediaType type) {
            this.namespace = namespace;
            this.part = part;
            this.type = type;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static IWORKDocumentType detectType(ZipArchiveEntry entry, ZipFile zip) {
            try {
                if (entry == null) {
                    return null;
                }
                try (InputStream stream = zip.getInputStream(entry);){
                    IWORKDocumentType iWORKDocumentType = IWORKDocumentType.detectType(stream);
                    return iWORKDocumentType;
                }
            }
            catch (IOException e) {
                return null;
            }
        }

        public static IWORKDocumentType detectType(ZipArchiveEntry entry, ZipArchiveInputStream zip) {
            if (entry == null) {
                return null;
            }
            return IWORKDocumentType.detectType((InputStream)zip);
        }

        public static IWORKDocumentType detectType(InputStream stream) {
            QName qname = new XmlRootExtractor().extractRootElement(stream);
            if (qname != null) {
                String uri = qname.getNamespaceURI();
                String local = qname.getLocalPart();
                for (IWORKDocumentType type : IWORKDocumentType.values()) {
                    if (ENCRYPTED == type || !type.getNamespace().equals(uri) || !type.getPart().equals(local)) continue;
                    return type;
                }
            } else {
                try {
                    stream.read();
                }
                catch (UnsupportedZipFeatureException e) {
                    return ENCRYPTED;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getPart() {
            return this.part;
        }

        public MediaType getType() {
            return this.type;
        }
    }
}

