/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.version;

import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class RemoveVersionLabel
implements Command {
    private static Log log = LogFactory.getLog(RemoveVersionLabel.class);
    private String pathKey = "path";
    private String labelKey = "label";

    @Override
    public boolean execute(Context ctx) throws Exception {
        String path = (String)ctx.get(this.pathKey);
        String versionLabel = (String)ctx.get(this.labelKey);
        if (log.isDebugEnabled()) {
            log.debug("Remove label " + versionLabel + " from node " + path);
        }
        CommandHelper.getNode(ctx, path).getVersionHistory().removeVersionLabel(versionLabel);
        return false;
    }

    public String getPathKey() {
        return this.pathKey;
    }

    public void setPathKey(String pathKey) {
        this.pathKey = pathKey;
    }

    public String getLabelKey() {
        return this.labelKey;
    }

    public void setLabelKey(String versionLabelKey) {
        this.labelKey = versionLabelKey;
    }
}

