/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi2dav.ExceptionConverter;
import org.apache.jackrabbit.spi2dav.IdURICache;
import org.apache.jackrabbit.spi2dav.ItemResourceConstants;
import org.apache.jackrabbit.spi2dav.RepositoryServiceImpl;
import org.apache.jackrabbit.spi2dav.URIResolver;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import org.apache.jackrabbit.webdav.client.methods.HttpReport;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.w3c.dom.Document;

class URIResolverImpl
implements URIResolver {
    private final URI repositoryUri;
    private final RepositoryServiceImpl service;
    private final Document domFactory;
    private final Map<String, IdURICache> idURICaches = new HashMap<String, IdURICache>();

    URIResolverImpl(URI repositoryUri, RepositoryServiceImpl service, Document domFactory) {
        this.repositoryUri = repositoryUri;
        this.service = service;
        this.domFactory = domFactory;
    }

    private IdURICache getCache(String workspaceName) {
        if (this.idURICaches.containsKey(workspaceName)) {
            return this.idURICaches.get(workspaceName);
        }
        IdURICache c = new IdURICache(this.getWorkspaceUri(workspaceName));
        this.idURICaches.put(workspaceName, c);
        return c;
    }

    String getRepositoryUri() {
        return this.repositoryUri.toASCIIString();
    }

    String getWorkspaceUri(String workspaceName) {
        Object workspaceUri = this.getRepositoryUri();
        if (workspaceName != null) {
            workspaceUri = (String)workspaceUri + Text.escape(workspaceName);
        }
        return workspaceUri;
    }

    String getRootItemUri(String workspaceName) {
        return this.getWorkspaceUri(workspaceName) + Text.escapePath("/jcr:root");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getItemUri(ItemId itemId, String workspaceName, SessionInfo sessionInfo) throws RepositoryException {
        IdURICache cache = this.getCache(workspaceName);
        if (cache.containsItemId(itemId)) {
            return cache.getUri(itemId);
        }
        StringBuffer uriBuffer = new StringBuffer();
        Path path = itemId.getPath();
        String uniqueID = itemId.getUniqueID();
        if (uniqueID != null) {
            ItemId uuidId;
            ItemId itemId2 = uuidId = path == null ? itemId : this.service.getIdFactory().createNodeId(uniqueID);
            if (path != null && cache.containsItemId(uuidId)) {
                uriBuffer.append(cache.getUri(uuidId));
            } else {
                ReportInfo rInfo = new ReportInfo("locate-by-uuid", ItemResourceConstants.NAMESPACE);
                rInfo.setContentElement(DomUtil.hrefToXml(uniqueID, this.domFactory));
                HttpRequestBase request = null;
                try {
                    String wspUri = this.getWorkspaceUri(workspaceName);
                    request = new HttpReport(wspUri, rInfo);
                    HttpResponse response = this.service.executeRequest(sessionInfo, request);
                    ((BaseDavRequest)request).checkSuccess(response);
                    MultiStatus ms = ((BaseDavRequest)request).getResponseBodyAsMultiStatus(response);
                    if (ms.getResponses().length != 1) throw new ItemNotFoundException("Cannot identify item with uniqueID " + uniqueID);
                    String absoluteUri = URIResolverImpl.resolve(wspUri, ms.getResponses()[0].getHref());
                    uriBuffer.append(absoluteUri);
                    cache.add(absoluteUri, uuidId);
                }
                catch (IOException e) {
                    throw new RepositoryException(e.getMessage());
                }
                catch (DavException e) {
                    throw ExceptionConverter.generate(e);
                }
                finally {
                    if (request != null) {
                        request.releaseConnection();
                    }
                }
            }
        } else {
            uriBuffer.append(this.getRootItemUri(workspaceName));
        }
        if (path != null && !path.denotesRoot()) {
            String jcrPath = this.service.getNamePathResolver(sessionInfo).getJCRPath(path);
            if (!path.isAbsolute() && !uriBuffer.toString().endsWith("/")) {
                uriBuffer.append("/");
            }
            uriBuffer.append(Text.escapePath(jcrPath));
        }
        String itemUri = uriBuffer.toString();
        if (cache.containsItemId(itemId)) return itemUri;
        cache.add(itemUri, itemId);
        return itemUri;
    }

    private static String resolve(String wspUri, String href) throws RepositoryException {
        try {
            URI base = new URI(wspUri);
            URI rel = new URI(href);
            return base.resolve(rel).toString();
        }
        catch (URISyntaxException ex) {
            throw new RepositoryException(ex);
        }
    }

    protected NodeId buildNodeId(NodeId parentId, String baseUri, MultiStatusResponse response, String workspaceName, NamePathResolver resolver) throws RepositoryException {
        NodeId nodeId;
        IdURICache cache = this.getCache(workspaceName);
        DavPropertySet propSet = response.getProperties(200);
        String uniqueID = this.service.getUniqueID(propSet);
        if (uniqueID != null) {
            nodeId = this.service.getIdFactory().createNodeId(uniqueID);
        } else {
            Name qName = this.service.getQName(propSet, resolver);
            if (NameConstants.ROOT.equals(qName)) {
                nodeId = this.service.getIdFactory().createNodeId((String)null, this.service.getPathFactory().getRootPath());
            } else {
                int index = this.service.getIndex(propSet);
                nodeId = this.service.getIdFactory().createNodeId(parentId, this.service.getPathFactory().create(qName, index));
            }
        }
        cache.add(URIResolverImpl.resolve(baseUri, response.getHref()), nodeId);
        return nodeId;
    }

    PropertyId buildPropertyId(NodeId parentId, MultiStatusResponse response, String workspaceName, NamePathResolver resolver) throws RepositoryException {
        ItemId id;
        IdURICache cache = this.getCache(workspaceName);
        if (cache.containsUri(response.getHref()) && !(id = cache.getItemId(response.getHref())).denotesNode()) {
            return (PropertyId)id;
        }
        try {
            DavPropertySet propSet = response.getProperties(200);
            Name name = resolver.getQName(propSet.get("name", ItemResourceConstants.NAMESPACE).getValue().toString());
            PropertyId propertyId = this.service.getIdFactory().createPropertyId(parentId, name);
            cache.add(response.getHref(), propertyId);
            return propertyId;
        }
        catch (NameException e) {
            throw new RepositoryException(e);
        }
    }

    void clearCacheEntries(ItemId itemId, SessionInfo sessionInfo) {
        IdURICache cache = this.getCache(sessionInfo.getWorkspaceName());
        if (cache.containsItemId(itemId)) {
            cache.remove(itemId);
        }
    }

    void clearCacheEntries(SessionInfo sessionInfo) {
        IdURICache cache = this.getCache(sessionInfo.getWorkspaceName());
        cache.clear();
    }

    private static boolean isSameURI(String uri1, String uri2) {
        return URIResolverImpl.getCleanURI(uri1).equals(URIResolverImpl.getCleanURI(uri2));
    }

    private static String getCleanURI(String uri) {
        if (uri.endsWith("/")) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    private NodeId getNodeId(String uri, SessionInfo sessionInfo, boolean nodeIsGone) throws RepositoryException {
        NodeId parentId;
        ItemId id;
        IdURICache cache = this.getCache(sessionInfo.getWorkspaceName());
        if (cache.containsUri(uri) && (id = cache.getItemId(uri)).denotesNode()) {
            return (NodeId)id;
        }
        if (nodeIsGone) {
            throw new RepositoryException("Can't reconstruct nodeId from URI when the remote node is gone.");
        }
        if (URIResolverImpl.isSameURI(uri, this.getRootItemUri(sessionInfo.getWorkspaceName()))) {
            parentId = null;
        } else {
            String parentUri = Text.getRelativeParent(uri, 1, true);
            parentId = this.getNodeId(parentUri, sessionInfo, false);
        }
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add("uuid", ItemResourceConstants.NAMESPACE);
        nameSet.add("name", ItemResourceConstants.NAMESPACE);
        nameSet.add("index", ItemResourceConstants.NAMESPACE);
        HttpRequestBase request = null;
        try {
            request = new HttpPropfind(uri, nameSet, 0);
            HttpResponse response = this.service.executeRequest(sessionInfo, request);
            if (response.getStatusLine().getStatusCode() != 207) {
                throw new ItemNotFoundException("Unable to retrieve the node with id " + uri + ", response status was: " + response.getStatusLine().getStatusCode());
            }
            MultiStatusResponse[] responses = ((BaseDavRequest)request).getResponseBodyAsMultiStatus(response).getResponses();
            if (responses.length != 1) {
                throw new ItemNotFoundException("Unable to retrieve the node with id " + uri);
            }
            NodeId nodeId = this.buildNodeId(parentId, uri, responses[0], sessionInfo.getWorkspaceName(), this.service.getNamePathResolver(sessionInfo));
            return nodeId;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public Path getQPath(String uri, SessionInfo sessionInfo) throws RepositoryException {
        String rootUri = this.getRootItemUri(sessionInfo.getWorkspaceName());
        String jcrPath = uri.startsWith(rootUri) ? uri.substring(rootUri.length()) : uri;
        try {
            return this.service.getNamePathResolver(sessionInfo).getQPath(Text.unescape(jcrPath));
        }
        catch (NameException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public NodeId getNodeId(String uri, SessionInfo sessionInfo) throws RepositoryException {
        return this.getNodeId(uri, sessionInfo, false);
    }

    @Override
    public NodeId getNodeIdAfterEvent(String uri, SessionInfo sessionInfo, boolean nodeIsGone) throws RepositoryException {
        return this.getNodeId(uri, sessionInfo, nodeIsGone);
    }

    @Override
    public PropertyId getPropertyId(String uri, SessionInfo sessionInfo) throws RepositoryException {
        IdURICache cache = this.getCache(sessionInfo.getWorkspaceName());
        ItemId id = cache.getItemId(uri);
        if (id != null && !id.denotesNode()) {
            return (PropertyId)id;
        }
        String parentUri = Text.getRelativeParent(uri, 1, true);
        String propName = Text.unescape(Text.getName(uri, true));
        NodeId parentId = this.getNodeId(parentUri, sessionInfo, false);
        try {
            Name name = this.service.getNamePathResolver(sessionInfo).getQName(propName);
            PropertyId propertyId = this.service.getIdFactory().createPropertyId(parentId, name);
            cache.add(uri, propertyId);
            return propertyId;
        }
        catch (NameException e) {
            throw new RepositoryException(e);
        }
    }
}

