/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InternalActivity;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionImpl;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.InternalVersionItemImpl;
import org.apache.jackrabbit.core.version.InternalVersionManagerBase;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionSet;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;

class InternalActivityImpl
extends InternalVersionItemImpl
implements InternalActivity {
    public InternalActivityImpl(InternalVersionManagerBase vMgr, NodeStateEx node) throws RepositoryException {
        super(vMgr, node);
    }

    @Override
    public NodeId getId() {
        return this.node.getNodeId();
    }

    @Override
    public InternalVersionItem getParent() {
        return null;
    }

    static NodeStateEx create(NodeStateEx parent, Name name, NodeId activityId, String title) throws RepositoryException {
        NodeStateEx pNode = parent.addNode(name, NameConstants.NT_ACTIVITY, activityId, true);
        HashSet<Name> mix = new HashSet<Name>();
        mix.add(NameConstants.REP_VERSION_REFERENCE);
        pNode.setMixins(mix);
        pNode.setPropertyValue(NameConstants.JCR_ACTIVITY_TITLE, InternalValue.create(title));
        parent.store();
        return pNode;
    }

    public void addVersion(InternalVersionImpl v) throws RepositoryException {
        InternalValue[] versions;
        if (this.node.hasProperty(NameConstants.REP_VERSIONS)) {
            InternalValue[] vs = this.node.getPropertyValues(NameConstants.REP_VERSIONS);
            versions = new InternalValue[vs.length + 1];
            System.arraycopy(vs, 0, versions, 0, vs.length);
            versions[vs.length] = InternalValue.create(v.getId());
        } else {
            versions = new InternalValue[]{InternalValue.create(v.getId())};
        }
        this.node.setPropertyValues(NameConstants.REP_VERSIONS, 9, versions);
        this.node.store();
    }

    public void removeVersion(InternalVersionImpl v) throws RepositoryException {
        LinkedList<InternalValue> versions = new LinkedList<InternalValue>();
        if (this.node.hasProperty(NameConstants.REP_VERSIONS)) {
            NodeId vId = v.getId();
            for (InternalValue ref : this.node.getPropertyValues(NameConstants.REP_VERSIONS)) {
                if (vId.equals(ref.getNodeId())) continue;
                versions.add(ref);
            }
        }
        this.node.setPropertyValues(NameConstants.REP_VERSIONS, 9, versions.toArray(new InternalValue[versions.size()]));
        this.node.store();
    }

    @Override
    public InternalVersion getLatestVersion(InternalVersionHistory history) throws RepositoryException {
        if (this.node.hasProperty(NameConstants.REP_VERSIONS)) {
            InternalVersion best = null;
            for (InternalValue ref : this.node.getPropertyValues(NameConstants.REP_VERSIONS)) {
                InternalVersion v = history.getVersion(ref.getNodeId());
                if (v == null) continue;
                best = v;
            }
            return best;
        }
        return null;
    }

    @Override
    public VersionSet getChangeSet() throws RepositoryException {
        HashMap<NodeId, InternalVersion> changeset = new HashMap<NodeId, InternalVersion>();
        if (this.node.hasProperty(NameConstants.REP_VERSIONS)) {
            for (InternalValue ref : this.node.getPropertyValues(NameConstants.REP_VERSIONS)) {
                InternalVersion v = this.vMgr.getVersion(ref.getNodeId());
                changeset.put(v.getVersionHistory().getId(), v);
            }
        }
        return new VersionSet(changeset);
    }
}

