/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.sys;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.AuthorType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;

public class AuthorStatement
extends Statement
implements IConfigStatement {
    private final AuthorType authorType;
    private String userName;
    private String roleName;
    private String password;
    private String newPassword;
    private String[] privilegeList;
    private List<PartialPath> nodeNameList;
    private boolean grantOpt;

    public AuthorStatement(AuthorType type) {
        this.authorType = type;
        switch (this.authorType) {
            case DROP_ROLE: {
                this.setType(StatementType.DELETE_ROLE);
                break;
            }
            case DROP_USER: {
                this.setType(StatementType.DELETE_USER);
                break;
            }
            case GRANT_ROLE: {
                this.setType(StatementType.GRANT_ROLE_PRIVILEGE);
                break;
            }
            case GRANT_USER: {
                this.setType(StatementType.GRANT_USER_PRIVILEGE);
                break;
            }
            case CREATE_ROLE: {
                this.setType(StatementType.CREATE_ROLE);
                break;
            }
            case CREATE_USER: {
                this.setType(StatementType.CREATE_USER);
                break;
            }
            case REVOKE_ROLE: {
                this.setType(StatementType.REVOKE_ROLE_PRIVILEGE);
                break;
            }
            case REVOKE_USER: {
                this.setType(StatementType.REVOKE_USER_PRIVILEGE);
                break;
            }
            case UPDATE_USER: {
                this.setType(StatementType.MODIFY_PASSWORD);
                break;
            }
            case GRANT_USER_ROLE: {
                this.setType(StatementType.GRANT_USER_ROLE);
                break;
            }
            case REVOKE_USER_ROLE: {
                this.setType(StatementType.REVOKE_USER_ROLE);
                break;
            }
            case LIST_USER_PRIVILEGE: {
                this.setType(StatementType.LIST_USER_PRIVILEGE);
                break;
            }
            case LIST_ROLE_PRIVILEGE: {
                this.setType(StatementType.LIST_ROLE_PRIVILEGE);
                break;
            }
            case LIST_USER: {
                this.setType(StatementType.LIST_USER);
                break;
            }
            case LIST_ROLE: {
                this.setType(StatementType.LIST_ROLE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown authorType: " + (Object)((Object)this.authorType));
            }
        }
    }

    public AuthorStatement(StatementType type) {
        this.authorType = null;
        this.statementType = type;
    }

    public AuthorType getAuthorType() {
        return this.authorType;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getPassWord() {
        return this.password;
    }

    public void setPassWord(String password) {
        this.password = password;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String[] getPrivilegeList() {
        return this.privilegeList;
    }

    public void setPrivilegeList(String[] privilegeList) {
        this.privilegeList = privilegeList;
    }

    public List<PartialPath> getNodeNameList() {
        return this.nodeNameList != null ? this.nodeNameList : Collections.emptyList();
    }

    public void setNodeNameList(List<PartialPath> nodeNameList) {
        this.nodeNameList = nodeNameList;
    }

    public boolean getGrantOpt() {
        return this.grantOpt;
    }

    public void setGrantOpt(boolean grantOpt) {
        this.grantOpt = grantOpt;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitAuthor(this, context);
    }

    @Override
    public QueryType getQueryType() {
        QueryType queryType;
        switch (this.authorType) {
            case DROP_ROLE: 
            case DROP_USER: 
            case GRANT_ROLE: 
            case GRANT_USER: 
            case CREATE_ROLE: 
            case CREATE_USER: 
            case REVOKE_ROLE: 
            case REVOKE_USER: 
            case UPDATE_USER: 
            case GRANT_USER_ROLE: 
            case REVOKE_USER_ROLE: {
                queryType = QueryType.WRITE;
                break;
            }
            case LIST_USER_PRIVILEGE: 
            case LIST_ROLE_PRIVILEGE: 
            case LIST_USER: 
            case LIST_ROLE: {
                queryType = QueryType.READ;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown authorType: " + (Object)((Object)this.authorType));
            }
        }
        return queryType;
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.nodeNameList != null ? this.nodeNameList : Collections.emptyList();
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        switch (this.authorType) {
            case CREATE_USER: {
                if (AuthorityChecker.SUPER_USER.equals(this.userName)) {
                    return AuthorityChecker.getTSStatus(false, "Cannot create user has same name with admin user");
                }
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
                }
                return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.MANAGE_USER.ordinal()), PrivilegeType.MANAGE_USER);
            }
            case UPDATE_USER: {
                if (AuthorityChecker.SUPER_USER.equals(userName) || this.userName.equals(userName)) {
                    return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
                }
                return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.MANAGE_USER.ordinal()), PrivilegeType.MANAGE_USER);
            }
            case DROP_USER: {
                if (AuthorityChecker.SUPER_USER.equals(this.userName) || this.userName.equals(userName)) {
                    return AuthorityChecker.getTSStatus(false, "Cannot drop admin user or yourself");
                }
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
                }
                return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.MANAGE_USER.ordinal()), PrivilegeType.MANAGE_USER);
            }
            case LIST_USER: {
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
                }
                return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.MANAGE_USER.ordinal()), PrivilegeType.MANAGE_USER);
            }
            case LIST_USER_PRIVILEGE: {
                if (AuthorityChecker.SUPER_USER.equals(userName) || userName.equals(this.userName)) {
                    return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
                }
                return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.MANAGE_USER.ordinal()), PrivilegeType.MANAGE_USER);
            }
            case LIST_ROLE_PRIVILEGE: {
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
                }
                if (!AuthorityChecker.checkRole(userName, this.roleName)) {
                    return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.MANAGE_ROLE.ordinal()), PrivilegeType.MANAGE_ROLE);
                }
                return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            }
            case LIST_ROLE: {
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
                }
                if (this.userName != null && userName.equals(this.userName)) {
                    return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
                }
                return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.MANAGE_ROLE.ordinal()), PrivilegeType.MANAGE_ROLE);
            }
            case CREATE_ROLE: {
                if (AuthorityChecker.SUPER_USER.equals(this.roleName)) {
                    return AuthorityChecker.getTSStatus(false, "Cannot create role has same name with admin user");
                }
            }
            case DROP_ROLE: 
            case GRANT_USER_ROLE: 
            case REVOKE_USER_ROLE: {
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
                }
                return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.MANAGE_ROLE.ordinal()), PrivilegeType.MANAGE_ROLE);
            }
            case GRANT_USER: 
            case REVOKE_USER: {
                if (AuthorityChecker.SUPER_USER.equals(this.userName)) {
                    return AuthorityChecker.getTSStatus(false, "Cannot grant/revoke privileges of admin user");
                }
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
                }
                return AuthorityChecker.getOptTSStatus(AuthorityChecker.checkGrantOption(userName, this.privilegeList, this.nodeNameList), "Has no permission to execute " + (Object)((Object)this.authorType) + ", please ensure you have these privileges and the grant option is TRUE when granted");
            }
            case GRANT_ROLE: 
            case REVOKE_ROLE: {
                if (AuthorityChecker.SUPER_USER.equals(userName)) {
                    return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
                }
                return AuthorityChecker.getOptTSStatus(AuthorityChecker.checkGrantOption(userName, this.privilegeList, this.nodeNameList), "Has no permission to execute " + (Object)((Object)this.authorType) + ", please ensure you have these privileges and the grant option is TRUE when granted");
            }
        }
        throw new IllegalArgumentException("Unknown authorType: " + (Object)((Object)this.authorType));
    }
}

