/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.converter;

import java.time.ZoneId;
import java.util.Optional;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.protocol.session.InternalClientSession;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.lock.DataNodeSchemaLockManager;
import org.apache.iotdb.db.queryengine.plan.analyze.lock.SchemaLockType;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.queryengine.plan.statement.pipe.PipeEnrichedStatement;
import org.apache.iotdb.db.storageengine.load.converter.LoadConvertedInsertTabletStatementExceptionVisitor;
import org.apache.iotdb.db.storageengine.load.converter.LoadConvertedInsertTabletStatementTSStatusVisitor;
import org.apache.iotdb.db.storageengine.load.converter.LoadTreeStatementDataTypeConvertExecutionVisitor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileDataTypeConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileDataTypeConverter.class);
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    public static final LoadConvertedInsertTabletStatementTSStatusVisitor STATEMENT_STATUS_VISITOR = new LoadConvertedInsertTabletStatementTSStatusVisitor();
    public static final LoadConvertedInsertTabletStatementExceptionVisitor STATEMENT_EXCEPTION_VISITOR = new LoadConvertedInsertTabletStatementExceptionVisitor();
    private final boolean isGeneratedByPipe;
    private final MPPQueryContext context;
    private final LoadTreeStatementDataTypeConvertExecutionVisitor treeStatementDataTypeConvertExecutionVisitor = new LoadTreeStatementDataTypeConvertExecutionVisitor(this::executeForTreeModel);

    public LoadTsFileDataTypeConverter(MPPQueryContext context, boolean isGeneratedByPipe) {
        this.context = context;
        this.isGeneratedByPipe = isGeneratedByPipe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<TSStatus> convertForTreeModel(LoadTsFileStatement loadTsFileTreeStatement) {
        DataNodeSchemaLockManager.getInstance().releaseReadLock(this.context);
        try {
            Optional<TSStatus> optional = loadTsFileTreeStatement.accept(this.treeStatementDataTypeConvertExecutionVisitor, null);
            return optional;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to convert data types for load statement {}.", (Object)loadTsFileTreeStatement, (Object)e);
            Optional<TSStatus> optional = Optional.of(new TSStatus(TSStatusCode.LOAD_FILE_ERROR.getStatusCode()).setMessage(e.getMessage()));
            return optional;
        }
        finally {
            DataNodeSchemaLockManager.getInstance().takeReadLock(this.context, SchemaLockType.VALIDATE_VS_DELETION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSStatus executeForTreeModel(Statement statement) {
        boolean needToCreateSession;
        boolean bl = needToCreateSession = SESSION_MANAGER.getCurrSession() == null;
        if (needToCreateSession) {
            InternalClientSession session = new InternalClientSession(String.format("%s_%s", LoadTsFileDataTypeConverter.class.getSimpleName(), Thread.currentThread().getName()));
            session.setUsername(AuthorityChecker.SUPER_USER);
            session.setClientVersion(IoTDBConstant.ClientVersion.V_1_0);
            session.setZoneId(ZoneId.systemDefault());
            SESSION_MANAGER.registerSession(session);
        }
        try {
            TSStatus tSStatus = Coordinator.getInstance().executeForTreeModel((Statement)(this.isGeneratedByPipe ? new PipeEnrichedStatement((Statement)statement) : statement), (long)LoadTsFileDataTypeConverter.SESSION_MANAGER.requestQueryId(), (SessionInfo)LoadTsFileDataTypeConverter.SESSION_MANAGER.getSessionInfo((IClientSession)LoadTsFileDataTypeConverter.SESSION_MANAGER.getCurrSession()), (String)"", (IPartitionFetcher)ClusterPartitionFetcher.getInstance(), (ISchemaFetcher)ClusterSchemaFetcher.getInstance(), (long)IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold(), (boolean)false).status;
            return tSStatus;
        }
        finally {
            if (needToCreateSession) {
                SESSION_MANAGER.removeCurrSession();
            }
        }
    }

    public boolean isSuccessful(TSStatus status) {
        return status != null && (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || status.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() || status.getCode() == TSStatusCode.LOAD_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode());
    }
}

