/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.container.query;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.container.TsFileInsertionDataContainer;
import org.apache.iotdb.db.pipe.event.common.tsfile.container.query.TsFileInsertionQueryDataTabletIterator;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.util.ModsOperationUtil;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.db.pipe.resource.tsfile.PipeTsFileResourceManager;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.read.TsFileDeviceIterator;
import org.apache.tsfile.read.TsFileReader;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.expression.IExpression;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileInsertionQueryDataContainer
extends TsFileInsertionDataContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileInsertionQueryDataContainer.class);
    private final PipeMemoryBlock allocatedMemoryBlock;
    private final TsFileReader tsFileReader;
    private final Iterator<Map.Entry<IDeviceID, List<String>>> deviceMeasurementsMapIterator;
    private final Map<IDeviceID, Boolean> deviceIsAlignedMap;
    private final Map<String, TSDataType> measurementDataTypeMap;

    public TsFileInsertionQueryDataContainer(File tsFile, PipePattern pattern, long startTime, long endTime) throws IOException {
        this(null, 0L, tsFile, pattern, startTime, endTime, null, null, false);
    }

    public TsFileInsertionQueryDataContainer(String pipeName, long creationTime, File tsFile, PipePattern pattern, long startTime, long endTime, PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent, boolean isWithMod) throws IOException {
        this(pipeName, creationTime, tsFile, pattern, startTime, endTime, pipeTaskMeta, sourceEvent, null, isWithMod);
    }

    public TsFileInsertionQueryDataContainer(String pipeName, long creationTime, File tsFile, PipePattern pattern, long startTime, long endTime, PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent, Map<IDeviceID, Boolean> deviceIsAlignedMap, boolean isWithMod) throws IOException {
        super(pipeName, creationTime, pattern, startTime, endTime, pipeTaskMeta, sourceEvent);
        try {
            Map<IDeviceID, List<String>> deviceMeasurementsMap;
            this.currentModifications = isWithMod ? ModsOperationUtil.loadModificationsFromTsFile(tsFile) : PatternTreeMapFactory.getModsPatternTreeMap();
            this.allocatedMemoryBlockForModifications = PipeDataNodeResourceManager.memory().forceAllocateForTabletWithRetry(this.currentModifications.ramBytesUsed());
            PipeTsFileResourceManager tsFileResourceManager = PipeDataNodeResourceManager.tsfile();
            long memoryRequiredInBytes = PipeConfig.getInstance().getPipeMemoryAllocateForTsFileSequenceReaderInBytes();
            this.tsFileSequenceReader = new TsFileSequenceReader(tsFile.getPath(), true, true);
            this.tsFileReader = new TsFileReader(this.tsFileSequenceReader);
            if (tsFileResourceManager.cacheObjectsIfAbsent(tsFile)) {
                this.deviceIsAlignedMap = Objects.nonNull(deviceIsAlignedMap) ? deviceIsAlignedMap : tsFileResourceManager.getDeviceIsAlignedMapFromCache(tsFile, true);
                this.measurementDataTypeMap = tsFileResourceManager.getMeasurementDataTypeMapFromCache(tsFile);
                deviceMeasurementsMap = tsFileResourceManager.getDeviceMeasurementsMapFromCache(tsFile);
            } else {
                Set<IDeviceID> devices;
                if (Objects.isNull(deviceIsAlignedMap)) {
                    this.deviceIsAlignedMap = this.readDeviceIsAlignedMap();
                    memoryRequiredInBytes += PipeMemoryWeightUtil.memoryOfIDeviceId2Bool(this.deviceIsAlignedMap);
                    devices = this.filterDevicesByPattern(this.deviceIsAlignedMap.keySet());
                } else {
                    this.deviceIsAlignedMap = deviceIsAlignedMap;
                    devices = deviceIsAlignedMap.keySet();
                }
                this.measurementDataTypeMap = this.readFilteredFullPathDataTypeMap(devices);
                memoryRequiredInBytes += PipeMemoryWeightUtil.memoryOfStr2TSDataType(this.measurementDataTypeMap);
                deviceMeasurementsMap = this.readFilteredDeviceMeasurementsMap(devices);
                memoryRequiredInBytes += PipeMemoryWeightUtil.memoryOfIDeviceID2StrList(deviceMeasurementsMap);
            }
            this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().forceAllocate(memoryRequiredInBytes);
            Iterator<Map.Entry<IDeviceID, List<String>>> iterator = deviceMeasurementsMap.entrySet().iterator();
            while (isWithMod && iterator.hasNext()) {
                Map.Entry<IDeviceID, List<String>> entry = iterator.next();
                IDeviceID deviceId = entry.getKey();
                List<String> measurements = entry.getValue();
                if (deviceId == null) {
                    LOGGER.warn("Found null deviceId, removing entry");
                    iterator.remove();
                    continue;
                }
                if (measurements == null || measurements.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                if (!this.currentModifications.isEmpty()) {
                    measurements.removeIf(measurement -> {
                        if (measurement == null) {
                            return true;
                        }
                        try {
                            TimeseriesMetadata meta = this.tsFileSequenceReader.readTimeseriesMetadata(deviceId, measurement, true);
                            return ModsOperationUtil.isAllDeletedByMods(deviceId.toString(), measurement, meta.getStatistics().getStartTime(), meta.getStatistics().getEndTime(), (PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>)this.currentModifications);
                        }
                        catch (IOException e) {
                            LOGGER.warn("Failed to read metadata for deviceId: {}, measurement: {}, removing", new Object[]{deviceId, measurement, e});
                            return true;
                        }
                    });
                }
                if (!measurements.isEmpty()) continue;
                iterator.remove();
            }
            this.deviceMeasurementsMapIterator = this.filterDeviceMeasurementsMapByPattern(deviceMeasurementsMap).entrySet().iterator();
            this.tsFileSequenceReader.clearCachedDeviceMetadata();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    private Map<IDeviceID, List<String>> filterDeviceMeasurementsMapByPattern(Map<IDeviceID, List<String>> originalDeviceMeasurementsMap) {
        HashMap<IDeviceID, List<String>> filteredDeviceMeasurementsMap = new HashMap<IDeviceID, List<String>>();
        for (Map.Entry<IDeviceID, List<String>> entry : originalDeviceMeasurementsMap.entrySet()) {
            String deviceId = ((PlainDeviceID)entry.getKey()).toStringID();
            if (Objects.isNull(this.pattern) || this.pattern.isRoot() || this.pattern.coversDevice(deviceId)) {
                if (entry.getValue().isEmpty()) continue;
                filteredDeviceMeasurementsMap.put((IDeviceID)new PlainDeviceID(deviceId), entry.getValue());
                continue;
            }
            if (!this.pattern.mayOverlapWithDevice(deviceId)) continue;
            ArrayList<String> filteredMeasurements = new ArrayList<String>();
            for (String measurement : entry.getValue()) {
                if (!this.pattern.matchesMeasurement(deviceId, measurement)) continue;
                filteredMeasurements.add(measurement);
            }
            if (filteredMeasurements.isEmpty()) continue;
            filteredDeviceMeasurementsMap.put((IDeviceID)new PlainDeviceID(deviceId), filteredMeasurements);
        }
        return filteredDeviceMeasurementsMap;
    }

    private Map<IDeviceID, Boolean> readDeviceIsAlignedMap() throws IOException {
        HashMap<IDeviceID, Boolean> deviceIsAlignedResultMap = new HashMap<IDeviceID, Boolean>();
        TsFileDeviceIterator deviceIsAlignedIterator = this.tsFileSequenceReader.getAllDevicesIteratorWithIsAligned();
        while (deviceIsAlignedIterator.hasNext()) {
            Pair deviceIsAlignedPair = deviceIsAlignedIterator.next();
            deviceIsAlignedResultMap.put((IDeviceID)deviceIsAlignedPair.getLeft(), (Boolean)deviceIsAlignedPair.getRight());
        }
        return deviceIsAlignedResultMap;
    }

    private Set<IDeviceID> filterDevicesByPattern(Set<IDeviceID> devices) {
        if (Objects.isNull(this.pattern) || this.pattern.isRoot()) {
            return devices;
        }
        HashSet<IDeviceID> filteredDevices = new HashSet<IDeviceID>();
        for (IDeviceID device : devices) {
            String deviceId = ((PlainDeviceID)device).toStringID();
            if (!this.pattern.coversDevice(deviceId) && !this.pattern.mayOverlapWithDevice(deviceId)) continue;
            filteredDevices.add(device);
        }
        return filteredDevices;
    }

    private Map<String, TSDataType> readFilteredFullPathDataTypeMap(Set<IDeviceID> devices) throws IOException {
        HashMap<String, TSDataType> result = new HashMap<String, TSDataType>();
        for (IDeviceID device : devices) {
            this.tsFileSequenceReader.readDeviceMetadata(device).values().forEach(timeseriesMetadata -> result.put(((PlainDeviceID)device).toStringID() + "." + timeseriesMetadata.getMeasurementId(), timeseriesMetadata.getTsDataType()));
        }
        return result;
    }

    private Map<IDeviceID, List<String>> readFilteredDeviceMeasurementsMap(Set<IDeviceID> devices) throws IOException {
        HashMap<IDeviceID, List<String>> result = new HashMap<IDeviceID, List<String>>();
        for (IDeviceID device : devices) {
            this.tsFileSequenceReader.readDeviceMetadata(device).values().forEach(timeseriesMetadata -> result.computeIfAbsent(device, d -> new ArrayList()).add(timeseriesMetadata.getMeasurementId()));
        }
        return result;
    }

    @Override
    public Iterable<TabletInsertionEvent> toTabletInsertionEvents() {
        if (this.tabletInsertionIterable == null) {
            this.tabletInsertionIterable = () -> new Iterator<TabletInsertionEvent>(){
                private TsFileInsertionQueryDataTabletIterator tabletIterator = null;

                @Override
                public boolean hasNext() {
                    boolean hasNext = false;
                    while (this.tabletIterator == null || !this.tabletIterator.hasNext()) {
                        if (!TsFileInsertionQueryDataContainer.this.deviceMeasurementsMapIterator.hasNext()) {
                            if (TsFileInsertionQueryDataContainer.this.parseStartTimeRecorded && !TsFileInsertionQueryDataContainer.this.parseEndTimeRecorded) {
                                TsFileInsertionQueryDataContainer.this.recordParseEndTime();
                            }
                            TsFileInsertionQueryDataContainer.this.close();
                            return false;
                        }
                        Map.Entry entry = (Map.Entry)TsFileInsertionQueryDataContainer.this.deviceMeasurementsMapIterator.next();
                        try {
                            this.tabletIterator = new TsFileInsertionQueryDataTabletIterator(TsFileInsertionQueryDataContainer.this.tsFileReader, TsFileInsertionQueryDataContainer.this.measurementDataTypeMap, ((PlainDeviceID)entry.getKey()).toStringID(), (List)entry.getValue(), (IExpression)TsFileInsertionQueryDataContainer.this.timeFilterExpression, TsFileInsertionQueryDataContainer.this.allocatedMemoryBlockForTablet, (PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>)TsFileInsertionQueryDataContainer.this.currentModifications);
                        }
                        catch (Exception e) {
                            TsFileInsertionQueryDataContainer.this.close();
                            throw new PipeException("failed to create TsFileInsertionDataTabletIterator", (Throwable)e);
                        }
                    }
                    hasNext = true;
                    if (!TsFileInsertionQueryDataContainer.this.parseStartTimeRecorded) {
                        TsFileInsertionQueryDataContainer.this.recordParseStartTime();
                    }
                    return hasNext;
                }

                @Override
                public TabletInsertionEvent next() {
                    PipeRawTabletInsertionEvent next;
                    if (!this.hasNext()) {
                        TsFileInsertionQueryDataContainer.this.close();
                        throw new NoSuchElementException();
                    }
                    Tablet tablet = this.tabletIterator.next();
                    TsFileInsertionQueryDataContainer.this.recordTabletMetrics(tablet);
                    boolean isAligned = TsFileInsertionQueryDataContainer.this.deviceIsAlignedMap.getOrDefault(new PlainDeviceID(tablet.deviceId), false);
                    if (!this.hasNext()) {
                        next = new PipeRawTabletInsertionEvent(tablet, isAligned, TsFileInsertionQueryDataContainer.this.sourceEvent != null ? TsFileInsertionQueryDataContainer.this.sourceEvent.getPipeName() : null, TsFileInsertionQueryDataContainer.this.sourceEvent != null ? TsFileInsertionQueryDataContainer.this.sourceEvent.getCreationTime() : 0L, TsFileInsertionQueryDataContainer.this.pipeTaskMeta, TsFileInsertionQueryDataContainer.this.sourceEvent, true);
                        TsFileInsertionQueryDataContainer.this.close();
                    } else {
                        next = new PipeRawTabletInsertionEvent(tablet, isAligned, TsFileInsertionQueryDataContainer.this.sourceEvent != null ? TsFileInsertionQueryDataContainer.this.sourceEvent.getPipeName() : null, TsFileInsertionQueryDataContainer.this.sourceEvent != null ? TsFileInsertionQueryDataContainer.this.sourceEvent.getCreationTime() : 0L, TsFileInsertionQueryDataContainer.this.pipeTaskMeta, TsFileInsertionQueryDataContainer.this.sourceEvent, false);
                    }
                    return next;
                }
            };
        }
        return this.tabletInsertionIterable;
    }

    @Override
    public void close() {
        try {
            if (this.tsFileReader != null) {
                this.tsFileReader.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close TsFileReader", (Throwable)e);
        }
        super.close();
        if (this.allocatedMemoryBlock != null) {
            this.allocatedMemoryBlock.close();
        }
    }
}

