/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.balance.impl;

import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.bifromq.basekv.balance.AwaitBalance;
import org.apache.bifromq.basekv.balance.BalanceNow;
import org.apache.bifromq.basekv.balance.BalanceResult;
import org.apache.bifromq.basekv.balance.NoNeedBalance;
import org.apache.bifromq.basekv.balance.StoreBalancer;
import org.apache.bifromq.basekv.balance.command.BalanceCommand;
import org.apache.bifromq.basekv.balance.command.QuitCommand;
import org.apache.bifromq.basekv.balance.util.CommandUtil;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.raft.proto.RaftNodeStatus;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.basekv.utils.DescriptorUtil;
import org.apache.bifromq.basekv.utils.EffectiveEpoch;
import org.apache.bifromq.basekv.utils.EffectiveRoute;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.basekv.utils.RangeLeader;

public class RedundantRangeRemovalBalancer
extends StoreBalancer {
    private final Supplier<Long> millisSource;
    private final long suspicionDurationMillis;
    private final AtomicReference<PendingQuitCommand> pendingQuitCommand = new AtomicReference();

    public RedundantRangeRemovalBalancer(String clusterId, String localStoreId, Duration suspicionDuration, Supplier<Long> millisSource) {
        super(clusterId, localStoreId);
        this.suspicionDurationMillis = suspicionDuration.toMillis();
        this.millisSource = millisSource;
    }

    public void update(Set<KVRangeStoreDescriptor> landscape) {
        NavigableMap landscapeByEpoch = DescriptorUtil.organizeByEpoch(landscape);
        if (landscapeByEpoch.isEmpty()) {
            this.pendingQuitCommand.set(null);
            return;
        }
        boolean scheduled = this.cleanupRedundantEpoch(landscapeByEpoch);
        if (scheduled) {
            return;
        }
        Map.Entry oldestEntry = landscapeByEpoch.firstEntry();
        EffectiveEpoch effectiveEpoch = new EffectiveEpoch(((Long)oldestEntry.getKey()).longValue(), (Set)oldestEntry.getValue());
        scheduled = this.cleanupIdConflictRange(effectiveEpoch);
        if (scheduled) {
            return;
        }
        scheduled = this.cleanupBoundaryConflictRange(effectiveEpoch);
        if (scheduled) {
            return;
        }
        scheduled = this.cleanupZombieRange(effectiveEpoch);
        if (!scheduled && this.pendingQuitCommand.get() != null) {
            this.log.debug("No redundant range found, clear pending quit command");
            this.pendingQuitCommand.set(null);
        }
    }

    public BalanceResult balance() {
        PendingQuitCommand current = this.pendingQuitCommand.get();
        if (current != null) {
            long nowMillis = this.millisSource.get();
            if (nowMillis > current.triggerTime) {
                this.pendingQuitCommand.set(null);
                return BalanceNow.of((BalanceCommand)current.quitCmd);
            }
            return AwaitBalance.of((Duration)Duration.ofMillis(current.triggerTime - nowMillis));
        }
        return NoNeedBalance.INSTANCE;
    }

    private boolean cleanupRedundantEpoch(NavigableMap<Long, Set<KVRangeStoreDescriptor>> landscapeByEpoch) {
        if (landscapeByEpoch.size() > 1) {
            Set<KVRangeStoreDescriptor> storeDescriptors = landscapeByEpoch.lastEntry().getValue();
            for (KVRangeStoreDescriptor storeDescriptor : storeDescriptors) {
                if (!storeDescriptor.getId().equals(this.localStoreId)) continue;
                for (KVRangeDescriptor rangeDescriptor : storeDescriptor.getRangesList()) {
                    if (rangeDescriptor.getRole() != RaftNodeStatus.Leader) continue;
                    this.log.debug("Schedule command to remove epoch-conflict range: id={}, boundary={}", (Object)KVRangeIdUtil.toString((KVRangeId)rangeDescriptor.getId()), (Object)rangeDescriptor.getBoundary());
                    this.pendingQuitCommand.set(new PendingQuitCommand(CommandUtil.quit((String)this.localStoreId, (KVRangeDescriptor)rangeDescriptor), this.randomSuspicionTimeout()));
                    return true;
                }
            }
        }
        return false;
    }

    private boolean cleanupIdConflictRange(EffectiveEpoch effectiveEpoch) {
        Map<KVRangeId, NavigableSet<RangeLeader>> conflictingRanges = this.findConflictingRanges(effectiveEpoch.storeDescriptors());
        if (!conflictingRanges.isEmpty()) {
            for (KVRangeId rangeId : conflictingRanges.keySet()) {
                NavigableSet<RangeLeader> rangeLeaders = conflictingRanges.get(rangeId);
                Iterator<RangeLeader> iterator = rangeLeaders.iterator();
                if (!iterator.hasNext()) continue;
                RangeLeader rangeLeader = iterator.next();
                if (!rangeLeader.storeId().equals(this.localStoreId)) {
                    return false;
                }
                this.log.warn("Schedule command to remove id-conflict range: id={}, boundary={}", (Object)KVRangeIdUtil.toString((KVRangeId)rangeLeader.descriptor().getId()), (Object)rangeLeader.descriptor().getBoundary());
                this.pendingQuitCommand.set(new PendingQuitCommand(CommandUtil.quit((String)this.localStoreId, (KVRangeDescriptor)rangeLeader.descriptor()), this.randomSuspicionTimeout()));
                return true;
            }
        }
        return false;
    }

    private boolean cleanupBoundaryConflictRange(EffectiveEpoch effectiveEpoch) {
        NavigableMap effectiveLeaders = DescriptorUtil.getEffectiveRoute((EffectiveEpoch)effectiveEpoch).leaderRanges();
        for (KVRangeStoreDescriptor storeDescriptor : effectiveEpoch.storeDescriptors()) {
            if (!storeDescriptor.getId().equals(this.localStoreId)) continue;
            for (KVRangeDescriptor rangeDescriptor : storeDescriptor.getRangesList()) {
                Boundary boundary;
                RangeLeader rangeLeader;
                if (rangeDescriptor.getRole() != RaftNodeStatus.Leader || (rangeLeader = (RangeLeader)effectiveLeaders.get(boundary = rangeDescriptor.getBoundary())) != null && rangeLeader.descriptor().getId().equals((Object)rangeDescriptor.getId())) continue;
                this.log.warn("Schedule command to remove boundary-conflict range: id={}, boundary={}", (Object)KVRangeIdUtil.toString((KVRangeId)rangeDescriptor.getId()), (Object)rangeDescriptor.getBoundary());
                this.pendingQuitCommand.set(new PendingQuitCommand(CommandUtil.quit((String)this.localStoreId, (KVRangeDescriptor)rangeDescriptor), this.randomSuspicionTimeout()));
                return true;
            }
        }
        return false;
    }

    private boolean cleanupZombieRange(EffectiveEpoch effectiveEpoch) {
        EffectiveRoute effectiveRoute = DescriptorUtil.getEffectiveRoute((EffectiveEpoch)effectiveEpoch);
        if (BoundaryUtil.isValidSplitSet(effectiveRoute.leaderRanges().navigableKeySet())) {
            HashMap<KVRangeId, KVRangeDescriptor> effectiveRangeMap = new HashMap<KVRangeId, KVRangeDescriptor>();
            for (RangeLeader rangeLeader : effectiveRoute.leaderRanges().values()) {
                effectiveRangeMap.put(rangeLeader.descriptor().getId(), rangeLeader.descriptor());
            }
            for (KVRangeStoreDescriptor storeDescriptor : effectiveEpoch.storeDescriptors()) {
                if (!storeDescriptor.getId().equals(this.localStoreId)) continue;
                for (KVRangeDescriptor rangeDescriptor : storeDescriptor.getRangesList()) {
                    if (!this.isZombieRange(rangeDescriptor, effectiveRangeMap)) continue;
                    this.log.debug("Schedule command to remove zombie range: id={}, boundary={}", (Object)KVRangeIdUtil.toString((KVRangeId)rangeDescriptor.getId()), (Object)rangeDescriptor.getBoundary());
                    this.pendingQuitCommand.set(new PendingQuitCommand((BalanceCommand)((QuitCommand.QuitCommandBuilder)((QuitCommand.QuitCommandBuilder)QuitCommand.builder().kvRangeId(rangeDescriptor.getId())).toStore(this.localStoreId)).build(), this.randomSuspicionTimeout()));
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isZombieRange(KVRangeDescriptor rangeDescriptor, Map<KVRangeId, KVRangeDescriptor> effectiveRange) {
        if (rangeDescriptor.getRole() != RaftNodeStatus.Candidate) {
            return false;
        }
        if (!effectiveRange.containsKey(rangeDescriptor.getId())) {
            return true;
        }
        KVRangeDescriptor effectiveRangeDescriptor = effectiveRange.get(rangeDescriptor.getId());
        HashSet allReplicas = Sets.newHashSet((Iterable)effectiveRangeDescriptor.getConfig().getVotersList());
        allReplicas.addAll(effectiveRangeDescriptor.getConfig().getLearnersList());
        allReplicas.addAll(effectiveRangeDescriptor.getConfig().getNextVotersList());
        allReplicas.addAll(effectiveRangeDescriptor.getConfig().getNextLearnersList());
        return !allReplicas.contains(this.localStoreId);
    }

    private Map<KVRangeId, NavigableSet<RangeLeader>> findConflictingRanges(Set<KVRangeStoreDescriptor> effectiveEpoch) {
        HashMap<KVRangeId, NavigableSet> leaderRangesByRangeId = new HashMap<KVRangeId, NavigableSet>();
        HashMap<KVRangeId, NavigableSet<RangeLeader>> conflictingRanges = new HashMap<KVRangeId, NavigableSet<RangeLeader>>();
        for (KVRangeStoreDescriptor storeDescriptor : effectiveEpoch) {
            for (KVRangeDescriptor rangeDescriptor : storeDescriptor.getRangesList()) {
                if (rangeDescriptor.getRole() != RaftNodeStatus.Leader) continue;
                KVRangeId rangeId = rangeDescriptor.getId();
                SortedSet rangeLeaders = leaderRangesByRangeId.computeIfAbsent(rangeId, k -> new TreeSet<RangeLeader>(Comparator.comparing(RangeLeader::storeId, String::compareTo).reversed()));
                rangeLeaders.add(new RangeLeader(storeDescriptor.getId(), rangeDescriptor));
            }
        }
        for (KVRangeId rangeId : leaderRangesByRangeId.keySet()) {
            NavigableSet rangeLeaders = (NavigableSet)leaderRangesByRangeId.get(rangeId);
            RangeLeader firstRangeLeader = (RangeLeader)rangeLeaders.first();
            ClusterConfig firstLeaderClusterConfig = firstRangeLeader.descriptor().getConfig();
            if (rangeLeaders.size() <= 1) continue;
            NavigableSet<RangeLeader> restRangeLeaders = rangeLeaders.tailSet(firstRangeLeader, false);
            for (RangeLeader restRangeLeader : restRangeLeaders) {
                ClusterConfig restLeaderClusterConfig = restRangeLeader.descriptor().getConfig();
                if (!this.isDisjoint(firstLeaderClusterConfig, restLeaderClusterConfig)) continue;
                conflictingRanges.put(rangeId, rangeLeaders);
            }
        }
        return conflictingRanges;
    }

    private boolean isDisjoint(ClusterConfig firstConfig, ClusterConfig secondConfig) {
        HashSet firstVoters = Sets.newHashSet((Iterable)firstConfig.getVotersList());
        HashSet secondVoters = Sets.newHashSet((Iterable)secondConfig.getVotersList());
        HashSet firstNextVoters = Sets.newHashSet((Iterable)firstConfig.getNextVotersList());
        HashSet secondNextVoters = Sets.newHashSet((Iterable)secondConfig.getNextVotersList());
        return Collections.disjoint(firstVoters, secondVoters) && Collections.disjoint(firstNextVoters, secondNextVoters);
    }

    private long randomSuspicionTimeout() {
        return this.millisSource.get() + ThreadLocalRandom.current().nextLong(this.suspicionDurationMillis, this.suspicionDurationMillis * 2L);
    }

    private record PendingQuitCommand(BalanceCommand quitCmd, long triggerTime) {
    }
}

