/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.wal;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.protobuf.Parser;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.baseenv.ZeroCopyParser;
import org.apache.bifromq.basekv.proto.KVRangeCommand;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeSnapshot;
import org.apache.bifromq.basekv.raft.ILogEntryIterator;
import org.apache.bifromq.basekv.raft.IRaftNode;
import org.apache.bifromq.basekv.raft.IRaftStateStore;
import org.apache.bifromq.basekv.raft.RaftConfig;
import org.apache.bifromq.basekv.raft.RaftNode;
import org.apache.bifromq.basekv.raft.event.CommitEvent;
import org.apache.bifromq.basekv.raft.event.ElectionEvent;
import org.apache.bifromq.basekv.raft.event.RaftEvent;
import org.apache.bifromq.basekv.raft.event.SnapshotRestoredEvent;
import org.apache.bifromq.basekv.raft.event.StatusChangedEvent;
import org.apache.bifromq.basekv.raft.event.SyncStateChangedEvent;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.raft.proto.LogEntry;
import org.apache.bifromq.basekv.raft.proto.RaftMessage;
import org.apache.bifromq.basekv.raft.proto.RaftNodeStatus;
import org.apache.bifromq.basekv.raft.proto.RaftNodeSyncState;
import org.apache.bifromq.basekv.store.exception.KVRangeException;
import org.apache.bifromq.basekv.store.wal.IKVRangeWAL;
import org.apache.bifromq.basekv.store.wal.IKVRangeWALStore;
import org.apache.bifromq.basekv.store.wal.IKVRangeWALSubscriber;
import org.apache.bifromq.basekv.store.wal.IKVRangeWALSubscription;
import org.apache.bifromq.basekv.store.wal.KVRangeWALSubscription;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

public class KVRangeWAL
implements IKVRangeWAL,
IRaftNode.ISnapshotInstaller {
    private final Logger log;
    private final long maxFetchBytes;
    private final PublishSubject<SnapshotRestoredEvent> snapRestoreEventPublisher = PublishSubject.create();
    private final BehaviorSubject<CommitEvent> commitIndexSubject = BehaviorSubject.create();
    private final PublishSubject<IKVRangeWAL.RestoreSnapshotTask> snapRestoreTaskPublisher = PublishSubject.create();
    private final BehaviorSubject<ElectionEvent> electionPublisher = BehaviorSubject.create();
    private final BehaviorSubject<RaftNodeStatus> statusPublisher = BehaviorSubject.create();
    private final PublishSubject<Map<String, List<RaftMessage>>> raftMessagesPublisher = PublishSubject.create();
    private final BehaviorSubject<Map<String, RaftNodeSyncState>> syncStatePublisher = BehaviorSubject.createDefault(Collections.emptyMap());
    private final KVRangeId rangeId;
    private final String localId;
    private final IKVRangeWALStore walStore;
    private final IRaftNode raftNode;
    private final String[] tags;

    public KVRangeWAL(String clusterId, String localId, KVRangeId rangeId, IKVRangeWALStore walStore, RaftConfig raftConfig, int maxFetchBytes) {
        this.rangeId = rangeId;
        this.localId = localId;
        this.maxFetchBytes = maxFetchBytes;
        this.walStore = walStore;
        this.tags = new String[]{"clusterId", clusterId, "storeId", localId, "rangeId", KVRangeIdUtil.toString((KVRangeId)rangeId)};
        this.log = MDCLogger.getLogger(KVRangeWAL.class, (String[])this.tags);
        this.raftNode = new RaftNode(raftConfig, (IRaftStateStore)walStore, EnvProvider.INSTANCE.newThreadFactory("wal-raft-executor-" + KVRangeIdUtil.toString((KVRangeId)rangeId)), this.tags);
    }

    @Override
    public String storeId() {
        return this.localId;
    }

    @Override
    public KVRangeId rangeId() {
        return this.rangeId;
    }

    @Override
    public boolean isLeader() {
        return this.currentState() == RaftNodeStatus.Leader;
    }

    @Override
    public RaftNodeStatus currentState() {
        return (RaftNodeStatus)this.statusPublisher.getValue();
    }

    @Override
    public Observable<RaftNodeStatus> state() {
        return this.statusPublisher;
    }

    @Override
    public Optional<String> currentLeader() {
        ElectionEvent latestElection = (ElectionEvent)this.electionPublisher.getValue();
        if (latestElection == null) {
            return Optional.empty();
        }
        return Optional.of(latestElection.leaderId);
    }

    @Override
    public Observable<ElectionEvent> election() {
        return this.electionPublisher.distinctUntilChanged();
    }

    @Override
    public Observable<Map<String, RaftNodeSyncState>> replicationStatus() {
        return this.syncStatePublisher.distinctUntilChanged();
    }

    @Override
    public IKVRangeWALSubscription subscribe(long lastFetchedIndex, IKVRangeWALSubscriber subscriber, Executor executor) {
        return new KVRangeWALSubscription(this.maxFetchBytes, this, (Observable<CommitEvent>)this.commitIndexSubject, lastFetchedIndex, subscriber, executor, this.tags);
    }

    @Override
    public CompletableFuture<LogEntry> once(long lastFetchedIndex, final Predicate<LogEntry> condition, Executor executor) {
        final CompletableFuture<LogEntry> onDone = new CompletableFuture<LogEntry>();
        KVRangeWALSubscription walSub = new KVRangeWALSubscription(this.maxFetchBytes, this, (Observable<CommitEvent>)this.commitIndexSubject, lastFetchedIndex, new IKVRangeWALSubscriber(){

            @Override
            public CompletableFuture<Void> apply(LogEntry log, boolean isLeader) {
                try {
                    if (condition.test(log)) {
                        onDone.complete(log);
                    }
                }
                catch (Throwable e) {
                    onDone.completeExceptionally(e);
                }
                return CompletableFuture.completedFuture(null);
            }

            @Override
            public CompletableFuture<Void> restore(KVRangeSnapshot requested, String leader, IKVRangeWALSubscriber.IAfterRestoredCallback callback) {
                callback.call(null, new KVRangeException("Canceled once"));
                return CompletableFuture.failedFuture(new KVRangeException("Canceled once"));
            }
        }, executor, this.tags);
        ((CompletableFuture)onDone.exceptionally(e -> null)).thenComposeAsync(v -> walSub.stop(), executor);
        return onDone;
    }

    @Override
    public CompletableFuture<Long> propose(KVRangeCommand command) {
        return this.raftNode.propose(command.toByteString());
    }

    @Override
    public Observable<CommitEvent> commitIndex() {
        return this.commitIndexSubject;
    }

    @Override
    public CompletableFuture<ILogEntryIterator> retrieveCommitted(long fromIndex, long maxSize) {
        return this.raftNode.retrieveCommitted(fromIndex, maxSize);
    }

    @Override
    public CompletableFuture<Long> readIndex() {
        return this.raftNode.readIndex();
    }

    @Override
    public CompletableFuture<Void> transferLeadership(String peerId) {
        return this.raftNode.transferLeadership(peerId);
    }

    @Override
    public boolean stepDown() {
        return this.raftNode.stepDown();
    }

    @Override
    public CompletableFuture<Void> changeClusterConfig(String correlateId, Set<String> voters, Set<String> learners) {
        return this.raftNode.changeClusterConfig(correlateId, voters, learners);
    }

    @Override
    public KVRangeSnapshot latestSnapshot() {
        return (KVRangeSnapshot)ZeroCopyParser.parse((ByteString)this.raftNode.latestSnapshot(), (Parser)KVRangeSnapshot.parser());
    }

    @Override
    public ClusterConfig latestClusterConfig() {
        return this.raftNode.latestClusterConfig();
    }

    @Override
    public CompletableFuture<Void> compact(KVRangeSnapshot snapshot) {
        return this.raftNode.compact(snapshot.toByteString(), snapshot.getLastAppliedIndex());
    }

    @Override
    public Observable<IKVRangeWAL.RestoreSnapshotTask> snapshotRestoreTask() {
        return this.snapRestoreTaskPublisher;
    }

    @Override
    public Observable<Map<String, List<RaftMessage>>> peerMessages() {
        return this.raftMessagesPublisher;
    }

    @Override
    public CompletableFuture<Void> recover() {
        return this.raftNode.recover();
    }

    @Override
    public long logDataSize() {
        return this.walStore.size();
    }

    @Override
    public void receivePeerMessages(String fromPeer, List<RaftMessage> messages) {
        messages.forEach(m -> this.raftNode.receive(fromPeer, m));
    }

    @Override
    public void tick() {
        this.raftNode.tick();
    }

    @Override
    public void start() {
        this.log.debug("Starting KVRangeWAL");
        this.raftNode.start(this::sendRaftMessages, this::onRaftEvent, (IRaftNode.ISnapshotInstaller)this);
        this.statusPublisher.onNext((Object)this.raftNode.status());
    }

    @Override
    public CompletableFuture<Void> close() {
        this.log.debug("Closing KVRangeWAL");
        this.raftMessagesPublisher.onComplete();
        this.commitIndexSubject.onComplete();
        this.snapRestoreTaskPublisher.onComplete();
        this.electionPublisher.onComplete();
        this.syncStatePublisher.onComplete();
        return ((CompletableFuture)this.raftNode.stop().exceptionally(e -> {
            this.log.error("Raft node stop error", e);
            return null;
        })).whenComplete((v, e) -> this.log.debug("KVRangeWAL closed"));
    }

    @Override
    public CompletableFuture<Void> destroy() {
        this.log.debug("Destroying KVRangeWAL store");
        return this.close().thenAccept(v -> {
            this.walStore.destroy();
            this.log.debug("KVRangeWAL store destroyed");
        });
    }

    public void install(ByteString requested, String leader, IRaftNode.IAfterInstalledCallback callback) {
        IKVRangeWAL.RestoreSnapshotTask task = new IKVRangeWAL.RestoreSnapshotTask(requested, leader, callback);
        this.snapRestoreTaskPublisher.onNext((Object)task);
    }

    void onRaftEvent(RaftEvent event) {
        switch (event.type) {
            case COMMIT: {
                this.commitIndexSubject.onNext((Object)((CommitEvent)event));
                break;
            }
            case ELECTION: {
                this.electionPublisher.onNext((Object)((ElectionEvent)event));
                break;
            }
            case STATUS_CHANGED: {
                this.statusPublisher.onNext((Object)((StatusChangedEvent)event).status);
                break;
            }
            case SNAPSHOT_RESTORED: {
                this.snapRestoreEventPublisher.onNext((Object)((SnapshotRestoredEvent)event));
                break;
            }
            case SYNC_STATE_CHANGED: {
                this.syncStatePublisher.onNext((Object)((SyncStateChangedEvent)event).states);
            }
        }
    }

    @VisibleForTesting
    void sendRaftMessages(Map<String, List<RaftMessage>> peerMessages) {
        this.raftMessagesPublisher.onNext(peerMessages);
    }
}

