/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.store;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.bifromq.basecrdt.store.compressor.Compressor;
import org.apache.bifromq.basecrdt.store.proto.AckMessage;
import org.apache.bifromq.basecrdt.store.proto.CRDTStoreMessage;
import org.apache.bifromq.basecrdt.store.proto.DeltaMessage;
import org.apache.bifromq.basecrdt.store.proto.MessagePayload;

public class MessagePayloadUtil {
    public static ByteString compressToPayload(Compressor compressor, AckMessage ackMessage) {
        return compressor.compress(MessagePayload.newBuilder().setAck(ackMessage).build().toByteString());
    }

    public static ByteString compressToPayload(Compressor compressor, DeltaMessage deltaMessage) {
        return compressor.compress(MessagePayload.newBuilder().setDelta(deltaMessage).build().toByteString());
    }

    public static MessagePayload decompress(Compressor compressor, CRDTStoreMessage crdtStoreMessage) {
        try {
            return MessagePayload.parseFrom(compressor.decompress(crdtStoreMessage.getPayload()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Can not decompress message payload from message {}", e);
        }
    }
}

