/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.client;

import com.google.protobuf.ByteString;
import io.reactivex.rxjava3.core.Observable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.baserpc.client.IConnectable;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;
import org.apache.bifromq.retain.client.IRetainClient;
import org.apache.bifromq.retain.rpc.proto.ExpireAllReply;
import org.apache.bifromq.retain.rpc.proto.ExpireAllRequest;
import org.apache.bifromq.retain.rpc.proto.MatchReply;
import org.apache.bifromq.retain.rpc.proto.MatchRequest;
import org.apache.bifromq.retain.rpc.proto.RetainReply;
import org.apache.bifromq.retain.rpc.proto.RetainRequest;
import org.apache.bifromq.retain.rpc.proto.RetainServiceGrpc;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.Message;
import org.apache.bifromq.type.QoS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RetainClient
implements IRetainClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetainClient.class);
    private final IRPCClient rpcClient;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    RetainClient(IRPCClient rpcClient) {
        this.rpcClient = rpcClient;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            log.debug("Stopping retain client");
            log.debug("Stopping rpc client");
            this.rpcClient.stop();
            log.debug("Retain client stopped");
        }
    }

    public Observable<IConnectable.ConnState> connState() {
        return this.rpcClient.connState();
    }

    @Override
    public CompletableFuture<MatchReply> match(MatchRequest request) {
        ITenantMeter tenantMeter = ITenantMeter.get((String)request.getTenantId());
        tenantMeter.recordCount(TenantMetric.MqttRetainMatchCount);
        return this.rpcClient.invoke(request.getTenantId(), null, (Object)request, RetainServiceGrpc.getMatchMethod()).exceptionally(e -> {
            log.debug("Failed to match", e);
            return MatchReply.newBuilder().setReqId(request.getReqId()).setResult(MatchReply.Result.ERROR).build();
        });
    }

    @Override
    public CompletableFuture<RetainReply> retain(long reqId, String topic, QoS qos, ByteString payload, int expirySeconds, ClientInfo publisher) {
        ITenantMeter tenantMeter = ITenantMeter.get((String)publisher.getTenantId());
        if (!payload.isEmpty()) {
            tenantMeter.recordSummary(TenantMetric.MqttIngressRetainBytes, (double)payload.size());
        }
        return ((CompletableFuture)this.rpcClient.invoke(publisher.getTenantId(), null, (Object)RetainRequest.newBuilder().setReqId(reqId).setTopic(topic).setMessage(Message.newBuilder().setMessageId(reqId).setPubQoS(qos).setPayload(payload).setTimestamp(HLC.INST.get()).setExpiryInterval(expirySeconds).build()).setPublisher(publisher).build(), RetainServiceGrpc.getRetainMethod()).exceptionally(e -> {
            log.debug("Failed to retain", e);
            return RetainReply.newBuilder().setReqId(reqId).setResult(RetainReply.Result.ERROR).build();
        })).thenApply(retainReply -> {
            if (retainReply.getResult() == RetainReply.Result.RETAINED) {
                tenantMeter.recordSummary(TenantMetric.MqttRetainedBytes, (double)payload.size());
            }
            return retainReply;
        });
    }

    @Override
    public CompletableFuture<ExpireAllReply> expireAll(ExpireAllRequest request) {
        return this.rpcClient.invoke(request.getTenantId(), null, (Object)request, RetainServiceGrpc.getExpireAllMethod()).exceptionally(e -> {
            log.debug("Failed to retain", e);
            return ExpireAllReply.newBuilder().setReqId(request.getReqId()).setResult(ExpireAllReply.Result.ERROR).build();
        });
    }
}

