/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.replicator.message;

import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite3.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite3.internal.replicator.message.TablePartitionIdMessageBuilder;

class TablePartitionIdMessageDeserializer
implements MessageDeserializer<TablePartitionIdMessage> {
    private final TablePartitionIdMessageBuilder msg;

    TablePartitionIdMessageDeserializer(ReplicaMessagesFactory messageFactory) {
        this.msg = messageFactory.tablePartitionIdMessage();
    }

    @Override
    public Class<TablePartitionIdMessage> klass() {
        return TablePartitionIdMessage.class;
    }

    @Override
    public TablePartitionIdMessage getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("partitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.partitionId(tmp);
                reader.incrementState();
            }
            case 1: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TablePartitionIdMessage.class);
    }
}

