/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.util;

import java.nio.file.Path;
import org.apache.ignite3.internal.lang.IgniteSystemProperties;
import org.apache.ignite3.internal.raft.storage.LogStorageFactory;
import org.apache.ignite3.internal.raft.storage.impl.DefaultLogStorageFactory;
import org.apache.ignite3.internal.raft.storage.logit.LogitLogStorageFactory;
import org.apache.ignite3.raft.jraft.storage.logit.option.StoreOptions;
import org.jetbrains.annotations.TestOnly;

public class SharedLogStorageFactoryUtils {
    public static final String LOGIT_STORAGE_ENABLED_PROPERTY = "LOGIT_STORAGE_ENABLED";
    private static final boolean LOGIT_STORAGE_ENABLED_PROPERTY_DEFAULT = false;

    @TestOnly
    public static LogStorageFactory create(String nodeName, Path logStoragePath) {
        return SharedLogStorageFactoryUtils.create("test", nodeName, logStoragePath, true);
    }

    public static LogStorageFactory create(String factoryName, String nodeName, Path logStoragePath, boolean fsync) {
        return IgniteSystemProperties.getBoolean(LOGIT_STORAGE_ENABLED_PROPERTY, false) ? new LogitLogStorageFactory(nodeName, new StoreOptions(), logStoragePath) : new DefaultLogStorageFactory(factoryName, nodeName, logStoragePath, fsync);
    }
}

